/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.inventory;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.material.MaterialData;

public class ShapedRecipe
implements Recipe {
    private ItemStack output;
    private String[] rows;
    private Map<Character, ItemStack> ingredients = new HashMap<Character, ItemStack>();

    public ShapedRecipe(ItemStack result) {
        this.output = new ItemStack(result);
    }

    public ShapedRecipe shape(String ... shape) {
        Validate.notNull((Object)shape, (String)"Must provide a shape");
        Validate.isTrue((shape.length > 0 && shape.length < 4 ? 1 : 0) != 0, (String)"Crafting recipes should be 1, 2, 3 rows, not ", (long)shape.length);
        for (String row : shape) {
            Validate.notNull((Object)row, (String)"Shape cannot have null rows");
            Validate.isTrue((row.length() > 0 && row.length() < 4 ? 1 : 0) != 0, (String)"Crafting rows should be 1, 2, or 3 characters, not ", (long)row.length());
        }
        this.rows = new String[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            this.rows[i] = shape[i];
        }
        HashMap<Character, ItemStack> newIngredients = new HashMap<Character, ItemStack>();
        for (String row : shape) {
            char[] arr$ = row.toCharArray();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Character c = Character.valueOf(arr$[i$]);
                newIngredients.put(c, this.ingredients.get(c));
            }
        }
        this.ingredients = newIngredients;
        return this;
    }

    public ShapedRecipe setIngredient(char key, MaterialData ingredient) {
        return this.setIngredient(key, ingredient.getItemType(), ingredient.getData());
    }

    public ShapedRecipe setIngredient(char key, Material ingredient) {
        return this.setIngredient(key, ingredient, 0);
    }

    @Deprecated
    public ShapedRecipe setIngredient(char key, Material ingredient, int raw) {
        Validate.isTrue((boolean)this.ingredients.containsKey(Character.valueOf(key)), (String)"Symbol does not appear in the shape:", (long)key);
        if (raw == -1) {
            raw = Short.MAX_VALUE;
        }
        this.ingredients.put(Character.valueOf(key), new ItemStack(ingredient, 1, (short)raw));
        return this;
    }

    public Map<Character, ItemStack> getIngredientMap() {
        HashMap<Character, ItemStack> result = new HashMap<Character, ItemStack>();
        for (Map.Entry<Character, ItemStack> ingredient : this.ingredients.entrySet()) {
            if (ingredient.getValue() == null) {
                result.put(ingredient.getKey(), null);
                continue;
            }
            result.put(ingredient.getKey(), ingredient.getValue().clone());
        }
        return result;
    }

    public String[] getShape() {
        return (String[])this.rows.clone();
    }

    @Override
    public ItemStack getResult() {
        return this.output.clone();
    }
}

