/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4.projectiles;

import java.util.Random;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftItemStack;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.WitherSkull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.util.Vector;

public class CraftBlockProjectileSource
implements BlockProjectileSource {
    private final apb dispenserBlock;

    public CraftBlockProjectileSource(apb dispenserBlock) {
        this.dispenserBlock = dispenserBlock;
    }

    @Override
    public Block getBlock() {
        return this.dispenserBlock.w().getWorld().getBlockAt(this.dispenserBlock.c, this.dispenserBlock.d, this.dispenserBlock.e);
    }

    @Override
    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    @Override
    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        Validate.isTrue((this.getBlock().getType() == Material.DISPENSER ? 1 : 0) != 0, (String)"Block is no longer dispenser");
        cl isourceblock = new cl(this.dispenserBlock.w(), this.dispenserBlock.c, this.dispenserBlock.d, this.dispenserBlock.e);
        cx iposition = akm.a((ck)isourceblock);
        cr enumfacing = akm.b((int)isourceblock.h());
        ahb world = this.dispenserBlock.w();
        zj launch = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            launch = new zj(world, iposition.a(), iposition.b(), iposition.c());
        } else if (Egg.class.isAssignableFrom(projectile)) {
            launch = new zl(world, iposition.a(), iposition.b(), iposition.c());
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            launch = new zm(world);
            launch.b(iposition.a(), iposition.b(), iposition.c());
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            launch = new zn(world, iposition.a(), iposition.b(), iposition.c());
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            launch = new zo(world, iposition.a(), iposition.b(), iposition.c(), CraftItemStack.asNMSCopy(new ItemStack(Material.POTION, 1)));
        } else if (Arrow.class.isAssignableFrom(projectile)) {
            launch = new zc(world, iposition.a(), iposition.b(), iposition.c());
            ((zc)launch).a = 1;
            ((zc)launch).projectileSource = this;
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            double d0 = iposition.a() + (double)((float)enumfacing.c() * 0.3f);
            double d1 = iposition.b() + (double)((float)enumfacing.c() * 0.3f);
            double d2 = iposition.c() + (double)((float)enumfacing.e() * 0.3f);
            Random random = world.s;
            double d3 = random.nextGaussian() * 0.05 + (double)enumfacing.c();
            double d4 = random.nextGaussian() * 0.05 + (double)enumfacing.d();
            double d5 = random.nextGaussian() * 0.05 + (double)enumfacing.e();
            if (SmallFireball.class.isAssignableFrom(projectile)) {
                launch = new zi(world, d0, d1, d2, d3, d4, d5);
            } else if (WitherSkull.class.isAssignableFrom(projectile)) {
                launch = new zp(world);
                launch.b(d0, d1, d2);
                double d6 = qh.a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                ((ze)launch).b = d3 / d6 * 0.1;
                ((ze)launch).c = d4 / d6 * 0.1;
                ((ze)launch).d = d5 / d6 * 0.1;
            } else {
                launch = new zg(world);
                launch.b(d0, d1, d2);
                double d6 = qh.a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                ((ze)launch).b = d3 / d6 * 0.1;
                ((ze)launch).c = d4 / d6 * 0.1;
                ((ze)launch).d = d5 / d6 * 0.1;
            }
            ((ze)launch).projectileSource = this;
        }
        Validate.notNull((Object)launch, (String)"Projectile not supported");
        if (launch instanceof zh) {
            if (launch instanceof zk) {
                ((zk)launch).projectileSource = this;
            }
            float a2 = 6.0f;
            float b = 1.1f;
            if (launch instanceof zo || launch instanceof ThrownExpBottle) {
                a2 *= 0.5f;
                b *= 1.25f;
            }
            ((zh)launch).c((double)enumfacing.c(), (double)((float)enumfacing.d() + 0.1f), (double)enumfacing.e(), b, a2);
        }
        if (velocity != null) {
            ((Projectile)((Object)launch.getBukkitEntity())).setVelocity(velocity);
        }
        world.d((sa)launch);
        return (T)((Projectile)((Object)launch.getBukkitEntity()));
    }
}

