/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4.entity;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.cauldron.entity.CraftCustomEntity;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.FakePlayerFactory;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftAmbient;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftArrow;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftBat;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftBlaze;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftBoat;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftCaveSpider;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftChicken;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftComplexPart;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftCow;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftCreeper;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEgg;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEnderCrystal;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEnderDragonPart;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEnderPearl;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEnderSignal;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftExperienceOrb;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftFallingSand;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftFireball;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftFirework;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftFish;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftFlying;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftGhast;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftGiant;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftHanging;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftHorse;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftIronGolem;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftItem;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftItemFrame;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftLargeFireball;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftLeash;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftLightningStrike;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftMagmaCube;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftMinecart;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftMinecartChest;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftMinecartCommand;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftMinecartFurnace;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftMinecartHopper;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftMinecartMobSpawner;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftMinecartRideable;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftMinecartTNT;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftMonster;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftMushroomCow;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftOcelot;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftPainting;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftPig;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftPigZombie;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftProjectile;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftSheep;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftSilverfish;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftSkeleton;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftSlime;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftSmallFireball;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftSnowball;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftSnowman;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftSpider;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftSquid;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftTNTPrimed;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftTameableAnimal;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftThrownExpBottle;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftThrownPotion;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftWaterMob;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftWeather;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftWitch;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftWither;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftWitherSkull;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftWolf;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftZombie;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public abstract class CraftEntity
implements Entity {
    protected final CraftServer server;
    protected sa entity;
    private EntityDamageEvent lastDamageEvent;
    private final Entity.Spigot spigot = new Entity.Spigot(){

        @Override
        public boolean isInvulnerable() {
            return CraftEntity.this.getHandle().aw();
        }
    };

    public CraftEntity(CraftServer server, sa entity) {
        this.server = server;
        this.entity = entity;
    }

    public static CraftEntity getEntity(CraftServer server, sa entity) {
        if (entity instanceof sv) {
            if (entity instanceof yz) {
                if (entity instanceof mw) {
                    return new CraftPlayer(server, (mw)entity);
                }
                return new CraftPlayer(server, (mw)FakePlayerFactory.get((mt)DimensionManager.getWorld((int)entity.o.t.i), (GameProfile)((yz)entity).bJ()));
            }
            if (entity instanceof td) {
                if (entity instanceof wf) {
                    if (entity instanceof wg) {
                        return new CraftChicken(server, (wg)entity);
                    }
                    if (entity instanceof wh) {
                        if (entity instanceof wm) {
                            return new CraftMushroomCow(server, (wm)entity);
                        }
                        return new CraftCow(server, (wh)entity);
                    }
                    if (entity instanceof wo) {
                        return new CraftPig(server, (wo)entity);
                    }
                    if (entity instanceof tg) {
                        if (entity instanceof wv) {
                            return new CraftWolf(server, (wv)entity);
                        }
                        if (entity instanceof wn) {
                            return new CraftOcelot(server, (wn)entity);
                        }
                        return new CraftTameableAnimal(server, (tg)entity);
                    }
                    if (entity instanceof wp) {
                        return new CraftSheep(server, (wp)entity);
                    }
                    if (entity instanceof wi) {
                        return new CraftHorse(server, (wi)entity);
                    }
                    return new CraftAnimals(server, (wf)entity);
                }
                if (entity instanceof yg) {
                    if (entity instanceof yq) {
                        if (entity instanceof yh) {
                            return new CraftPigZombie(server, (yh)entity);
                        }
                        return new CraftZombie(server, (yq)entity);
                    }
                    if (entity instanceof xz) {
                        return new CraftCreeper(server, (xz)entity);
                    }
                    if (entity instanceof ya) {
                        return new CraftEnderman(server, (ya)entity);
                    }
                    if (entity instanceof yk) {
                        return new CraftSilverfish(server, (yk)entity);
                    }
                    if (entity instanceof ye) {
                        return new CraftGiant(server, (ye)entity);
                    }
                    if (entity instanceof yl) {
                        return new CraftSkeleton(server, (yl)entity);
                    }
                    if (entity instanceof xx) {
                        return new CraftBlaze(server, (xx)entity);
                    }
                    if (entity instanceof yp) {
                        return new CraftWitch(server, (yp)entity);
                    }
                    if (entity instanceof xc) {
                        return new CraftWither(server, (xc)entity);
                    }
                    if (entity instanceof yn) {
                        if (entity instanceof xy) {
                            return new CraftCaveSpider(server, (xy)entity);
                        }
                        return new CraftSpider(server, (yn)entity);
                    }
                    return new CraftMonster(server, (yg)entity);
                }
                if (entity instanceof wu) {
                    if (entity instanceof ws) {
                        return new CraftSquid(server, (ws)entity);
                    }
                    return new CraftWaterMob(server, (wu)entity);
                }
                if (entity instanceof wl) {
                    if (entity instanceof wr) {
                        return new CraftSnowman(server, (wr)entity);
                    }
                    if (entity instanceof wt) {
                        return new CraftIronGolem(server, (wt)entity);
                    }
                    return new CraftLivingEntity(server, (sv)entity);
                }
                if (entity instanceof yv) {
                    return new CraftVillager(server, (yv)entity);
                }
                return new CraftCreature(server, (td)entity);
            }
            if (entity instanceof ym) {
                if (entity instanceof yf) {
                    return new CraftMagmaCube(server, (yf)entity);
                }
                return new CraftSlime(server, (ym)entity);
            }
            if (entity instanceof sr) {
                if (entity instanceof yd) {
                    return new CraftGhast(server, (yd)entity);
                }
                return new CraftFlying(server, (sr)entity);
            }
            if (entity instanceof xa) {
                return new CraftEnderDragon(server, (xa)entity);
            }
            if (entity instanceof wd) {
                if (entity instanceof we) {
                    return new CraftBat(server, (we)entity);
                }
                return new CraftAmbient(server, (wd)entity);
            }
            return new CraftLivingEntity(server, (sv)entity);
        }
        if (entity instanceof wy) {
            wy part = (wy)entity;
            if (part.a instanceof xa) {
                return new CraftEnderDragonPart(server, (wy)entity);
            }
            return new CraftComplexPart(server, (wy)entity);
        }
        if (entity instanceof sq) {
            return new CraftExperienceOrb(server, (sq)entity);
        }
        if (entity instanceof zc) {
            return new CraftArrow(server, (zc)entity);
        }
        if (entity instanceof xi) {
            return new CraftBoat(server, (xi)entity);
        }
        if (entity instanceof zk) {
            if (entity instanceof zl) {
                return new CraftEgg(server, (zl)entity);
            }
            if (entity instanceof zj) {
                return new CraftSnowball(server, (zj)entity);
            }
            if (entity instanceof zo) {
                return new CraftThrownPotion(server, (zo)entity);
            }
            if (entity instanceof zm) {
                return new CraftEnderPearl(server, (zm)entity);
            }
            if (entity instanceof zn) {
                return new CraftThrownExpBottle(server, (zn)entity);
            }
            return new CraftProjectile(server, (sa)((zk)entity));
        }
        if (entity instanceof xj) {
            return new CraftFallingSand(server, (xj)entity);
        }
        if (entity instanceof ze) {
            if (entity instanceof zi) {
                return new CraftSmallFireball(server, (zi)entity);
            }
            if (entity instanceof zg) {
                return new CraftLargeFireball(server, (zg)entity);
            }
            if (entity instanceof zp) {
                return new CraftWitherSkull(server, (zp)entity);
            }
            return new CraftFireball(server, (ze)entity);
        }
        if (entity instanceof zd) {
            return new CraftEnderSignal(server, (zd)entity);
        }
        if (entity instanceof wz) {
            return new CraftEnderCrystal(server, (wz)entity);
        }
        if (entity instanceof xe) {
            return new CraftFish(server, (xe)entity);
        }
        if (entity instanceof xk) {
            return new CraftItem(server, (xk)entity);
        }
        if (entity instanceof xg) {
            if (entity instanceof xh) {
                return new CraftLightningStrike(server, (xh)entity);
            }
            return new CraftWeather(server, (xg)entity);
        }
        if (entity instanceof xl) {
            if (entity instanceof xq) {
                return new CraftMinecartFurnace(server, (xq)entity);
            }
            if (entity instanceof xm) {
                return new CraftMinecartChest(server, (xm)entity);
            }
            if (entity instanceof xv) {
                return new CraftMinecartTNT(server, (xv)entity);
            }
            if (entity instanceof xr) {
                return new CraftMinecartHopper(server, (xr)entity);
            }
            if (entity instanceof xt) {
                return new CraftMinecartMobSpawner(server, (xt)entity);
            }
            if (entity instanceof xs) {
                return new CraftMinecartRideable(server, (xl)((xs)entity));
            }
            if (entity instanceof xn) {
                return new CraftMinecartCommand(server, (xn)entity);
            }
            return new CraftMinecart(server, (xl)entity);
        }
        if (entity instanceof ss) {
            if (entity instanceof tb) {
                return new CraftPainting(server, (tb)entity);
            }
            if (entity instanceof st) {
                return new CraftItemFrame(server, (st)entity);
            }
            if (entity instanceof su) {
                return new CraftLeash(server, (su)entity);
            }
            return new CraftHanging(server, (ss)entity);
        }
        if (entity instanceof xw) {
            return new CraftTNTPrimed(server, (xw)entity);
        }
        if (entity instanceof zf) {
            return new CraftFirework(server, (zf)entity);
        }
        if (entity instanceof sa) {
            return new CraftCustomEntity(server, entity);
        }
        throw new AssertionError((Object)("Unknown entity " + entity == null ? null : entity.getClass() + ": " + entity));
    }

    public static Class<? extends Entity> getEntityClass(Class<? extends sa> nmsClass) {
        if (sv.class.isAssignableFrom(nmsClass)) {
            if (yz.class.isAssignableFrom(nmsClass)) {
                if (mw.class.isAssignableFrom(nmsClass)) {
                    return CraftPlayer.class;
                }
                return CraftPlayer.class;
            }
            if (td.class.isAssignableFrom(nmsClass)) {
                if (wf.class.isAssignableFrom(nmsClass)) {
                    if (wg.class.isAssignableFrom(nmsClass)) {
                        return CraftChicken.class;
                    }
                    if (wh.class.isAssignableFrom(nmsClass)) {
                        if (wm.class.isAssignableFrom(nmsClass)) {
                            return CraftMushroomCow.class;
                        }
                        return CraftCow.class;
                    }
                    if (wo.class.isAssignableFrom(nmsClass)) {
                        return CraftPig.class;
                    }
                    if (tg.class.isAssignableFrom(nmsClass)) {
                        if (wv.class.isAssignableFrom(nmsClass)) {
                            return CraftWolf.class;
                        }
                        if (wn.class.isAssignableFrom(nmsClass)) {
                            return CraftOcelot.class;
                        }
                        return CraftTameableAnimal.class;
                    }
                    if (wp.class.isAssignableFrom(nmsClass)) {
                        return CraftSheep.class;
                    }
                    if (wi.class.isAssignableFrom(nmsClass)) {
                        return CraftHorse.class;
                    }
                    return CraftAnimals.class;
                }
                if (yg.class.isAssignableFrom(nmsClass)) {
                    if (yq.class.isAssignableFrom(nmsClass)) {
                        if (yh.class.isAssignableFrom(nmsClass)) {
                            return CraftPigZombie.class;
                        }
                        return CraftZombie.class;
                    }
                    if (xz.class.isAssignableFrom(nmsClass)) {
                        return CraftCreeper.class;
                    }
                    if (ya.class.isAssignableFrom(nmsClass)) {
                        return CraftEnderman.class;
                    }
                    if (yk.class.isAssignableFrom(nmsClass)) {
                        return CraftSilverfish.class;
                    }
                    if (ye.class.isAssignableFrom(nmsClass)) {
                        return CraftGiant.class;
                    }
                    if (yl.class.isAssignableFrom(nmsClass)) {
                        return CraftSkeleton.class;
                    }
                    if (xx.class.isAssignableFrom(nmsClass)) {
                        return CraftBlaze.class;
                    }
                    if (yp.class.isAssignableFrom(nmsClass)) {
                        return CraftWitch.class;
                    }
                    if (xc.class.isAssignableFrom(nmsClass)) {
                        return CraftWither.class;
                    }
                    if (yn.class.isAssignableFrom(nmsClass)) {
                        if (xy.class.isAssignableFrom(nmsClass)) {
                            return CraftCaveSpider.class;
                        }
                        return CraftSpider.class;
                    }
                    return CraftMonster.class;
                }
                if (wu.class.isAssignableFrom(nmsClass)) {
                    if (ws.class.isAssignableFrom(nmsClass)) {
                        return CraftSquid.class;
                    }
                    return CraftWaterMob.class;
                }
                if (wl.class.isAssignableFrom(nmsClass)) {
                    if (wr.class.isAssignableFrom(nmsClass)) {
                        return CraftSnowman.class;
                    }
                    if (wt.class.isAssignableFrom(nmsClass)) {
                        return CraftIronGolem.class;
                    }
                    return CraftLivingEntity.class;
                }
                if (yv.class.isAssignableFrom(nmsClass)) {
                    return CraftVillager.class;
                }
                return CraftCreature.class;
            }
            if (ym.class.isAssignableFrom(nmsClass)) {
                if (yf.class.isAssignableFrom(nmsClass)) {
                    return CraftMagmaCube.class;
                }
                return CraftSlime.class;
            }
            if (sr.class.isAssignableFrom(nmsClass)) {
                if (yd.class.isAssignableFrom(nmsClass)) {
                    return CraftGhast.class;
                }
                return CraftFlying.class;
            }
            if (xa.class.isAssignableFrom(nmsClass)) {
                return CraftEnderDragon.class;
            }
            if (wd.class.isAssignableFrom(nmsClass)) {
                if (we.class.isAssignableFrom(nmsClass)) {
                    return CraftBat.class;
                }
                return CraftAmbient.class;
            }
            return CraftLivingEntity.class;
        }
        if (wy.class.isAssignableFrom(nmsClass)) {
            return CraftComplexPart.class;
        }
        if (sq.class.isAssignableFrom(nmsClass)) {
            return CraftExperienceOrb.class;
        }
        if (zc.class.isAssignableFrom(nmsClass)) {
            return CraftArrow.class;
        }
        if (xi.class.isAssignableFrom(nmsClass)) {
            return CraftBoat.class;
        }
        if (zk.class.isAssignableFrom(nmsClass)) {
            if (zl.class.isAssignableFrom(nmsClass)) {
                return CraftEgg.class;
            }
            if (zj.class.isAssignableFrom(nmsClass)) {
                return CraftSnowball.class;
            }
            if (zo.class.isAssignableFrom(nmsClass)) {
                return CraftThrownPotion.class;
            }
            if (zm.class.isAssignableFrom(nmsClass)) {
                return CraftEnderPearl.class;
            }
            if (zn.class.isAssignableFrom(nmsClass)) {
                return CraftThrownExpBottle.class;
            }
            return CraftProjectile.class;
        }
        if (xj.class.isAssignableFrom(nmsClass)) {
            return CraftFallingSand.class;
        }
        if (ze.class.isAssignableFrom(nmsClass)) {
            if (zi.class.isAssignableFrom(nmsClass)) {
                return CraftSmallFireball.class;
            }
            if (zg.class.isAssignableFrom(nmsClass)) {
                return CraftLargeFireball.class;
            }
            if (zp.class.isAssignableFrom(nmsClass)) {
                return CraftWitherSkull.class;
            }
            return CraftFireball.class;
        }
        if (zd.class.isAssignableFrom(nmsClass)) {
            return CraftEnderSignal.class;
        }
        if (wz.class.isAssignableFrom(nmsClass)) {
            return CraftEnderCrystal.class;
        }
        if (xe.class.isAssignableFrom(nmsClass)) {
            return CraftFish.class;
        }
        if (xk.class.isAssignableFrom(nmsClass)) {
            return CraftItem.class;
        }
        if (xg.class.isAssignableFrom(nmsClass)) {
            if (xh.class.isAssignableFrom(nmsClass)) {
                return CraftLightningStrike.class;
            }
            return CraftWeather.class;
        }
        if (xl.class.isAssignableFrom(nmsClass)) {
            if (xq.class.isAssignableFrom(nmsClass)) {
                return CraftMinecartFurnace.class;
            }
            if (xm.class.isAssignableFrom(nmsClass)) {
                return CraftMinecartChest.class;
            }
            if (xv.class.isAssignableFrom(nmsClass)) {
                return CraftMinecartTNT.class;
            }
            if (xr.class.isAssignableFrom(nmsClass)) {
                return CraftMinecartHopper.class;
            }
            if (xt.class.isAssignableFrom(nmsClass)) {
                return CraftMinecartMobSpawner.class;
            }
            if (xs.class.isAssignableFrom(nmsClass)) {
                return CraftMinecartRideable.class;
            }
            if (xn.class.isAssignableFrom(nmsClass)) {
                return CraftMinecartCommand.class;
            }
            return CraftMinecart.class;
        }
        if (ss.class.isAssignableFrom(nmsClass)) {
            if (tb.class.isAssignableFrom(nmsClass)) {
                return CraftPainting.class;
            }
            if (st.class.isAssignableFrom(nmsClass)) {
                return CraftItemFrame.class;
            }
            if (su.class.isAssignableFrom(nmsClass)) {
                return CraftLeash.class;
            }
            return CraftHanging.class;
        }
        if (xw.class.isAssignableFrom(nmsClass)) {
            return CraftTNTPrimed.class;
        }
        if (zf.class.isAssignableFrom(nmsClass)) {
            return CraftFirework.class;
        }
        if (sa.class.isAssignableFrom(nmsClass)) {
            return CraftCustomEntity.class;
        }
        throw new AssertionError("Unknown entity class " + nmsClass == null ? null : nmsClass);
    }

    public static void initMappings() {
        for (Map.Entry entry : EntityRegistry.entityTypeMap.entrySet()) {
            Class entityClass = (Class)entry.getKey();
            String entityName = (String)entry.getValue();
            int entityId = CraftEntity.getEntityTypeIDfromClass(entityClass);
            Class<? extends Entity> bukkitEntityClass = CraftEntity.getEntityClass(entityClass);
            EnumHelper.addBukkitEntityType((String)entityName, bukkitEntityClass, (int)entityId, (boolean)false);
        }
    }

    private static int getEntityTypeIDfromClass(Class entityClass) {
        Map classToIDMapping = (Map)ReflectionHelper.getPrivateValue(sg.class, null, (String[])new String[]{"field_75624_e", "classToIDMapping"});
        if (classToIDMapping.containsKey(entityClass)) {
            return (Integer)classToIDMapping.get(entityClass);
        }
        Map IDtoClassMapping = (Map)ReflectionHelper.getPrivateValue(sg.class, null, (String[])new String[]{"field_75623_d", "IDtoClassMapping"});
        for (Map.Entry entry : IDtoClassMapping.entrySet()) {
            int entityId = (Integer)entry.getKey();
            Class thisEntityClass = (Class)entry.getValue();
            if (!thisEntityClass.getName().equals(entityClass.getName())) continue;
            return entityId;
        }
        return -Math.abs(entityClass.getName().hashCode() ^ entityClass.getName().hashCode() >>> 16);
    }

    @Override
    public Location getLocation() {
        return new Location(this.getWorld(), this.entity.s, this.entity.t, this.entity.u, this.entity.y, this.entity.z);
    }

    @Override
    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX(this.entity.s);
            loc.setY(this.entity.t);
            loc.setZ(this.entity.u);
            loc.setYaw(this.entity.y);
            loc.setPitch(this.entity.z);
        }
        return loc;
    }

    @Override
    public Vector getVelocity() {
        return new Vector(this.entity.v, this.entity.w, this.entity.x);
    }

    @Override
    public void setVelocity(Vector vel) {
        this.entity.v = vel.getX();
        this.entity.w = vel.getY();
        this.entity.x = vel.getZ();
        this.entity.H = true;
    }

    @Override
    public boolean isOnGround() {
        if (this.entity instanceof zc) {
            return ((zc)this.entity).isInGround();
        }
        return this.entity.D;
    }

    @Override
    public World getWorld() {
        if (this.entity.o.getWorld() == null) {
            return DimensionManager.getWorld((int)0).getWorld();
        }
        return this.entity.o.getWorld();
    }

    @Override
    public boolean teleport(Location location) {
        return this.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (this.entity.m != null || this.entity.l != null || this.entity.K) {
            return false;
        }
        this.entity.o = ((CraftWorld)location.getWorld()).getHandle();
        this.entity.a(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        return true;
    }

    @Override
    public boolean teleport(Entity destination) {
        return this.teleport(destination.getLocation());
    }

    @Override
    public boolean teleport(Entity destination, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(destination.getLocation(), cause);
    }

    @Override
    public List<Entity> getNearbyEntities(double x, double y2, double z) {
        List notchEntityList = this.entity.o.b(this.entity, this.entity.C.b(x, y2, z));
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(notchEntityList.size());
        for (sa e : notchEntityList) {
            bukkitEntityList.add(e.getBukkitEntity());
        }
        return bukkitEntityList;
    }

    @Override
    public int getEntityId() {
        return this.entity.y();
    }

    @Override
    public int getFireTicks() {
        return this.entity.e;
    }

    @Override
    public int getMaxFireTicks() {
        return this.entity.ab;
    }

    @Override
    public void setFireTicks(int ticks) {
        this.entity.e = ticks;
    }

    @Override
    public void remove() {
        this.entity.K = true;
    }

    @Override
    public boolean isDead() {
        return !this.entity.Z();
    }

    @Override
    public boolean isValid() {
        return this.entity.Z() && this.entity.valid;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    public Vector getMomentum() {
        return this.getVelocity();
    }

    public void setMomentum(Vector value) {
        this.setVelocity(value);
    }

    @Override
    public Entity getPassenger() {
        return this.isEmpty() ? null : this.getHandle().l.getBukkitEntity();
    }

    @Override
    public boolean setPassenger(Entity passenger) {
        if (passenger instanceof CraftEntity) {
            ((CraftEntity)passenger).getHandle().setPassengerOf(this.getHandle());
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.getHandle().l == null;
    }

    @Override
    public boolean eject() {
        if (this.getHandle().l == null) {
            return false;
        }
        this.getHandle().l.setPassengerOf(null);
        return true;
    }

    @Override
    public float getFallDistance() {
        return this.getHandle().R;
    }

    @Override
    public void setFallDistance(float distance) {
        this.getHandle().R = distance;
    }

    @Override
    public void setLastDamageCause(EntityDamageEvent event) {
        this.lastDamageEvent = event;
    }

    @Override
    public EntityDamageEvent getLastDamageCause() {
        return this.lastDamageEvent;
    }

    @Override
    public UUID getUniqueId() {
        return this.getHandle().ar;
    }

    @Override
    public int getTicksLived() {
        return this.getHandle().aa;
    }

    @Override
    public void setTicksLived(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Age must be at least 1 tick");
        }
        this.getHandle().aa = value;
    }

    public sa getHandle() {
        return this.entity;
    }

    @Override
    public void playEffect(EntityEffect type) {
        this.getHandle().o.a(this.getHandle(), type.getData());
    }

    public void setHandle(sa entity) {
        this.entity = entity;
    }

    public String toString() {
        return "CraftEntity{id=" + this.getEntityId() + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftEntity other = (CraftEntity)obj;
        return this.getEntityId() == other.getEntityId();
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + this.getEntityId();
        return hash;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getEntityMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getEntityMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getEntityMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getEntityMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean isInsideVehicle() {
        return this.getHandle().m != null;
    }

    @Override
    public boolean leaveVehicle() {
        if (this.getHandle().m == null) {
            return false;
        }
        this.getHandle().setPassengerOf(null);
        return true;
    }

    @Override
    public Entity getVehicle() {
        if (this.getHandle().m == null) {
            return null;
        }
        return this.getHandle().m.getBukkitEntity();
    }

    @Override
    public Entity.Spigot spigot() {
        return this.spigot;
    }
}

