/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.VanillaCommand;
import org.bukkit.entity.Player;

public class SetWorldSpawnCommand
extends VanillaCommand {
    public SetWorldSpawnCommand() {
        super("setworldspawn");
        this.description = "Sets a worlds's spawn point. If no coordinates are specified, the player's coordinates will be used.";
        this.usageMessage = "/setworldspawn OR /setworldspawn <x> <y> <z>";
        this.setPermission("bukkit.command.setworldspawn");
    }

    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        int z;
        int y;
        int x;
        World world;
        if (!this.testPermission(sender)) {
            return true;
        }
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
            world = player.getWorld();
        } else {
            world = Bukkit.getWorlds().get(0);
        }
        if (args.length == 0) {
            if (player == null) {
                sender.sendMessage("You can only perform this command as a player");
                return true;
            }
            Location location = player.getLocation();
            x = location.getBlockX();
            y = location.getBlockY();
            z = location.getBlockZ();
        } else if (args.length == 3) {
            try {
                x = this.getInteger(sender, args[0], -30000000, 30000000, true);
                y = this.getInteger(sender, args[1], 0, world.getMaxHeight(), true);
                z = this.getInteger(sender, args[2], -30000000, 30000000, true);
            }
            catch (NumberFormatException ex) {
                sender.sendMessage(ex.getMessage());
                return true;
            }
        } else {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        world.setSpawnLocation(x, y, z);
        Command.broadcastCommandMessage(sender, "Set world " + world.getName() + "'s spawnpoint to (" + x + ", " + y + ", " + z + ")");
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        return ImmutableList.of();
    }
}

