/*
 * Decompiled with CFR 0.152.
 */
package org.Ziron5.Main;

import java.util.List;
import java.util.UUID;
import org.Ziron5.Main.MrVaro;
import org.Ziron5.Main.TimerClass;
import org.Ziron5.Main.VaroPlayerStorage;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class VaroPlayer {
    MrVaro plugin;
    UUID uuid;
    String name;
    boolean dead;
    String team;
    int strikes;
    List<String> strikereasons;
    boolean idle = true;
    int nocontact;
    int left;
    long lastlogout;
    int relogs;
    Scoreboard scoreboard;
    TimerClass timer;
    List<String> kills;

    public VaroPlayer(MrVaro plugin, UUID uuid, String name, boolean dead, String team, int strikes, List<String> strikereasons, int nocontact, long lastlogout, List<String> kills) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.name = name;
        this.dead = dead;
        this.team = team;
        this.strikes = strikes;
        this.strikereasons = strikereasons;
        this.nocontact = nocontact;
        this.left = plugin.getSettings().getSessiontime();
        this.lastlogout = lastlogout;
        this.relogs = 0;
        this.kills = kills;
    }

    public boolean isDead() {
        return this.dead;
    }

    public void setDead(boolean dead) {
        this.dead = dead;
        YamlConfiguration players = this.plugin.getPlayerConfig();
        players.set(String.valueOf(this.getUuid().toString()) + ".dead", (Object)dead);
        this.plugin.savePlayerConfig(players);
    }

    public int getStrikes() {
        return this.strikes;
    }

    public void setStrikes(int strikes) {
        this.strikes = strikes;
    }

    public int getNocontact() {
        return this.nocontact;
    }

    public void setNocontact(int nocontact) {
        this.nocontact = nocontact;
    }

    public long getLastlogout() {
        return this.lastlogout;
    }

    public void setLastlogout(long lastlogout) {
        this.lastlogout = lastlogout;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Player getPlayer() {
        return Bukkit.getServer().getPlayer(this.getUuid());
    }

    public String getTeam() {
        return this.team;
    }

    public String getName() {
        return this.name;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
        this.updateScoreboard(left, false);
    }

    public void reLogin() {
        this.left = this.plugin.getSettings().getSessiontime();
    }

    public List<String> getStrikereasons() {
        return this.strikereasons;
    }

    public void setStrikereasons(List<String> reasons) {
        this.strikereasons = reasons;
    }

    public void addStrike(String reason, boolean online) {
        this.setStrikes(this.getStrikes() + 1);
        this.strikereasons.add(reason);
        this.save(online);
        int strikes = this.getStrikes();
        if (this.plugin.getSettings().isTeamstrikes()) {
            strikes = this.plugin.getRegistration().getTeamStrikes(this.getTeam());
        }
        if (strikes >= this.plugin.getSettings().getStrikes()) {
            if (Bukkit.getServer().getPlayer(this.getName()) != null) {
                UUID uuid = Bukkit.getServer().getPlayer(this.getName()).getUniqueId();
                if (VaroPlayerStorage.getAllUUIDs().contains(uuid)) {
                    VaroPlayer vp2 = VaroPlayerStorage.getVaroPlayer(uuid);
                    if (vp2.getTimer() == null) {
                        VaroPlayerStorage.removePlayer(uuid);
                    } else {
                        vp2.getTimer().logout(false, null);
                    }
                }
            }
            if (this.plugin.getSettings().isTeamstrikes()) {
                for (VaroPlayer vpt : VaroPlayerStorage.getAllVaroPlayers()) {
                    if (!vpt.getTeam().equals(this.getTeam())) continue;
                    vpt.getPlayer().kickPlayer(ChatColor.RED + "Dein Team hat die maximale Anzahl von " + this.plugin.getSettings().getStrikes() + " Strikes erreicht\nEs ist damit aus dem Projekt ausgeschieden.");
                }
                if (this.getPlayer() != null) {
                    this.getPlayer().kickPlayer(ChatColor.RED + "Dein Team hat die maximale Anzahl von " + this.plugin.getSettings().getStrikes() + " Strikes erreicht\nEs ist damit aus dem Projekt ausgeschieden.");
                }
                this.plugin.log("Server: Team " + this.getTeam() + " has been banned for too many strikes");
            } else {
                if (this.getPlayer() != null) {
                    this.getPlayer().kickPlayer(ChatColor.RED + "Du hast die maximale Anzahl von " + this.plugin.getSettings().getStrikes() + " Strikes erreicht\nDu bist damit aus dem Projekt ausgeschieden.");
                }
                this.plugin.log("Server: Player " + this.getName() + " has been banned for too many strikes");
            }
            this.plugin.winGame();
        }
    }

    public int getRelogs() {
        return this.relogs;
    }

    public void setRelogs(int relogs) {
        this.relogs = relogs;
    }

    public TimerClass getTimer() {
        return this.timer;
    }

    public void setTimer(TimerClass timer) {
        this.timer = timer;
    }

    public List<String> getKills() {
        return this.kills;
    }

    public void addKill(VaroPlayer vp) {
        this.kills.add(String.valueOf(Bukkit.getServer().getPlayer(vp.getUuid()).getName()) + "%" + vp.getTeam());
    }

    public void setIdle(boolean idle) {
        this.idle = idle;
    }

    public boolean getIdle() {
        return this.idle;
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public void setupScoreboard() {
        this.scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        Team scteam = this.scoreboard.registerNewTeam("team");
        scteam.addEntry(this.name);
        Objective o = this.scoreboard.registerNewObjective("timer", "dummy");
        int min = this.plugin.getSettings().getSessiontime() / 60;
        int sec = this.plugin.getSettings().getSessiontime() % 60;
        String minutes = String.valueOf(min);
        String seconds = String.valueOf(sec);
        if (minutes.length() == 1) {
            minutes = "0" + minutes;
        }
        if (seconds.length() == 1) {
            seconds = "0" + seconds;
        }
        o.setDisplayName(ChatColor.YELLOW + minutes + ":" + seconds);
        if (this.plugin.getSettings().isSidebarname()) {
            o.getScore("      \u00a76MrVaro").setScore(2);
            o.getScore("    \u00a76by \u00a73Ziron5").setScore(1);
            o.getScore("\u00a76YT: \u00a7bmr_mazino").setScore(0);
        } else {
            o.getScore("     \u00a76MrVaro").setScore(0);
        }
        o.setDisplaySlot(DisplaySlot.SIDEBAR);
        Bukkit.getServer().getPlayer(this.uuid).setScoreboard(this.scoreboard);
    }

    public void updateScoreboard(int time, boolean spawnprotection) {
        ChatColor cc;
        int min = time / 60;
        int sec = time % 60;
        String minutes = String.valueOf(min);
        String seconds = String.valueOf(sec);
        if (minutes.length() == 1) {
            minutes = "0" + minutes;
        }
        if (seconds.length() == 1) {
            seconds = "0" + seconds;
        }
        String minus = "";
        if (spawnprotection) {
            cc = ChatColor.RED;
            minus = "-";
        } else {
            cc = ChatColor.YELLOW;
        }
        this.getScoreboard().getObjective("timer").setDisplayName(cc + minus + minutes + ":" + seconds);
    }

    public void save(boolean reload) {
        YamlConfiguration players = this.plugin.getPlayerConfig();
        players.set(String.valueOf(this.getUuid().toString()) + ".last-logout", (Object)this.getLastlogout());
        players.set(String.valueOf(this.getUuid().toString()) + ".strikes.amount", (Object)this.getStrikes());
        players.set(String.valueOf(this.getUuid().toString()) + ".strikes.reasons", this.getStrikereasons());
        players.set(String.valueOf(this.getUuid().toString()) + ".idle", (Object)this.getNocontact());
        players.set(String.valueOf(this.getUuid().toString()) + ".kills", this.getKills());
        this.plugin.savePlayerConfig(players);
        if (reload) {
            this.reload();
        }
    }

    public void reload() {
        if (VaroPlayerStorage.getAllUUIDs().contains(this.uuid)) {
            VaroPlayerStorage.removePlayer(this.uuid);
            VaroPlayerStorage.addPlayer(this.uuid, this.plugin.getRegistration().loadVaroPlayer(this.uuid));
        }
    }
}

