/*
 * Decompiled with CFR 0.152.
 */
package org.Ziron5.Main;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.UUID;

public class UUIDFetcher {
    public static JsonObject getJsonObject(String name) throws IOException {
        URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + name);
        InputStream is = url.openStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        String jsonString = sb.toString();
        JsonElement je = new JsonParser().parse(jsonString);
        if (!je.isJsonObject()) {
            return null;
        }
        return je.getAsJsonObject();
    }

    public static UUID getUUID(String name) throws IOException {
        JsonObject jo = UUIDFetcher.getJsonObject(name);
        if (jo == null) {
            return null;
        }
        String rawUUID = jo.get("id").toString().replaceAll("\"", "").substring(0);
        rawUUID = String.valueOf(rawUUID.substring(0, 8)) + "-" + rawUUID.substring(8, 12) + "-" + rawUUID.substring(12, 16) + "-" + rawUUID.substring(16, 20) + "-" + rawUUID.substring(20, 32);
        UUID uuid = UUID.fromString(rawUUID);
        return uuid;
    }

    public static String getName(String name) throws IOException {
        JsonObject jo = UUIDFetcher.getJsonObject(name);
        String playername = jo.get("name").toString().replace("\"", "");
        return playername;
    }
}

