/*
 * Decompiled with CFR 0.152.
 */
package org.Ziron5.Main;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.Ziron5.Main.MrVaro;
import org.Ziron5.Main.UUIDFetcher;
import org.Ziron5.Main.VaroPlayer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class Registration {
    MrVaro plugin;

    public Registration(MrVaro plugin) {
        this.plugin = plugin;
    }

    public void registerPlayer(String name, String teamName) throws IOException {
        YamlConfiguration players = this.plugin.getPlayerConfig();
        UUID uuid = UUIDFetcher.getUUID(name);
        String id = uuid.toString();
        players.set(String.valueOf(id) + ".name", (Object)UUIDFetcher.getName(name));
        players.set(String.valueOf(id) + ".team", (Object)teamName);
        players.set(String.valueOf(id) + ".dead", (Object)false);
        players.set(String.valueOf(id) + ".last-logout", (Object)-1L);
        players.set(String.valueOf(id) + ".strikes.amount", (Object)0);
        players.set(String.valueOf(id) + ".idle", (Object)0);
        this.plugin.savePlayerConfig(players);
    }

    public void deleteTeammembers(String team) {
        YamlConfiguration players = this.plugin.getPlayerConfig();
        for (String uuid : players.getKeys(false)) {
            if (!players.getString(String.valueOf(uuid) + ".team").equalsIgnoreCase(team)) continue;
            players.set(uuid, null);
        }
        this.plugin.savePlayerConfig(players);
    }

    public ArrayList<String> getAllTeams() {
        ArrayList<String> teams = new ArrayList<String>();
        YamlConfiguration players = this.plugin.getPlayerConfig();
        if (players.getKeys(false).size() == 0) {
            return teams;
        }
        for (String uuid : players.getKeys(false)) {
            if (teams.contains(players.getString(String.valueOf(uuid) + ".team").toLowerCase())) continue;
            teams.add(players.getString(String.valueOf(uuid) + ".team").toLowerCase());
        }
        return teams;
    }

    public ArrayList<String> getAllTeamsDisplayNames() {
        ArrayList<String> teams = new ArrayList<String>();
        YamlConfiguration players = this.plugin.getPlayerConfig();
        for (String uuid : players.getKeys(false)) {
            if (teams.contains(players.getString(String.valueOf(uuid) + ".team"))) continue;
            teams.add(players.getString(String.valueOf(uuid) + ".team"));
        }
        return teams;
    }

    public ArrayList<UUID> getAllUUIDs() {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        YamlConfiguration players = this.plugin.getPlayerConfig();
        for (String uuid : players.getKeys(false)) {
            uuids.add(UUID.fromString(uuid));
        }
        return uuids;
    }

    public ArrayList<String> getAllNames() {
        ArrayList<String> names = new ArrayList<String>();
        YamlConfiguration players = this.plugin.getPlayerConfig();
        for (UUID uuid : this.getAllUUIDs()) {
            names.add(players.getString(String.valueOf(uuid.toString()) + ".name").toLowerCase());
        }
        return names;
    }

    public void registerSpawnpoint(Location loc, int id) {
        YamlConfiguration spawns = this.plugin.getSpawnsConfig();
        spawns.set(String.valueOf(String.valueOf(id)) + ".x", (Object)loc.getBlockX());
        spawns.set(String.valueOf(String.valueOf(id)) + ".y", (Object)loc.getBlockY());
        spawns.set(String.valueOf(String.valueOf(id)) + ".z", (Object)loc.getBlockZ());
        this.plugin.saveSpawnsConfig();
    }

    public Location getSpawnpoint(int id, Player p) {
        String path;
        YamlConfiguration spawns = this.plugin.getSpawnsConfig();
        if (!spawns.isSet(path = String.valueOf(id))) {
            return null;
        }
        int x = spawns.getInt(String.valueOf(path) + ".x");
        int y = spawns.getInt(String.valueOf(path) + ".y");
        int z = spawns.getInt(String.valueOf(path) + ".z");
        return new Location(p.getWorld(), (double)x, (double)y, (double)z).add(0.5, 0.0, 0.5);
    }

    public VaroPlayer loadVaroPlayer(UUID uuid) {
        YamlConfiguration players = this.plugin.getPlayerConfig();
        String id = uuid.toString();
        String name = players.getString(String.valueOf(id) + ".name");
        String team = players.getString(String.valueOf(id) + ".team");
        long lastlogout = players.getLong(String.valueOf(id) + ".last-logout");
        boolean dead = players.getBoolean(String.valueOf(id) + ".dead");
        int strikes = players.getInt(String.valueOf(id) + ".strikes.amount");
        ArrayList<String> strikereasons = new ArrayList();
        if (players.isSet(String.valueOf(id) + ".strikes.reasons")) {
            strikereasons = players.getStringList(String.valueOf(id) + ".strikes.reasons");
        }
        int idle = players.getInt(String.valueOf(id) + ".idle");
        ArrayList<String> kills = new ArrayList();
        if (players.isSet(String.valueOf(id) + ".kills")) {
            kills = players.getStringList(String.valueOf(id) + ".kills");
        }
        VaroPlayer vp = new VaroPlayer(this.plugin, uuid, name, dead, team, strikes, strikereasons, idle, lastlogout, kills);
        return vp;
    }

    public VaroPlayer loadVaroPlayer(Player p) {
        return this.loadVaroPlayer(p.getUniqueId());
    }

    public VaroPlayer loadVaroPlayer(String name) {
        YamlConfiguration players = this.plugin.getPlayerConfig();
        for (String id : players.getKeys(false)) {
            if (!players.getString(String.valueOf(id) + ".name").equalsIgnoreCase(name)) continue;
            return this.loadVaroPlayer(UUID.fromString(id));
        }
        return null;
    }

    public int getTeamStrikes(String team) {
        int strikes = 0;
        YamlConfiguration players = this.plugin.getPlayerConfig();
        for (UUID uuid : this.plugin.getRegistration().getAllUUIDs()) {
            String id = uuid.toString();
            if (!players.getString(String.valueOf(id) + ".team").equalsIgnoreCase(team)) continue;
            strikes += players.getInt(String.valueOf(id) + ".strikes.amount");
        }
        return strikes;
    }

    public void registerTeamChest(VaroPlayer vp, Block chest) {
        YamlConfiguration chests = this.plugin.getChestsConfig();
        String team = vp.getTeam().toLowerCase();
        String id = String.valueOf(chest.getWorld().getName()) + "-" + chest.getX() + "-" + chest.getY() + "-" + chest.getZ();
        chests.set(String.valueOf(team) + "." + id + ".world", (Object)chest.getWorld().getName());
        chests.set(String.valueOf(team) + "." + id + ".x", (Object)chest.getX());
        chests.set(String.valueOf(team) + "." + id + ".y", (Object)chest.getY());
        chests.set(String.valueOf(team) + "." + id + ".z", (Object)chest.getZ());
        this.plugin.saveChestsConfig(chests);
    }

    public void unregisterTeamChest(Block chest) {
        String team = this.getChestOwner(chest.getLocation());
        YamlConfiguration chests = this.plugin.getChestsConfig();
        String id = String.valueOf(chest.getWorld().getName()) + "-" + chest.getX() + "-" + chest.getY() + "-" + chest.getZ();
        chests.set(String.valueOf(team) + "." + id, null);
        this.plugin.saveChestsConfig(chests);
    }

    public HashMap<String, ArrayList<Location>> getAllTeamChests() {
        HashMap<String, ArrayList<Location>> tc = new HashMap<String, ArrayList<Location>>();
        for (String t : this.plugin.getRegistration().getAllTeams()) {
            tc.put(t, new ArrayList());
        }
        YamlConfiguration chests = this.plugin.getChestsConfig();
        for (String team : chests.getKeys(false)) {
            for (String chest : chests.getConfigurationSection(team).getKeys(false)) {
                String w = chests.getString(String.valueOf(team) + "." + chest + ".world");
                int x = chests.getInt(String.valueOf(team) + "." + chest + ".x");
                int y = chests.getInt(String.valueOf(team) + "." + chest + ".y");
                int z = chests.getInt(String.valueOf(team) + "." + chest + ".z");
                tc.get(team.toLowerCase()).add(new Location(Bukkit.getServer().getWorld(w), (double)x, (double)y, (double)z));
            }
        }
        return tc;
    }

    public String getChestOwner(Location chest) {
        for (String team : this.getAllTeamChests().keySet()) {
            if (!this.getAllTeamChests().get(team).contains(chest)) continue;
            return team;
        }
        return null;
    }

    public boolean isTeamAlive(String team) {
        YamlConfiguration players = this.plugin.getPlayerConfig();
        if (this.plugin.getSettings().isTeamstrikes()) {
            int strikes = 0;
            for (String uuid : players.getKeys(false)) {
                if (!players.getString(String.valueOf(uuid) + ".team").equalsIgnoreCase(team)) continue;
                strikes += players.getInt(String.valueOf(uuid) + ".strikes.amount");
            }
            if (strikes >= this.plugin.getSettings().getStrikes()) {
                return false;
            }
        } else {
            boolean out = true;
            for (String uuid : players.getKeys(false)) {
                if (!players.getString(String.valueOf(uuid) + ".team").equalsIgnoreCase(team) || players.getInt(String.valueOf(uuid) + ".strikes.amount") >= this.plugin.getSettings().getStrikes()) continue;
                out = false;
                break;
            }
            if (out) {
                return false;
            }
        }
        boolean alldead = true;
        for (String uuid : players.getKeys(false)) {
            if (!players.getString(String.valueOf(uuid) + ".team").equalsIgnoreCase(team) || players.getBoolean(String.valueOf(uuid) + ".dead")) continue;
            alldead = false;
            break;
        }
        return !alldead;
    }

    public boolean isPlayerAlive(String uuid) {
        YamlConfiguration players = this.plugin.getPlayerConfig();
        if (!this.isTeamAlive(players.getString(String.valueOf(uuid) + ".team"))) {
            return false;
        }
        if (players.getBoolean(String.valueOf(uuid) + ".dead")) {
            return false;
        }
        return this.plugin.getSettings().isTeamstrikes() || this.plugin.getSettings().getStrikes() > players.getInt(String.valueOf(uuid) + ".strikes.amount");
    }

    public boolean isPlayerAliveByName(String name) {
        YamlConfiguration players = this.plugin.getPlayerConfig();
        for (String uuid : players.getKeys(false)) {
            if (!players.getString(String.valueOf(uuid) + ".name").equalsIgnoreCase(name)) continue;
            return this.isPlayerAlive(uuid);
        }
        return false;
    }

    public ArrayList<String> getTeammemberNames(String team) {
        ArrayList<String> names = new ArrayList<String>();
        YamlConfiguration players = this.plugin.getPlayerConfig();
        for (String uuid : players.getKeys(false)) {
            String name = players.getString(String.valueOf(uuid) + ".name");
            String t = players.getString(String.valueOf(uuid) + ".team");
            if (!t.equalsIgnoreCase(team)) continue;
            names.add(name);
        }
        return names;
    }

    public ArrayList<String> getTeammemberUUIDs(String team) {
        ArrayList<String> uuids = new ArrayList<String>();
        YamlConfiguration players = this.plugin.getPlayerConfig();
        for (String uuid : players.getKeys(false)) {
            String t = players.getString(String.valueOf(uuid) + ".team");
            if (!t.equalsIgnoreCase(team)) continue;
            uuids.add(uuid);
        }
        return uuids;
    }

    public ArrayList<String> getRemainingTeams() {
        ArrayList<String> remaining = new ArrayList<String>();
        for (String team : this.getAllTeamsDisplayNames()) {
            if (!this.isTeamAlive(team)) continue;
            remaining.add(team);
        }
        return remaining;
    }
}

