/*
 * Decompiled with CFR 0.152.
 */
package org.Ziron5.Main;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.Ziron5.Commands.Commands;
import org.Ziron5.Listeners.BannedItemListener;
import org.Ziron5.Listeners.ChatListener;
import org.Ziron5.Listeners.ChestListener;
import org.Ziron5.Listeners.PlayerListener;
import org.Ziron5.Main.Registration;
import org.Ziron5.Main.TimerClass;
import org.Ziron5.Main.VaroPlayer;
import org.Ziron5.Main.VaroPlayerStorage;
import org.Ziron5.Main.VaroSettings;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLogger;
import org.bukkit.plugin.java.JavaPlugin;

public class MrVaro
extends JavaPlugin {
    private PluginLogger logger = new PluginLogger((Plugin)this);
    private String sep = File.separator;
    private VaroSettings settings;
    private Registration reg;
    private BannedItemListener bil;
    public String pre = ChatColor.GRAY + "[" + ChatColor.YELLOW + "MrVaro" + ChatColor.GRAY + "] " + ChatColor.RESET;
    public int build = 21;
    YamlConfiguration config = null;
    File configfile = new File("plugins" + this.sep + "MrVaro", "config.yml");
    YamlConfiguration players = null;
    File playersfile = new File("plugins" + this.sep + "MrVaro", "players.yml");
    YamlConfiguration chests = null;
    File chestsfile = new File("plugins" + this.sep + "MrVaro", "chests.yml");
    YamlConfiguration spawns = null;
    File spawnsfile = new File("plugins" + this.sep + "MrVaro", "spawns.yml");

    public Registration getRegistration() {
        return this.reg;
    }

    public void onEnable() {
        this.logger.info("MrVaro has been activated!");
        this.bil = new BannedItemListener(this);
        this.setupFiles();
        this.loadSettings();
        this.getCommand("mv").setExecutor((CommandExecutor)new Commands(this));
        this.reg = new Registration(this);
        new ChatListener(this);
        new PlayerListener(this);
        new ChestListener(this);
    }

    public void onDisable() {
        ArrayList<VaroPlayer> vps = new ArrayList<VaroPlayer>();
        vps.addAll(VaroPlayerStorage.getAllVaroPlayers());
        for (VaroPlayer vp : vps) {
            if (vp.getTimer() != null) {
                vp.getTimer().logout(true, ChatColor.RED + "Ein Admin hat den Server neu geladen/gestoppt.\nDeine Session musste beendet werden.");
            } else if (vp.getPlayer() != null && vp.getPlayer().isOnline()) {
                vp.getPlayer().kickPlayer(ChatColor.RED + "Ein Admin hat den Server neu geladen/gestoppt.\nDeine Session musste beendet werden.");
            }
            this.log("Server: Player " + vp.getName() + " has been kicked due to a server reload");
        }
        this.logger.info("MrVaro has been deactivated");
    }

    public void setupFiles() {
        File pluginfolder = new File("plugins" + this.sep + "MrVaro");
        if (!pluginfolder.exists()) {
            pluginfolder.mkdirs();
        }
        File config = MrVaro.loadDefaultConfig(this, "config.yml");
        File players = new File("plugins" + this.sep + "MrVaro", "players.yml");
        File chests = new File("plugins" + this.sep + "MrVaro", "chests.yml");
        File spawns = new File("plugins" + this.sep + "MrVaro", "spawns.yml");
        File log = new File("plugins" + this.sep + "MrVaro", "varolog.txt");
        if (!config.exists()) {
            try {
                config.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!players.exists()) {
            try {
                players.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!chests.exists()) {
            try {
                chests.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!spawns.exists()) {
            try {
                spawns.createNewFile();
                this.getSpawnsConfig().set("started", (Object)false);
                this.saveSpawnsConfig();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!log.exists()) {
            try {
                log.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public YamlConfiguration getConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configfile);
        return this.config;
    }

    public YamlConfiguration getPlayerConfig() {
        this.players = YamlConfiguration.loadConfiguration((File)this.playersfile);
        return this.players;
    }

    public void savePlayerConfig(YamlConfiguration players) {
        try {
            players.save(this.playersfile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public YamlConfiguration getChestsConfig() {
        if (this.chests != null) {
            this.saveChestsConfig(this.chests);
        }
        this.chests = YamlConfiguration.loadConfiguration((File)this.chestsfile);
        return this.chests;
    }

    public void saveChestsConfig(YamlConfiguration chests) {
        try {
            chests.save(this.chestsfile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public YamlConfiguration getSpawnsConfig() {
        if (this.spawns == null) {
            this.spawns = YamlConfiguration.loadConfiguration((File)this.spawnsfile);
            return this.spawns;
        }
        return this.spawns;
    }

    public void saveSpawnsConfig() {
        try {
            this.spawns.save(this.spawnsfile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public VaroSettings getSettings() {
        return this.settings;
    }

    public void loadSettings() {
        YamlConfiguration config = this.getConfig();
        int teamsize = config.getInt("team-size");
        int sessiontime = config.getInt("session-time");
        int waittime = config.getInt("wait-time");
        int spawnprotection = config.getInt("spawn-protection");
        boolean teamstrikes = config.getBoolean("team-strikes");
        boolean idlestrikes = config.getBoolean("idle-strikes");
        int strikes = config.getInt("strikes");
        int relogs = config.getInt("relogs");
        boolean friendlyfire = config.getBoolean("friendly-fire");
        List banneditems = config.getStringList("banned-items");
        List bannedpotions = config.getIntegerList("banned-potions");
        boolean started = this.getSpawnsConfig().getBoolean("started");
        boolean sidebarname = config.getBoolean("sidebar-name");
        int logoutdistance = config.getInt("logout-distance");
        boolean chatlog = config.getBoolean("chat-log");
        this.settings = new VaroSettings(this, teamsize, sessiontime, waittime, spawnprotection, teamstrikes, idlestrikes, strikes, relogs, friendlyfire, banneditems, bannedpotions, sidebarname, logoutdistance, chatlog, started);
        this.bil.loadBannedItems();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File loadDefaultConfig(MrVaro plugin, String resource) {
        File folder = plugin.getDataFolder();
        if (!folder.exists()) {
            folder.mkdir();
        }
        File resourceFile = new File(folder, resource);
        try {
            if (resourceFile.exists()) return resourceFile;
            resourceFile.createNewFile();
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                InputStream in = plugin.getResource(resource);
                try {
                    try (FileOutputStream out = new FileOutputStream(resourceFile);){
                        ByteStreams.copy((InputStream)in, (OutputStream)out);
                    }
                    if (in == null) return resourceFile;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                in.close();
                return resourceFile;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resourceFile;
    }

    public void startGame() {
        this.getSettings().setStarted(true);
        for (UUID uuid : VaroPlayerStorage.getAllUUIDs()) {
            Player p = Bukkit.getServer().getPlayer(uuid);
            p.setGameMode(GameMode.SURVIVAL);
        }
        for (VaroPlayer vp : VaroPlayerStorage.getAllVaroPlayers()) {
            vp.setTimer(new TimerClass(this, vp));
        }
        this.log("Server: GAME STARTED");
    }

    public void reset() {
        YamlConfiguration players = this.getPlayerConfig();
        for (String uuid : players.getKeys(false)) {
            players.set(String.valueOf(uuid) + ".dead", (Object)false);
            players.set(String.valueOf(uuid) + ".last-logout", (Object)-1);
            players.set(String.valueOf(uuid) + ".strikes.amount", (Object)0);
            players.set(String.valueOf(uuid) + ".strikes.reasons", null);
            players.set(String.valueOf(uuid) + ".idle", (Object)0);
            players.set(String.valueOf(uuid) + ".kills", null);
        }
        this.savePlayerConfig(players);
        YamlConfiguration chests = this.getChestsConfig();
        for (String team : chests.getKeys(false)) {
            chests.set(team, null);
        }
        this.saveChestsConfig(chests);
        YamlConfiguration spawns = this.getSpawnsConfig();
        spawns.set("started", (Object)false);
        this.saveSpawnsConfig();
        this.log("Server: Administrator reset the game");
        Bukkit.shutdown();
    }

    public void hardReset() {
        File config = MrVaro.loadDefaultConfig(this, "config.yml");
        File players = new File("plugins" + this.sep + "MrVaro", "players.yml");
        File chests = new File("plugins" + this.sep + "MrVaro", "chests.yml");
        File spawns = new File("plugins" + this.sep + "MrVaro", "spawns.yml");
        try {
            FileUtils.forceDelete((File)config);
            FileUtils.forceDelete((File)players);
            FileUtils.forceDelete((File)chests);
            FileUtils.forceDelete((File)spawns);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.log("Server: Administrator hard redet the game");
        Bukkit.shutdown();
    }

    public void winGame() {
        if (!this.getSettings().isStarted()) {
            return;
        }
        if (this.getRegistration().getRemainingTeams().size() == 1) {
            String winner = this.getRegistration().getRemainingTeams().get(0);
            Bukkit.broadcastMessage((String)(ChatColor.GREEN + ChatColor.MAGIC + "OOIIOO" + ChatColor.DARK_GREEN + " TEAM " + ChatColor.DARK_AQUA + winner + ChatColor.DARK_GREEN + " HAT GEWONNEN!! " + ChatColor.GREEN + ChatColor.MAGIC + "OOIIOO"));
            this.getSettings().setStarted(false);
            this.log("WINNER: Team " + winner + " won the game!");
        }
    }

    public PrintWriter getPrintWriter() {
        FileWriter fw = null;
        try {
            fw = new FileWriter(new File("plugins" + this.sep + "MrVaro", "varolog.txt"), true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new PrintWriter(fw);
    }

    public void log(String message) {
        PrintWriter pw = this.getPrintWriter();
        long time = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.''YY, HH:mm:ss");
        String timestamp = "[" + sdf.format(time) + "] ";
        pw.println(String.valueOf(timestamp) + message);
        pw.flush();
        pw.close();
    }
}

