/*
 * Decompiled with CFR 0.152.
 */
package org.Ziron5.Listeners;

import org.Ziron5.Main.MrVaro;
import org.Ziron5.Main.TimerClass;
import org.Ziron5.Main.VaroPlayer;
import org.Ziron5.Main.VaroPlayerStorage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class SpawnProtection
implements Listener {
    MrVaro plugin;
    Player p;
    VaroPlayer vp;
    int left;
    int id;

    public SpawnProtection(MrVaro plugin, Player p) {
        this.plugin = plugin;
        this.p = p;
        this.vp = VaroPlayerStorage.getVaroPlayer(p);
        this.left = plugin.getSettings().getSpawnprotection();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.startSpawnProtection(p);
    }

    public void startSpawnProtection(final Player p) {
        this.id = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (SpawnProtection.this.left >= 0) {
                    VaroPlayer vp = VaroPlayerStorage.getVaroPlayer(p);
                    if (vp != null) {
                        vp.updateScoreboard(SpawnProtection.this.left, true);
                    } else {
                        SpawnProtection.this.cancelTask();
                    }
                    --SpawnProtection.this.left;
                } else {
                    VaroPlayer vp = VaroPlayerStorage.getVaroPlayer(p);
                    if (vp != null) {
                        vp.setTimer(new TimerClass(SpawnProtection.this.plugin, vp));
                    }
                    SpawnProtection.this.cancelTask();
                }
            }
        }, 0L, 20L);
    }

    public void cancelTask() {
        Bukkit.getScheduler().cancelTask(this.id);
        this.p = null;
    }

    @EventHandler
    public void onMove(PlayerMoveEvent e) {
        if (!e.getPlayer().equals(this.p)) {
            return;
        }
        Location from = e.getFrom();
        Location to = e.getTo();
        double x = Math.floor(from.getX());
        double z = Math.floor(from.getZ());
        if (Math.floor(to.getX()) != x || Math.floor(to.getZ()) != z) {
            e.getPlayer().teleport(new Location(from.getWorld(), x += 0.5, from.getY(), z += 0.5, from.getYaw(), from.getPitch()));
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        if (!e.getPlayer().equals(this.p)) {
            return;
        }
        e.setCancelled(true);
        if (e.getPlayer().getItemInHand().getType().equals((Object)Material.BOW)) {
            ItemStack bow = e.getPlayer().getItemInHand().clone();
            e.getPlayer().setItemInHand(bow);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageByEntityEvent e) {
        Player p;
        if (e.getDamager() instanceof Player) {
            p = (Player)e.getDamager();
            if (!p.equals(this.p)) {
                return;
            }
            e.setCancelled(true);
        }
        if (e.getEntity() instanceof Player) {
            p = (Player)e.getEntity();
            if (!p.equals(this.p)) {
                return;
            }
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player) {
            Player p = (Player)e.getEntity();
            if (!p.equals(this.p)) {
                return;
            }
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent e) {
        if (e.getPlayer().equals(this.p)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        if (e.getPlayer().equals(this.p)) {
            e.setCancelled(true);
        }
    }
}

