/*
 * Decompiled with CFR 0.152.
 */
package org.Ziron5.Listeners;

import java.util.HashMap;
import java.util.UUID;
import org.Ziron5.Listeners.SpawnProtection;
import org.Ziron5.Main.Damager;
import org.Ziron5.Main.MrVaro;
import org.Ziron5.Main.VaroPlayer;
import org.Ziron5.Main.VaroPlayerStorage;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    MrVaro plugin;
    public HashMap<UUID, Damager> damagers = new HashMap();

    public PlayerListener(MrVaro plugin) {
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onLogin(PlayerLoginEvent e) {
        Player p = e.getPlayer();
        boolean started = this.plugin.getSettings().isStarted();
        if (!started) {
            if (!(p.isOp() || p.hasPermission("mrvaro.admin") || this.plugin.getRegistration().getAllUUIDs().contains(p.getUniqueId()))) {
                e.disallow(PlayerLoginEvent.Result.KICK_BANNED, ChatColor.RED + "Du bist kein Teilnehmer dieses Varos!\nEin Admin muss dich mit deinem Team registrieren, damit du beitreten kannst.");
                this.plugin.log("Server: " + p.getName() + " tried to log in but failed (not registered)");
                return;
            }
            if (this.plugin.getRegistration().getAllUUIDs().contains(p.getUniqueId())) {
                int id = this.plugin.getRegistration().getAllUUIDs().indexOf(p.getUniqueId()) + 1;
                Location spawn = this.plugin.getRegistration().getSpawnpoint(id, p);
                if (spawn == null) {
                    if (p.isOp() || p.hasPermission("mrvaro.admin")) {
                        e.allow();
                        this.plugin.log("Server: " + p.getName() + " logged in as administrator with team but not enough spawn points");
                        return;
                    }
                    e.disallow(PlayerLoginEvent.Result.KICK_OTHER, ChatColor.RED + "Es sind nicht gen\u00fcgend Spawnpunkte vorhanden!\nInformiere einen Admin, sodass er mehr erstellt.");
                    this.plugin.log("Server: " + p.getName() + " tried to log in but failed (not enough spawn points)");
                    return;
                }
                VaroPlayerStorage.addPlayer(p, this.plugin.getRegistration().loadVaroPlayer(p));
                this.plugin.log("Server: Player " + p.getName() + " logged in");
            } else if (p.isOp() || p.hasPermission("mrvaro.admin")) {
                e.allow();
                this.plugin.log("Server: " + p.getName() + " logged in as teamless administrator");
            }
        } else if (!(p.isOp() || p.hasPermission("mrvaro.admin") || this.plugin.getRegistration().getAllUUIDs().contains(p.getUniqueId()))) {
            e.disallow(PlayerLoginEvent.Result.KICK_BANNED, ChatColor.RED + "Du darfst dem laufenden Varo nicht beireten, da du kein Teilnhemer bist!");
            this.plugin.log("Server: " + p.getName() + " tried to log in but failed (not registered)");
        } else if (VaroPlayerStorage.getVaroPlayer(p) != null) {
            VaroPlayer vp = VaroPlayerStorage.getVaroPlayer(p);
            if (vp.getRelogs() > this.plugin.getSettings().getRelogs()) {
                e.disallow(PlayerLoginEvent.Result.KICK_BANNED, ChatColor.RED + "Du hast bereits die maximale Anzahl von " + this.plugin.getSettings().getRelogs() + " Relogs aufgebraucht!\nDeine Session wurde beendet.\nDu bist nun f\u00fcr " + this.plugin.getSettings().getWaittime() + " Stunden gebannt.");
                this.plugin.log("Server: " + p.getName() + " tried to log in but failed (too many relogs)");
                return;
            }
            vp.setRelogs(vp.getRelogs() + 1);
            this.plugin.log("Server: Player " + p.getName() + " relogged into the session. Relog [" + vp.getRelogs() + "/" + this.plugin.getSettings().getRelogs() + "]");
        } else if (this.plugin.getRegistration().getAllUUIDs().contains(p.getUniqueId())) {
            long waited;
            VaroPlayer vp = this.plugin.getRegistration().loadVaroPlayer(p);
            if (vp.isDead()) {
                e.disallow(PlayerLoginEvent.Result.KICK_BANNED, ChatColor.RED + "Du bist aus dem Varo ausgeschieden, weil du gestorben bist.\nDu darfst dem Server nicht mehr beitreten");
                this.plugin.log("Server: " + p.getName() + " tried to log in but failed (dead)");
                return;
            }
            if (this.plugin.getSettings().isTeamstrikes()) {
                if (this.plugin.getRegistration().getTeamStrikes(vp.getTeam()) >= this.plugin.getSettings().getStrikes()) {
                    e.disallow(PlayerLoginEvent.Result.KICK_BANNED, ChatColor.RED + "Dein Team wurde wegen zu vielen Strikes ausgeschlossen.\nBitte an die Regeln halten!");
                    this.plugin.log("Server: " + p.getName() + " tried to log in but failed (team strike-ban)");
                    return;
                }
            } else if (vp.getStrikes() >= this.plugin.getSettings().getStrikes()) {
                e.disallow(PlayerLoginEvent.Result.KICK_BANNED, ChatColor.RED + "Du wurdest wegen zu vieler Strikes ausgeschlossen-\nBitte halte dich an die Regeln!");
                this.plugin.log("Server: " + p.getName() + " tried to log in but failed (player stike-ban)");
                return;
            }
            if ((waited = System.currentTimeMillis() - vp.getLastlogout()) < (long)(this.plugin.getSettings().getWaittime() * 1000 * 60 * 60)) {
                waited = ((long)(this.plugin.getSettings().getWaittime() * 1000 * 60 * 60) - waited) / 1000L;
                int h = (int)(waited / 3600L);
                int min = (int)(waited % 3600L / 60L);
                int sec = (int)(waited % 3600L % 60L);
                String hours = String.valueOf(h);
                String minutes = String.valueOf(min);
                String seconds = String.valueOf(sec);
                if (hours.length() == 1) {
                    hours = "0" + hours;
                }
                if (minutes.length() == 1) {
                    minutes = "0" + minutes;
                }
                if (seconds.length() == 1) {
                    seconds = "0" + seconds;
                }
                e.disallow(PlayerLoginEvent.Result.KICK_BANNED, ChatColor.GOLD + "Varo" + ChatColor.RED + "\n\nDeine Wartezeit ist noch nicht zu Ende! Warte noch\n" + ChatColor.GOLD + hours + ChatColor.YELLOW + "h" + ChatColor.GOLD + ":" + minutes + ChatColor.YELLOW + "m" + ChatColor.GOLD + ":" + seconds + ChatColor.YELLOW + "s");
                this.plugin.log("Server: " + p.getName() + " tried to log in but failed (wait-time not over)");
                return;
            }
            VaroPlayerStorage.addPlayer(p, vp);
            new SpawnProtection(this.plugin, p);
            e.allow();
            this.plugin.log("Server: Player " + p.getName() + " logged in and started Session");
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        VaroPlayer vp = null;
        if (this.plugin.getRegistration().getAllUUIDs().contains(p.getUniqueId())) {
            vp = VaroPlayerStorage.getVaroPlayer(p);
            if (vp == null) {
                return;
            }
            vp.setupScoreboard();
            if (vp.getRelogs() == 0) {
                e.setJoinMessage(ChatColor.GRAY + "[" + ChatColor.DARK_AQUA + vp.getTeam() + ChatColor.GRAY + "] " + ChatColor.AQUA + p.getName() + ChatColor.GOLD + " ist dem Spiel beigetreten.");
                if (this.plugin.getSettings().isStarted()) {
                    p.sendMessage(String.valueOf(this.plugin.pre) + ChatColor.DARK_GREEN + "Willkommen! Du kannst dich nach deiner Schutzzeit von " + ChatColor.GOLD + this.plugin.getSettings().getSpawnprotection() + " Sekunden " + ChatColor.DARK_GREEN + "bewegen und angegriffen werden.");
                }
            } else {
                e.setJoinMessage(ChatColor.GRAY + "[" + ChatColor.DARK_AQUA + vp.getTeam() + ChatColor.GRAY + "] " + ChatColor.AQUA + p.getName() + ChatColor.GOLD + " ist dem Spiel wieder beigetreten.");
                p.sendMessage(String.valueOf(this.plugin.pre) + ChatColor.GOLD + "Das war Relog " + ChatColor.GRAY + "[" + ChatColor.AQUA + vp.getRelogs() + ChatColor.GRAY + "/" + ChatColor.DARK_AQUA + this.plugin.getSettings().getRelogs() + ChatColor.GRAY + "]");
            }
            if (!this.plugin.getSettings().isStarted()) {
                int id = this.plugin.getRegistration().getAllUUIDs().indexOf(p.getUniqueId()) + 1;
                Location spawn = this.plugin.getRegistration().getSpawnpoint(id, p);
                p.teleport(spawn);
                p.setGameMode(GameMode.ADVENTURE);
                p.setHealth(20.0);
                p.setFoodLevel(20);
                p.getInventory().clear();
                p.getEquipment().clear();
            } else {
                if (!p.getGameMode().equals((Object)GameMode.SURVIVAL)) {
                    p.setGameMode(GameMode.SURVIVAL);
                }
                if (vp.getRelogs() == 0) {
                    this.checkIdle(vp);
                }
                if (vp.getLastlogout() == -1L && vp.getRelogs() == 0) {
                    int id = this.plugin.getRegistration().getAllUUIDs().indexOf(p.getUniqueId()) + 1;
                    Location spawn = this.plugin.getRegistration().getSpawnpoint(id, p);
                    p.teleport(spawn);
                    this.plugin.log("Server: Player " + p.getName() + " logged in for the first time (missed start)");
                }
            }
        } else {
            e.setJoinMessage(null);
            p.sendMessage(String.valueOf(this.plugin.pre) + ChatColor.GOLD + "Du hast dich als Admin ohne Team angemeldet. Erhalte Hilfe mit /mv");
        }
    }

    public void checkIdle(final VaroPlayer vp) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Player p = vp.getPlayer();
                if (PlayerListener.this.plugin.getSettings().isIdlestrikes()) {
                    if (vp.getNocontact() >= 30 && vp.getNocontact() % 10 == 0) {
                        vp.addStrike("Automatischer Strike: " + vp.getNocontact() + " Sessions ohne Feindkontakt", true);
                        PlayerListener.this.plugin.log("AutoStrike: Striked player " + p.getName() + " for " + vp.getNocontact() + " sessions without enemy contact");
                    }
                    if (vp.getNocontact() >= 30) {
                        for (Player pl : Bukkit.getOnlinePlayers()) {
                            pl.sendMessage(String.valueOf(PlayerListener.this.plugin.pre) + ChatColor.GRAY + "[" + ChatColor.DARK_AQUA + vp.getTeam() + ChatColor.GRAY + "] " + ChatColor.AQUA + vp.getName() + ChatColor.DARK_GRAY + " hatte seit " + vp.getNocontact() + "(!) Sessions keinen Feindkontakt mehr.");
                            pl.sendMessage(String.valueOf(PlayerListener.this.plugin.pre) + ChatColor.DARK_GRAY + "Seine Koordinaten sind: " + ChatColor.DARK_RED + p.getLocation().getBlockX() + " " + p.getLocation().getBlockY() + " " + p.getLocation().getBlockZ());
                            PlayerListener.this.plugin.log("AutoStrike: Player " + p.getName() + " had no enemy contact for " + vp.getNocontact() + " sessions. Coordinates revealed");
                        }
                    }
                }
            }
        }, 60L);
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        if (VaroPlayerStorage.getVaroPlayer(p) != null) {
            VaroPlayer vp = VaroPlayerStorage.getVaroPlayer(p);
            if (this.plugin.getSettings().getRelogs() == vp.getRelogs()) {
                vp.getTimer().logout(false, null);
                e.setQuitMessage(String.valueOf(this.plugin.pre) + ChatColor.GRAY + "[" + ChatColor.DARK_AQUA + vp.getTeam() + ChatColor.GRAY + "] " + ChatColor.AQUA + p.getName() + ChatColor.GOLD + " hat das Spiel verlassen. Session beendet (zu viele Relogs)");
                this.plugin.log("Server: Ended session of player " + p.getName() + ". Too many relogs");
                return;
            }
        }
        e.setQuitMessage(String.valueOf(this.plugin.pre) + ChatColor.GRAY + "[" + ChatColor.DARK_AQUA + this.plugin.getRegistration().loadVaroPlayer(p).getTeam() + ChatColor.GRAY + "] " + ChatColor.AQUA + p.getName() + ChatColor.GOLD + " hat das Spiel verlassen.");
        this.plugin.log("Server: Player " + p.getName() + " left the game");
    }

    @EventHandler
    public void onHunger(FoodLevelChangeEvent e) {
        if (!this.plugin.getSettings().isStarted()) {
            e.setCancelled(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler
    public void onDamage(EntityDamageByEntityEvent e) {
        Player d;
        if (!this.plugin.getSettings().isStarted()) {
            e.setCancelled(true);
        }
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        if (!(e.getDamager() instanceof Player) && !(e.getDamager() instanceof Projectile)) {
            return;
        }
        Player p = (Player)e.getEntity();
        if (e.getDamager() instanceof Projectile) {
            Projectile arrow = (Projectile)e.getDamager();
            if (!(arrow.getShooter() instanceof Player)) return;
            d = (Player)arrow.getShooter();
        } else {
            d = (Player)e.getDamager();
        }
        if (!this.plugin.getSettings().isFriendlyfire() && VaroPlayerStorage.getVaroPlayer(p).getTeam().equals(VaroPlayerStorage.getVaroPlayer(d).getTeam())) {
            e.setCancelled(true);
            return;
        }
        this.damagers.put(p.getUniqueId(), new Damager(d, this.plugin));
        VaroPlayerStorage.getVaroPlayer(d).setIdle(false);
    }

    public Damager getDamager(Player p) {
        return this.damagers.get(p.getUniqueId());
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent e) {
        Player p = e.getEntity();
        VaroPlayer vp = VaroPlayerStorage.getVaroPlayer(p);
        vp.setDead(true);
        if (vp.getTimer() != null) {
            vp.getTimer().logout(false, null);
        }
        if (this.getDamager(p) != null && this.getDamager(p).isClaimkill()) {
            Player k = p.getKiller();
            VaroPlayer vk = VaroPlayerStorage.getVaroPlayer(k);
            e.setDeathMessage(String.valueOf(this.plugin.pre) + ChatColor.GRAY + "[" + ChatColor.DARK_AQUA + vp.getTeam() + ChatColor.GRAY + "] " + ChatColor.AQUA + p.getName() + ChatColor.DARK_RED + " wurde von " + ChatColor.GRAY + "[" + ChatColor.DARK_AQUA + vk.getTeam() + ChatColor.GRAY + "] " + ChatColor.AQUA + k.getName() + ChatColor.DARK_RED + " umgebracht!");
            vk.addKill(vp);
            vk.save(true);
            this.plugin.log("KILL: Player " + vp.getName() + " has been killed by " + vk.getName());
            p.getWorld().playSound(p.getLocation(), Sound.AMBIENCE_THUNDER, 100.0f, 1.0f);
            this.plugin.winGame();
            return;
        }
        e.setDeathMessage(String.valueOf(this.plugin.pre) + ChatColor.GRAY + "[" + ChatColor.DARK_AQUA + vp.getTeam() + ChatColor.GRAY + "] " + ChatColor.AQUA + p.getName() + ChatColor.DARK_RED + " ist gestorben!");
        this.plugin.log("DEATH: Player " + vp.getName() + " died");
        p.getWorld().playSound(p.getLocation(), Sound.AMBIENCE_THUNDER, 100.0f, 1.0f);
        this.plugin.winGame();
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent e) {
        if (!this.plugin.getSettings().isStarted()) {
            return;
        }
        Player p = e.getPlayer();
        if (!this.plugin.getRegistration().loadVaroPlayer(p).isDead()) {
            return;
        }
        p.kickPlayer(ChatColor.AQUA + "Danke f\u00fcr's Mitspielen!\n\n" + ChatColor.YELLOW + "Das Abenteuer ist hier leider f\u00fcr dich zu Ende.");
    }

    @EventHandler
    public void onCreeperBoom(EntityExplodeEvent e) {
        if (!this.plugin.getSettings().isStarted()) {
            e.setCancelled(true);
        }
    }
}

