/*
 * Decompiled with CFR 0.152.
 */
package org.Ziron5.Listeners;

import java.util.ArrayList;
import net.md_5.bungee.api.ChatColor;
import org.Ziron5.Main.MrVaro;
import org.Ziron5.Main.VaroPlayer;
import org.Ziron5.Main.VaroPlayerStorage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class ChestListener
implements Listener {
    MrVaro plugin;

    public ChestListener(MrVaro plugin) {
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public boolean allowChestOpen(Location chest, Player opener) {
        String owner = this.plugin.getRegistration().getChestOwner(chest);
        if (owner == null) {
            return true;
        }
        if (!this.plugin.getRegistration().isTeamAlive(owner)) {
            return true;
        }
        if (!VaroPlayerStorage.getAllUUIDs().contains(opener.getUniqueId())) {
            return true;
        }
        VaroPlayer vp = VaroPlayerStorage.getVaroPlayer(opener);
        if (!this.plugin.getRegistration().getChestOwner(chest).equalsIgnoreCase(vp.getTeam())) {
            opener.sendMessage(String.valueOf(this.plugin.pre) + ChatColor.RED + "Diese Kiste geh\u00f6rt Team " + ChatColor.DARK_AQUA + owner + ChatColor.RED + "!");
            return false;
        }
        return true;
    }

    public boolean isChestProtected(Location chest) {
        String owner = this.plugin.getRegistration().getChestOwner(chest);
        if (owner == null) {
            return false;
        }
        return this.plugin.getRegistration().isTeamAlive(owner);
    }

    @EventHandler
    public void onChestPlace(BlockPlaceEvent e) {
        Block b = e.getBlockPlaced();
        if (!b.getType().equals((Object)Material.CHEST)) {
            return;
        }
        Player p = e.getPlayer();
        if (!VaroPlayerStorage.getAllUUIDs().contains(p.getUniqueId())) {
            return;
        }
        VaroPlayer vp = VaroPlayerStorage.getVaroPlayer(p);
        this.plugin.getRegistration().registerTeamChest(vp, b);
        p.sendMessage(String.valueOf(this.plugin.pre) + ChatColor.GREEN + "Teamkiste erstellt");
    }

    @EventHandler
    public void onChestBreak(BlockBreakEvent e) {
        Block b = e.getBlock();
        if (!b.getType().equals((Object)Material.CHEST)) {
            return;
        }
        Location chest = b.getLocation();
        if (!this.allowChestOpen(chest, e.getPlayer())) {
            e.setCancelled(true);
            return;
        }
        if (this.plugin.getRegistration().getChestOwner(chest) == null) {
            return;
        }
        this.plugin.getRegistration().unregisterTeamChest(b);
    }

    @EventHandler
    public void onChestOpen(PlayerInteractEvent e) {
        if (!e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        Block b = e.getClickedBlock();
        if (!b.getType().equals((Object)Material.CHEST)) {
            return;
        }
        Location chest = b.getLocation();
        if (!this.allowChestOpen(chest, e.getPlayer())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onHopperPlace(BlockPlaceEvent e) {
        Block b = e.getBlockPlaced();
        if (!b.getType().equals((Object)Material.HOPPER)) {
            return;
        }
        if (!b.getRelative(BlockFace.UP).getType().equals((Object)Material.CHEST)) {
            return;
        }
        Location chest = b.getRelative(BlockFace.UP).getLocation();
        if (!this.allowChestOpen(chest, e.getPlayer())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onChestExplode(EntityExplodeEvent e) {
        ArrayList<Block> protect = new ArrayList<Block>();
        for (Block b : e.blockList()) {
            if (!b.getType().equals((Object)Material.CHEST) || !this.isChestProtected(b.getLocation())) continue;
            protect.add(b);
        }
        for (Block p : protect) {
            e.blockList().remove(p);
        }
        protect.clear();
    }
}

