/*
 * Decompiled with CFR 0.152.
 */
package org.Ziron5.Listeners;

import java.util.ArrayList;
import java.util.List;
import org.Ziron5.Main.MrVaro;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BannedItemListener
implements Listener {
    MrVaro plugin;
    private ArrayList<ItemStack> banneditems = new ArrayList();
    private List<Short> bannedpotions = new ArrayList<Short>();

    public BannedItemListener(MrVaro plugin) {
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void loadBannedItems() {
        YamlConfiguration config = this.plugin.getConfig();
        List banned = config.getStringList("banned-items");
        for (String item : banned) {
            Material mat = Material.getMaterial((String)item.split("%")[0]);
            short damage = 0;
            try {
                damage = Short.parseShort(item.split("%")[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (mat == null) continue;
            this.banneditems.add(new ItemStack(mat, 1, damage));
        }
        this.bannedpotions = config.getShortList("banned-potions");
    }

    @EventHandler
    public void onCraft(CraftItemEvent e) {
        ItemStack result = e.getRecipe().getResult();
        result.setAmount(1);
        if (this.banneditems.contains(result)) {
            e.setCancelled(true);
            e.getWhoClicked().sendMessage(String.valueOf(this.plugin.pre) + ChatColor.RED + "Dieses Item ist gebannt!");
        }
    }

    @EventHandler
    public void onBrew(InventoryClickEvent e) {
        ItemStack potion = e.getCurrentItem();
        if (potion == null) {
            return;
        }
        if (!potion.getType().equals((Object)Material.POTION)) {
            return;
        }
        if (this.bannedpotions.contains(potion.getDurability())) {
            e.setCancelled(true);
            e.getWhoClicked().sendMessage(String.valueOf(this.plugin.pre) + ChatColor.RED + "Dieses Item ist gebannt!");
        }
    }

    @EventHandler
    public void onItemPickUp(PlayerPickupItemEvent e) {
        ItemStack item = e.getItem().getItemStack();
        if (item.getType().equals((Object)Material.POTION)) {
            if (this.bannedpotions.contains(item.getDurability())) {
                e.setCancelled(true);
                e.getItem().remove();
                e.getPlayer().sendMessage(String.valueOf(this.plugin.pre) + ChatColor.RED + "Dieses Item ist gebannt!");
            }
        } else {
            item.setAmount(1);
            if (this.banneditems.contains(item)) {
                e.setCancelled(true);
                e.getItem().remove();
                e.getPlayer().sendMessage(String.valueOf(this.plugin.pre) + ChatColor.RED + "Dieses Item ist gebannt!");
            }
        }
    }
}

