/*
 * Decompiled with CFR 0.152.
 */
package me.jul1an_k.tablist.bungee.metrics;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.TaskScheduler;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class Metrics {
    public static final int B_STATS_VERSION = 1;
    private static final String URL = "https://bStats.org/submitData/bungeecord";
    private final Plugin plugin;
    private boolean enabled;
    private String serverUUID;
    private boolean logFailedRequests;
    private static final List<Object> knownMetricsInstances;
    private final List<CustomChart> charts;

    static {
        String defaultPackage = new String(new byte[]{111, 114, 103, 46, 98, 115, 116, 97, 116, 115});
        String examplePackage = new String(new byte[]{121, 111, 117, 114, 46, 112, 97, 99, 107, 97, 103, 101});
        if (Metrics.class.getPackage().getName().equals(defaultPackage) || Metrics.class.getPackage().getName().equals(examplePackage)) {
            throw new IllegalStateException("bStats Metrics class has not been relocated correctly!");
        }
        knownMetricsInstances = new ArrayList<Object>();
    }

    public Metrics(Plugin plugin) {
        block8: {
            this.logFailedRequests = false;
            this.charts = new ArrayList<CustomChart>();
            this.plugin = plugin;
            try {
                this.loadConfig();
            }
            catch (IOException e) {
                plugin.getLogger().log(Level.WARNING, "Failed to load bStats config!", e);
                return;
            }
            if (!this.enabled) {
                return;
            }
            Class<?> usedMetricsClass = this.getFirstBStatsClass();
            if (usedMetricsClass == null) {
                return;
            }
            if (usedMetricsClass == this.getClass()) {
                Metrics.linkMetrics(this);
                this.startSubmitting();
            } else {
                try {
                    usedMetricsClass.getMethod("linkMetrics", Object.class).invoke(null, this);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    if (!this.logFailedRequests) break block8;
                    plugin.getLogger().log(Level.WARNING, "Failed to link to first metrics class " + usedMetricsClass.getName() + "!", e);
                }
            }
        }
    }

    public void addCustomChart(CustomChart chart) {
        if (chart == null) {
            this.plugin.getLogger().log(Level.WARNING, "Chart cannot be null");
        }
        this.charts.add(chart);
    }

    public static void linkMetrics(Object metrics) {
        knownMetricsInstances.add(metrics);
    }

    public JsonObject getPluginData() {
        JsonObject data = new JsonObject();
        String pluginName = this.plugin.getDescription().getName();
        String pluginVersion = this.plugin.getDescription().getVersion();
        data.addProperty("pluginName", pluginName);
        data.addProperty("pluginVersion", pluginVersion);
        JsonArray customCharts = new JsonArray();
        for (CustomChart customChart : this.charts) {
            JsonObject chart = customChart.getRequestJsonObject(this.plugin.getLogger(), this.logFailedRequests);
            if (chart == null) continue;
            customCharts.add((JsonElement)chart);
        }
        data.add("customCharts", (JsonElement)customCharts);
        return data;
    }

    private void startSubmitting() {
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                TaskScheduler scheduler = Metrics.this.plugin.getProxy().getScheduler();
                scheduler.schedule(Metrics.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        Metrics.this.submitData();
                    }
                }, 0L, TimeUnit.SECONDS);
            }
        }, 120000L, 1800000L);
    }

    private JsonObject getServerData() {
        int playerAmount = this.plugin.getProxy().getOnlineCount();
        playerAmount = playerAmount > 500 ? 500 : playerAmount;
        int onlineMode = this.plugin.getProxy().getConfig().isOnlineMode() ? 1 : 0;
        String bungeecordVersion = this.plugin.getProxy().getVersion();
        int managedServers = this.plugin.getProxy().getServers().size();
        String javaVersion = System.getProperty("java.version");
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        String osVersion = System.getProperty("os.version");
        int coreCount = Runtime.getRuntime().availableProcessors();
        JsonObject data = new JsonObject();
        data.addProperty("serverUUID", this.serverUUID);
        data.addProperty("playerAmount", (Number)playerAmount);
        data.addProperty("managedServers", (Number)managedServers);
        data.addProperty("onlineMode", (Number)onlineMode);
        data.addProperty("bungeecordVersion", bungeecordVersion);
        data.addProperty("javaVersion", javaVersion);
        data.addProperty("osName", osName);
        data.addProperty("osArch", osArch);
        data.addProperty("osVersion", osVersion);
        data.addProperty("coreCount", (Number)coreCount);
        return data;
    }

    private void submitData() {
        final JsonObject data = this.getServerData();
        JsonArray pluginData = new JsonArray();
        for (Object metrics : knownMetricsInstances) {
            try {
                Object plugin = metrics.getClass().getMethod("getPluginData", new Class[0]).invoke(metrics, new Object[0]);
                if (!(plugin instanceof JsonObject)) continue;
                pluginData.add((JsonElement)((JsonObject)plugin));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        data.add("plugins", (JsonElement)pluginData);
        new Thread(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        Metrics.sendData(data);
                    }
                    catch (Exception e) {
                        if (!Metrics.this.logFailedRequests) break block2;
                        Metrics.this.plugin.getLogger().log(Level.WARNING, "Could not submit plugin stats!", e);
                    }
                }
            }
        }).start();
    }

    private void loadConfig() throws IOException {
        Path configPath = this.plugin.getDataFolder().toPath().getParent().resolve("bStats");
        configPath.toFile().mkdirs();
        File configFile = new File(configPath.toFile(), "config.yml");
        if (!configFile.exists()) {
            this.writeFile(configFile, "#bStats collects some data for plugin authors like how many servers are using their plugins.", "#To honor their work, you should not disable it.", "#This has nearly no effect on the server performance!", "#Check out https://bStats.org/ to learn more :)", "enabled: true", "serverUuid: \"" + UUID.randomUUID().toString() + "\"", "logFailedRequests: false");
        }
        Configuration configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(configFile);
        this.enabled = configuration.getBoolean("enabled", true);
        this.serverUUID = configuration.getString("serverUuid");
        this.logFailedRequests = configuration.getBoolean("logFailedRequests", false);
    }

    private Class<?> getFirstBStatsClass() {
        Path configPath = this.plugin.getDataFolder().toPath().getParent().resolve("bStats");
        configPath.toFile().mkdirs();
        File tempFile = new File(configPath.toFile(), "temp.txt");
        try {
            String className = this.readFile(tempFile);
            if (className != null) {
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            this.writeFile(tempFile, this.getClass().getName());
            return this.getClass();
        }
        catch (IOException e) {
            if (this.logFailedRequests) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to get first bStats class!", e);
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readFile(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileReader fileReader = new FileReader(file);
            try {
                String string;
                block15: {
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    try {
                        string = bufferedReader.readLine();
                        return string;
                    }
                    finally {
                        if (bufferedReader == null) break block15;
                        bufferedReader.close();
                    }
                }
                if (fileReader != null) {
                    fileReader.close();
                }
                return string;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fileReader == null) throw throwable;
                fileReader.close();
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeFile(File file, String ... lines) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            FileWriter fileWriter = new FileWriter(file);
            try {
                try (BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
                    String[] stringArray = lines;
                    int n = lines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        bufferedWriter.write(line);
                        bufferedWriter.newLine();
                        ++n2;
                    }
                }
                if (fileWriter == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fileWriter == null) throw throwable;
                fileWriter.close();
                throw throwable;
            }
            fileWriter.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static void sendData(JsonObject data) throws Exception {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null");
        }
        HttpsURLConnection connection = (HttpsURLConnection)new URL(URL).openConnection();
        byte[] compressedData = Metrics.compress(data.toString());
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Connection", "close");
        connection.addRequestProperty("Content-Encoding", "gzip");
        connection.addRequestProperty("Content-Length", String.valueOf(compressedData.length));
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "MC-Server/1");
        connection.setDoOutput(true);
        DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
        outputStream.write(compressedData);
        outputStream.flush();
        outputStream.close();
        connection.getInputStream().close();
    }

    private static byte[] compress(String str) throws IOException {
        if (str == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(outputStream);
        gzip.write(str.getBytes("UTF-8"));
        gzip.close();
        return outputStream.toByteArray();
    }

    public static abstract class AdvancedBarChart
    extends CustomChart {
        public AdvancedBarChart(String chartId) {
            super(chartId);
        }

        public abstract HashMap<String, int[]> getValues(HashMap<String, int[]> var1);

        @Override
        protected JsonObject getChartData() {
            JsonObject data = new JsonObject();
            JsonObject values = new JsonObject();
            HashMap<String, int[]> map = this.getValues(new HashMap<String, int[]>());
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean allSkipped = true;
            for (Map.Entry<String, int[]> entry : map.entrySet()) {
                if (entry.getValue().length == 0) continue;
                allSkipped = false;
                JsonArray categoryValues = new JsonArray();
                int[] nArray = entry.getValue();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int categoryValue = nArray[n2];
                    categoryValues.add((JsonElement)new JsonPrimitive((Number)categoryValue));
                    ++n2;
                }
                values.add(entry.getKey(), (JsonElement)categoryValues);
            }
            if (allSkipped) {
                return null;
            }
            data.add("values", (JsonElement)values);
            return data;
        }
    }

    public static abstract class AdvancedMapChart
    extends CustomChart {
        public AdvancedMapChart(String chartId) {
            super(chartId);
        }

        public abstract HashMap<Country, Integer> getValues(HashMap<Country, Integer> var1);

        @Override
        protected JsonObject getChartData() {
            JsonObject data = new JsonObject();
            JsonObject values = new JsonObject();
            HashMap<Country, Integer> map = this.getValues(new HashMap<Country, Integer>());
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean allSkipped = true;
            for (Map.Entry<Country, Integer> entry : map.entrySet()) {
                if (entry.getValue() == 0) continue;
                allSkipped = false;
                values.addProperty(entry.getKey().getCountryIsoTag(), (Number)entry.getValue());
            }
            if (allSkipped) {
                return null;
            }
            data.add("values", (JsonElement)values);
            return data;
        }
    }

    public static abstract class AdvancedPie
    extends CustomChart {
        public AdvancedPie(String chartId) {
            super(chartId);
        }

        public abstract HashMap<String, Integer> getValues(HashMap<String, Integer> var1);

        @Override
        protected JsonObject getChartData() {
            JsonObject data = new JsonObject();
            JsonObject values = new JsonObject();
            HashMap<String, Integer> map = this.getValues(new HashMap<String, Integer>());
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean allSkipped = true;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getValue() == 0) continue;
                allSkipped = false;
                values.addProperty(entry.getKey(), (Number)entry.getValue());
            }
            if (allSkipped) {
                return null;
            }
            data.add("values", (JsonElement)values);
            return data;
        }
    }

    public static enum Country {
        AUTO_DETECT("AUTO", "Auto Detected"),
        ANDORRA("AD", "Andorra"),
        UNITED_ARAB_EMIRATES("AE", "United Arab Emirates"),
        AFGHANISTAN("AF", "Afghanistan"),
        ANTIGUA_AND_BARBUDA("AG", "Antigua and Barbuda"),
        ANGUILLA("AI", "Anguilla"),
        ALBANIA("AL", "Albania"),
        ARMENIA("AM", "Armenia"),
        NETHERLANDS_ANTILLES("AN", "Netherlands Antilles"),
        ANGOLA("AO", "Angola"),
        ANTARCTICA("AQ", "Antarctica"),
        ARGENTINA("AR", "Argentina"),
        AMERICAN_SAMOA("AS", "American Samoa"),
        AUSTRIA("AT", "Austria"),
        AUSTRALIA("AU", "Australia"),
        ARUBA("AW", "Aruba"),
        ALAND_ISLANDS("AX", "\u00c5land Islands"),
        AZERBAIJAN("AZ", "Azerbaijan"),
        BOSNIA_AND_HERZEGOVINA("BA", "Bosnia and Herzegovina"),
        BARBADOS("BB", "Barbados"),
        BANGLADESH("BD", "Bangladesh"),
        BELGIUM("BE", "Belgium"),
        BURKINA_FASO("BF", "Burkina Faso"),
        BULGARIA("BG", "Bulgaria"),
        BAHRAIN("BH", "Bahrain"),
        BURUNDI("BI", "Burundi"),
        BENIN("BJ", "Benin"),
        SAINT_BARTHELEMY("BL", "Saint Barth\u00e9lemy"),
        BERMUDA("BM", "Bermuda"),
        BRUNEI("BN", "Brunei"),
        BOLIVIA("BO", "Bolivia"),
        BONAIRE_SINT_EUSTATIUS_AND_SABA("BQ", "Bonaire, Sint Eustatius and Saba"),
        BRAZIL("BR", "Brazil"),
        BAHAMAS("BS", "Bahamas"),
        BHUTAN("BT", "Bhutan"),
        BOUVET_ISLAND("BV", "Bouvet Island"),
        BOTSWANA("BW", "Botswana"),
        BELARUS("BY", "Belarus"),
        BELIZE("BZ", "Belize"),
        CANADA("CA", "Canada"),
        COCOS_ISLANDS("CC", "Cocos Islands"),
        THE_DEMOCRATIC_REPUBLIC_OF_CONGO("CD", "The Democratic Republic Of Congo"),
        CENTRAL_AFRICAN_REPUBLIC("CF", "Central African Republic"),
        CONGO("CG", "Congo"),
        SWITZERLAND("CH", "Switzerland"),
        COTE_D_IVOIRE("CI", "C\u00f4te d'Ivoire"),
        COOK_ISLANDS("CK", "Cook Islands"),
        CHILE("CL", "Chile"),
        CAMEROON("CM", "Cameroon"),
        CHINA("CN", "China"),
        COLOMBIA("CO", "Colombia"),
        COSTA_RICA("CR", "Costa Rica"),
        CUBA("CU", "Cuba"),
        CAPE_VERDE("CV", "Cape Verde"),
        CURACAO("CW", "Cura\u00e7ao"),
        CHRISTMAS_ISLAND("CX", "Christmas Island"),
        CYPRUS("CY", "Cyprus"),
        CZECH_REPUBLIC("CZ", "Czech Republic"),
        GERMANY("DE", "Germany"),
        DJIBOUTI("DJ", "Djibouti"),
        DENMARK("DK", "Denmark"),
        DOMINICA("DM", "Dominica"),
        DOMINICAN_REPUBLIC("DO", "Dominican Republic"),
        ALGERIA("DZ", "Algeria"),
        ECUADOR("EC", "Ecuador"),
        ESTONIA("EE", "Estonia"),
        EGYPT("EG", "Egypt"),
        WESTERN_SAHARA("EH", "Western Sahara"),
        ERITREA("ER", "Eritrea"),
        SPAIN("ES", "Spain"),
        ETHIOPIA("ET", "Ethiopia"),
        FINLAND("FI", "Finland"),
        FIJI("FJ", "Fiji"),
        FALKLAND_ISLANDS("FK", "Falkland Islands"),
        MICRONESIA("FM", "Micronesia"),
        FAROE_ISLANDS("FO", "Faroe Islands"),
        FRANCE("FR", "France"),
        GABON("GA", "Gabon"),
        UNITED_KINGDOM("GB", "United Kingdom"),
        GRENADA("GD", "Grenada"),
        GEORGIA("GE", "Georgia"),
        FRENCH_GUIANA("GF", "French Guiana"),
        GUERNSEY("GG", "Guernsey"),
        GHANA("GH", "Ghana"),
        GIBRALTAR("GI", "Gibraltar"),
        GREENLAND("GL", "Greenland"),
        GAMBIA("GM", "Gambia"),
        GUINEA("GN", "Guinea"),
        GUADELOUPE("GP", "Guadeloupe"),
        EQUATORIAL_GUINEA("GQ", "Equatorial Guinea"),
        GREECE("GR", "Greece"),
        SOUTH_GEORGIA_AND_THE_SOUTH_SANDWICH_ISLANDS("GS", "South Georgia And The South Sandwich Islands"),
        GUATEMALA("GT", "Guatemala"),
        GUAM("GU", "Guam"),
        GUINEA_BISSAU("GW", "Guinea-Bissau"),
        GUYANA("GY", "Guyana"),
        HONG_KONG("HK", "Hong Kong"),
        HEARD_ISLAND_AND_MCDONALD_ISLANDS("HM", "Heard Island And McDonald Islands"),
        HONDURAS("HN", "Honduras"),
        CROATIA("HR", "Croatia"),
        HAITI("HT", "Haiti"),
        HUNGARY("HU", "Hungary"),
        INDONESIA("ID", "Indonesia"),
        IRELAND("IE", "Ireland"),
        ISRAEL("IL", "Israel"),
        ISLE_OF_MAN("IM", "Isle Of Man"),
        INDIA("IN", "India"),
        BRITISH_INDIAN_OCEAN_TERRITORY("IO", "British Indian Ocean Territory"),
        IRAQ("IQ", "Iraq"),
        IRAN("IR", "Iran"),
        ICELAND("IS", "Iceland"),
        ITALY("IT", "Italy"),
        JERSEY("JE", "Jersey"),
        JAMAICA("JM", "Jamaica"),
        JORDAN("JO", "Jordan"),
        JAPAN("JP", "Japan"),
        KENYA("KE", "Kenya"),
        KYRGYZSTAN("KG", "Kyrgyzstan"),
        CAMBODIA("KH", "Cambodia"),
        KIRIBATI("KI", "Kiribati"),
        COMOROS("KM", "Comoros"),
        SAINT_KITTS_AND_NEVIS("KN", "Saint Kitts And Nevis"),
        NORTH_KOREA("KP", "North Korea"),
        SOUTH_KOREA("KR", "South Korea"),
        KUWAIT("KW", "Kuwait"),
        CAYMAN_ISLANDS("KY", "Cayman Islands"),
        KAZAKHSTAN("KZ", "Kazakhstan"),
        LAOS("LA", "Laos"),
        LEBANON("LB", "Lebanon"),
        SAINT_LUCIA("LC", "Saint Lucia"),
        LIECHTENSTEIN("LI", "Liechtenstein"),
        SRI_LANKA("LK", "Sri Lanka"),
        LIBERIA("LR", "Liberia"),
        LESOTHO("LS", "Lesotho"),
        LITHUANIA("LT", "Lithuania"),
        LUXEMBOURG("LU", "Luxembourg"),
        LATVIA("LV", "Latvia"),
        LIBYA("LY", "Libya"),
        MOROCCO("MA", "Morocco"),
        MONACO("MC", "Monaco"),
        MOLDOVA("MD", "Moldova"),
        MONTENEGRO("ME", "Montenegro"),
        SAINT_MARTIN("MF", "Saint Martin"),
        MADAGASCAR("MG", "Madagascar"),
        MARSHALL_ISLANDS("MH", "Marshall Islands"),
        MACEDONIA("MK", "Macedonia"),
        MALI("ML", "Mali"),
        MYANMAR("MM", "Myanmar"),
        MONGOLIA("MN", "Mongolia"),
        MACAO("MO", "Macao"),
        NORTHERN_MARIANA_ISLANDS("MP", "Northern Mariana Islands"),
        MARTINIQUE("MQ", "Martinique"),
        MAURITANIA("MR", "Mauritania"),
        MONTSERRAT("MS", "Montserrat"),
        MALTA("MT", "Malta"),
        MAURITIUS("MU", "Mauritius"),
        MALDIVES("MV", "Maldives"),
        MALAWI("MW", "Malawi"),
        MEXICO("MX", "Mexico"),
        MALAYSIA("MY", "Malaysia"),
        MOZAMBIQUE("MZ", "Mozambique"),
        NAMIBIA("NA", "Namibia"),
        NEW_CALEDONIA("NC", "New Caledonia"),
        NIGER("NE", "Niger"),
        NORFOLK_ISLAND("NF", "Norfolk Island"),
        NIGERIA("NG", "Nigeria"),
        NICARAGUA("NI", "Nicaragua"),
        NETHERLANDS("NL", "Netherlands"),
        NORWAY("NO", "Norway"),
        NEPAL("NP", "Nepal"),
        NAURU("NR", "Nauru"),
        NIUE("NU", "Niue"),
        NEW_ZEALAND("NZ", "New Zealand"),
        OMAN("OM", "Oman"),
        PANAMA("PA", "Panama"),
        PERU("PE", "Peru"),
        FRENCH_POLYNESIA("PF", "French Polynesia"),
        PAPUA_NEW_GUINEA("PG", "Papua New Guinea"),
        PHILIPPINES("PH", "Philippines"),
        PAKISTAN("PK", "Pakistan"),
        POLAND("PL", "Poland"),
        SAINT_PIERRE_AND_MIQUELON("PM", "Saint Pierre And Miquelon"),
        PITCAIRN("PN", "Pitcairn"),
        PUERTO_RICO("PR", "Puerto Rico"),
        PALESTINE("PS", "Palestine"),
        PORTUGAL("PT", "Portugal"),
        PALAU("PW", "Palau"),
        PARAGUAY("PY", "Paraguay"),
        QATAR("QA", "Qatar"),
        REUNION("RE", "Reunion"),
        ROMANIA("RO", "Romania"),
        SERBIA("RS", "Serbia"),
        RUSSIA("RU", "Russia"),
        RWANDA("RW", "Rwanda"),
        SAUDI_ARABIA("SA", "Saudi Arabia"),
        SOLOMON_ISLANDS("SB", "Solomon Islands"),
        SEYCHELLES("SC", "Seychelles"),
        SUDAN("SD", "Sudan"),
        SWEDEN("SE", "Sweden"),
        SINGAPORE("SG", "Singapore"),
        SAINT_HELENA("SH", "Saint Helena"),
        SLOVENIA("SI", "Slovenia"),
        SVALBARD_AND_JAN_MAYEN("SJ", "Svalbard And Jan Mayen"),
        SLOVAKIA("SK", "Slovakia"),
        SIERRA_LEONE("SL", "Sierra Leone"),
        SAN_MARINO("SM", "San Marino"),
        SENEGAL("SN", "Senegal"),
        SOMALIA("SO", "Somalia"),
        SURINAME("SR", "Suriname"),
        SOUTH_SUDAN("SS", "South Sudan"),
        SAO_TOME_AND_PRINCIPE("ST", "Sao Tome And Principe"),
        EL_SALVADOR("SV", "El Salvador"),
        SINT_MAARTEN_DUTCH_PART("SX", "Sint Maarten (Dutch part)"),
        SYRIA("SY", "Syria"),
        SWAZILAND("SZ", "Swaziland"),
        TURKS_AND_CAICOS_ISLANDS("TC", "Turks And Caicos Islands"),
        CHAD("TD", "Chad"),
        FRENCH_SOUTHERN_TERRITORIES("TF", "French Southern Territories"),
        TOGO("TG", "Togo"),
        THAILAND("TH", "Thailand"),
        TAJIKISTAN("TJ", "Tajikistan"),
        TOKELAU("TK", "Tokelau"),
        TIMOR_LESTE("TL", "Timor-Leste"),
        TURKMENISTAN("TM", "Turkmenistan"),
        TUNISIA("TN", "Tunisia"),
        TONGA("TO", "Tonga"),
        TURKEY("TR", "Turkey"),
        TRINIDAD_AND_TOBAGO("TT", "Trinidad and Tobago"),
        TUVALU("TV", "Tuvalu"),
        TAIWAN("TW", "Taiwan"),
        TANZANIA("TZ", "Tanzania"),
        UKRAINE("UA", "Ukraine"),
        UGANDA("UG", "Uganda"),
        UNITED_STATES_MINOR_OUTLYING_ISLANDS("UM", "United States Minor Outlying Islands"),
        UNITED_STATES("US", "United States"),
        URUGUAY("UY", "Uruguay"),
        UZBEKISTAN("UZ", "Uzbekistan"),
        VATICAN("VA", "Vatican"),
        SAINT_VINCENT_AND_THE_GRENADINES("VC", "Saint Vincent And The Grenadines"),
        VENEZUELA("VE", "Venezuela"),
        BRITISH_VIRGIN_ISLANDS("VG", "British Virgin Islands"),
        U_S__VIRGIN_ISLANDS("VI", "U.S. Virgin Islands"),
        VIETNAM("VN", "Vietnam"),
        VANUATU("VU", "Vanuatu"),
        WALLIS_AND_FUTUNA("WF", "Wallis And Futuna"),
        SAMOA("WS", "Samoa"),
        YEMEN("YE", "Yemen"),
        MAYOTTE("YT", "Mayotte"),
        SOUTH_AFRICA("ZA", "South Africa"),
        ZAMBIA("ZM", "Zambia"),
        ZIMBABWE("ZW", "Zimbabwe");

        private String isoTag;
        private String name;

        private Country(String isoTag, String name) {
            this.isoTag = isoTag;
            this.name = name;
        }

        public String getCountryName() {
            return this.name;
        }

        public String getCountryIsoTag() {
            return this.isoTag;
        }

        public static Country byIsoTag(String isoTag) {
            Country[] countryArray = Country.values();
            int n = countryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Country country = countryArray[n2];
                if (country.getCountryIsoTag().equals(isoTag)) {
                    return country;
                }
                ++n2;
            }
            return null;
        }

        public static Country byLocale(Locale locale) {
            return Country.byIsoTag(locale.getCountry());
        }
    }

    public static abstract class CustomChart {
        protected final String chartId;

        public CustomChart(String chartId) {
            if (chartId == null || chartId.isEmpty()) {
                throw new IllegalArgumentException("ChartId cannot be null or empty!");
            }
            this.chartId = chartId;
        }

        protected JsonObject getRequestJsonObject(Logger logger, boolean logFailedRequests) {
            JsonObject data;
            JsonObject chart;
            block4: {
                chart = new JsonObject();
                chart.addProperty("chartId", this.chartId);
                try {
                    data = this.getChartData();
                    if (data != null) break block4;
                    return null;
                }
                catch (Throwable t) {
                    if (logFailedRequests) {
                        logger.log(Level.WARNING, "Failed to get data for custom chart with id " + this.chartId, t);
                    }
                    return null;
                }
            }
            chart.add("data", (JsonElement)data);
            return chart;
        }

        protected abstract JsonObject getChartData();
    }

    public static abstract class MultiLineChart
    extends CustomChart {
        public MultiLineChart(String chartId) {
            super(chartId);
        }

        public abstract HashMap<String, Integer> getValues(HashMap<String, Integer> var1);

        @Override
        protected JsonObject getChartData() {
            JsonObject data = new JsonObject();
            JsonObject values = new JsonObject();
            HashMap<String, Integer> map = this.getValues(new HashMap<String, Integer>());
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean allSkipped = true;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getValue() == 0) continue;
                allSkipped = false;
                values.addProperty(entry.getKey(), (Number)entry.getValue());
            }
            if (allSkipped) {
                return null;
            }
            data.add("values", (JsonElement)values);
            return data;
        }
    }

    public static abstract class SimpleBarChart
    extends CustomChart {
        public SimpleBarChart(String chartId) {
            super(chartId);
        }

        public abstract HashMap<String, Integer> getValues(HashMap<String, Integer> var1);

        @Override
        protected JsonObject getChartData() {
            JsonObject data = new JsonObject();
            JsonObject values = new JsonObject();
            HashMap<String, Integer> map = this.getValues(new HashMap<String, Integer>());
            if (map == null || map.isEmpty()) {
                return null;
            }
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                JsonArray categoryValues = new JsonArray();
                categoryValues.add((JsonElement)new JsonPrimitive((Number)entry.getValue()));
                values.add(entry.getKey(), (JsonElement)categoryValues);
            }
            data.add("values", (JsonElement)values);
            return data;
        }
    }

    public static abstract class SimpleMapChart
    extends CustomChart {
        public SimpleMapChart(String chartId) {
            super(chartId);
        }

        public abstract Country getValue();

        @Override
        protected JsonObject getChartData() {
            JsonObject data = new JsonObject();
            Country value = this.getValue();
            if (value == null) {
                return null;
            }
            data.addProperty("value", value.getCountryIsoTag());
            return data;
        }
    }

    public static abstract class SimplePie
    extends CustomChart {
        public SimplePie(String chartId) {
            super(chartId);
        }

        public abstract String getValue();

        @Override
        protected JsonObject getChartData() {
            JsonObject data = new JsonObject();
            String value = this.getValue();
            if (value == null || value.isEmpty()) {
                return null;
            }
            data.addProperty("value", value);
            return data;
        }
    }

    public static abstract class SingleLineChart
    extends CustomChart {
        public SingleLineChart(String chartId) {
            super(chartId);
        }

        public abstract int getValue();

        @Override
        protected JsonObject getChartData() {
            JsonObject data = new JsonObject();
            int value = this.getValue();
            if (value == 0) {
                return null;
            }
            data.addProperty("value", (Number)value);
            return data;
        }
    }
}

