/*
 * Decompiled with CFR 0.152.
 */
package me.jul1an_k.tablist.bukkit.scoreboard;

import java.util.HashMap;
import java.util.Map;
import me.jul1an_k.tablist.bukkit.sTablistAPI;
import me.jul1an_k.tablist.bukkit.scoreboard.ScoreboardConfig;
import me.jul1an_k.tablist.bukkit.variables.VariableManager;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class STLScoreboard {
    private static ScoreboardConfig sbcfg = new ScoreboardConfig();
    private static FileConfiguration fc = STLScoreboard.sbcfg.YAML;
    private static int currentScore = 0;
    private static Map<Player, Scoreboard> boards = new HashMap<Player, Scoreboard>();

    private static void addScore(Objective obj, String name) {
        obj.getScore(name).setScore(currentScore);
        --currentScore;
    }

    public static void show(Player p) {
        Scoreboard board = boards.containsKey(p) ? boards.get(p) : boards.put(p, Bukkit.getScoreboardManager().getNewScoreboard());
        board.clearSlot(DisplaySlot.SIDEBAR);
        Objective obj = board.getObjective(p.getName()) == null ? board.registerNewObjective(p.getName(), p.getName()) : board.getObjective(p.getName());
        obj.unregister();
        p.sendMessage("unregister done.");
        currentScore = 0;
        board = Bukkit.getScoreboardManager().getMainScoreboard();
        obj = board.getObjective(p.getName()) == null ? board.registerNewObjective(p.getName(), p.getName()) : board.getObjective(p.getName());
        obj.setDisplaySlot(DisplaySlot.SIDEBAR);
        obj.setDisplayName(VariableManager.replace(fc.getString("DisplayName"), p));
        for (String s : fc.getStringList("Lines")) {
            String replaced = VariableManager.replaceScoreboard(s, p);
            if (sTablistAPI.compareMinecraftVersionServerIsHigherOrEqual("1.8")) {
                if (replaced.length() > 40) {
                    replaced = replaced.substring(replaced.length());
                }
            } else if (sTablistAPI.compareMinecraftVersionServerIsHigherOrEqual("1.7.10") && replaced.length() > 16) {
                replaced = replaced.substring(replaced.length());
            }
            STLScoreboard.addScore(obj, VariableManager.replaceScoreboard(replaced, p));
        }
        p.setScoreboard(board);
    }

    public static Scoreboard getBoard(Player p) {
        return boards.get(p);
    }
}

