/*
 * Decompiled with CFR 0.152.
 */
package me.jul1an_k.tablist.bukkit;

import java.lang.reflect.Field;
import me.jul1an_k.tablist.bukkit.variables.VariableManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class sTablistAPI {
    private static Class<?> chatserial;
    private static Class<?> title;
    private static Class<?> enumtitleaction;

    static {
        if (sTablistAPI.compareMinecraftVersionServerIsHigherOrEqual("1.8.3")) {
            chatserial = sTablistAPI.getNMSClass("IChatBaseComponent$ChatSerializer");
            title = sTablistAPI.getNMSClass("PacketPlayOutTitle");
            enumtitleaction = sTablistAPI.getNMSClass("PacketPlayOutTitle$EnumTitleAction");
        } else if (sTablistAPI.compareMinecraftVersionServerIsHigherOrEqual("1.8")) {
            chatserial = sTablistAPI.getNMSClass("ChatSerializer");
            title = sTablistAPI.getNMSClass("PacketPlayOutTitle");
            enumtitleaction = sTablistAPI.getNMSClass("EnumTitleAction");
        } else if (sTablistAPI.compareMinecraftVersionServerIsHigherOrEqual("1.7.10")) {
            chatserial = sTablistAPI.getNMSClass("ChatSerializer");
            title = sTablistAPI.getProtocolInjectorClass("PacketTitle");
            enumtitleaction = sTablistAPI.getProtocolInjectorClass("PacketTitle$Action");
        }
    }

    public static void sendTabList(Player p, String header, String footer) {
        try {
            if (header != null) {
                header = VariableManager.replaceTab(header, p);
            }
            if (footer != null) {
                footer = VariableManager.replaceTab(footer, p);
            }
            if (sTablistAPI.compareMinecraftVersionServerIsHigherOrEqual("1.8")) {
                Object packet = sTablistAPI.getNMSClass("PacketPlayOutPlayerListHeaderFooter").newInstance();
                if (header != null) {
                    sTablistAPI.getField(packet.getClass().getDeclaredField("a")).set(packet, chatserial.getMethod("a", String.class).invoke(null, "{\"text\": \"" + header + "\"}"));
                }
                if (footer != null) {
                    sTablistAPI.getField(packet.getClass().getDeclaredField("b")).set(packet, chatserial.getMethod("a", String.class).invoke(null, "{\"text\": \"" + footer + "\"}"));
                }
                sTablistAPI.sendPacket(p, packet);
            } else if (sTablistAPI.compareMinecraftVersionServerIsHigherOrEqual("1.7.10")) {
                Object packet = sTablistAPI.getProtocolInjectorClass("PacketTabHeader").newInstance();
                if (header != null) {
                    sTablistAPI.getField(packet.getClass().getDeclaredField("header")).set(packet, chatserial.getMethod("a", String.class).invoke(null, "{\"text\": \"" + header + "\"}"));
                }
                if (footer != null) {
                    sTablistAPI.getField(packet.getClass().getDeclaredField("footer")).set(packet, chatserial.getMethod("a", String.class).invoke(null, "{\"text\": \"" + footer + "\"}"));
                }
                sTablistAPI.sendPacket(p, packet);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendActionBar(Player p, String message) {
        if (message == null) {
            message = "";
        }
        message = VariableManager.replace(message, p);
        try {
            if (sTablistAPI.compareMinecraftVersionServerIsHigherOrEqual("1.8")) {
                sTablistAPI.sendPacket(p, "PacketPlayOutChat", new Class[]{sTablistAPI.getNMSClass("IChatBaseComponent"), Byte.TYPE}, chatserial.getMethod("a", String.class).invoke(null, "{\"text\": \"" + message + "\"}"), (byte)2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendTitle(Player p, String title, String subtitle, int fadein, int stay, int fadeout, boolean clear, boolean reset) {
        title = VariableManager.replace(title, p);
        subtitle = VariableManager.replace(subtitle, p);
        try {
            if (sTablistAPI.compareMinecraftVersionServerIsHigherOrEqual("1.8")) {
                Object t = sTablistAPI.title.newInstance();
                Field f = t.getClass().getDeclaredField("a");
                f.setAccessible(true);
                f.set(t, sTablistAPI.getField(enumtitleaction.getDeclaredField("TITLE")).get(null));
                f = t.getClass().getDeclaredField("b");
                f.setAccessible(true);
                f.set(t, chatserial.getMethod("a", String.class).invoke(null, "{\"text\": \"" + title + "\"}"));
                sTablistAPI.sendPacket(p, t);
                t = sTablistAPI.title.newInstance();
                f = t.getClass().getDeclaredField("a");
                f.setAccessible(true);
                f.set(t, sTablistAPI.getField(enumtitleaction.getDeclaredField("SUBTITLE")).get(null));
                f = t.getClass().getDeclaredField("b");
                f.setAccessible(true);
                f.set(t, chatserial.getMethod("a", String.class).invoke(null, "{\"text\": \"" + subtitle + "\"}"));
                sTablistAPI.sendPacket(p, t);
                t = sTablistAPI.title.newInstance();
                f = t.getClass().getDeclaredField("a");
                f.setAccessible(true);
                f.set(t, sTablistAPI.getField(enumtitleaction.getDeclaredField("TIMES")).get(null));
                f = t.getClass().getDeclaredField("c");
                f.setAccessible(true);
                f.set(t, fadein);
                f = t.getClass().getDeclaredField("d");
                f.setAccessible(true);
                f.set(t, stay);
                f = t.getClass().getDeclaredField("e");
                f.setAccessible(true);
                f.set(t, fadeout);
                sTablistAPI.sendPacket(p, t);
                if (clear) {
                    t = sTablistAPI.title.newInstance();
                    f = t.getClass().getDeclaredField("a");
                    f.setAccessible(true);
                    f.set(t, sTablistAPI.getField(enumtitleaction.getDeclaredField("CLEAR")).get(null));
                    sTablistAPI.sendPacket(p, t);
                }
                if (reset) {
                    t = sTablistAPI.title.newInstance();
                    f = t.getClass().getDeclaredField("a");
                    f.setAccessible(true);
                    f.set(t, sTablistAPI.getField(enumtitleaction.getDeclaredField("RESET")).get(null));
                    sTablistAPI.sendPacket(p, t);
                }
            } else if (sTablistAPI.compareMinecraftVersionServerIsHigherOrEqual("1.7.10")) {
                Object t = sTablistAPI.title.newInstance();
                Field f = t.getClass().getDeclaredField("action");
                f.setAccessible(true);
                f.set(t, sTablistAPI.getField(enumtitleaction.getDeclaredField("TITLE")).get(null));
                f = t.getClass().getDeclaredField("text");
                f.setAccessible(true);
                f.set(t, chatserial.getMethod("a", String.class).invoke(null, "{\"text\": \"" + title + "\"}"));
                sTablistAPI.sendPacket(p, t);
                t = sTablistAPI.title.newInstance();
                f = t.getClass().getDeclaredField("action");
                f.setAccessible(true);
                f.set(t, sTablistAPI.getField(enumtitleaction.getDeclaredField("SUBTITLE")).get(null));
                f = t.getClass().getDeclaredField("text");
                f.setAccessible(true);
                f.set(t, chatserial.getMethod("a", String.class).invoke(null, "{\"text\": \"" + subtitle + "\"}"));
                sTablistAPI.sendPacket(p, t);
                t = sTablistAPI.title.newInstance();
                f = t.getClass().getDeclaredField("action");
                f.setAccessible(true);
                f.set(t, sTablistAPI.getField(enumtitleaction.getDeclaredField("TIMES")).get(null));
                f = t.getClass().getDeclaredField("fadeIn");
                f.setAccessible(true);
                f.set(t, fadein);
                f = t.getClass().getDeclaredField("stay");
                f.setAccessible(true);
                f.set(t, stay);
                f = t.getClass().getDeclaredField("fadeOut");
                f.setAccessible(true);
                f.set(t, fadeout);
                sTablistAPI.sendPacket(p, t);
                if (clear) {
                    t = sTablistAPI.title.newInstance();
                    f = t.getClass().getDeclaredField("action");
                    f.setAccessible(true);
                    f.set(t, sTablistAPI.getField(enumtitleaction.getDeclaredField("CLEAR")).get(null));
                    sTablistAPI.sendPacket(p, t);
                }
                if (reset) {
                    t = sTablistAPI.title.newInstance();
                    f = t.getClass().getDeclaredField("action");
                    f.setAccessible(true);
                    f.set(t, sTablistAPI.getField(enumtitleaction.getDeclaredField("RESET")).get(null));
                    sTablistAPI.sendPacket(p, t);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void sendPacket(Player p, Object packet) {
        try {
            Object nmsPlayer = sTablistAPI.getNMSPlayer(p);
            Object connection = nmsPlayer.getClass().getField("playerConnection").get(nmsPlayer);
            connection.getClass().getMethod("sendPacket", sTablistAPI.getNMSClass("Packet")).invoke(connection, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void sendPacket(Player p, String packetName, Class<?>[] parameterclass, Object ... parameters) {
        try {
            Object nmsPlayer = sTablistAPI.getNMSPlayer(p);
            Object connection = nmsPlayer.getClass().getField("playerConnection").get(nmsPlayer);
            Object packet = Class.forName(String.valueOf(nmsPlayer.getClass().getPackage().getName()) + "." + packetName).getConstructor(parameterclass).newInstance(parameters);
            connection.getClass().getMethod("sendPacket", sTablistAPI.getNMSClass("Packet")).invoke(connection, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getVersion() {
        String name = Bukkit.getServer().getClass().getPackage().getName();
        return String.valueOf(name.substring(name.lastIndexOf(46) + 1)) + ".";
    }

    private static Class<?> getNMSClass(String className) {
        String fullName = "net.minecraft.server." + sTablistAPI.getVersion() + className;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(fullName);
        }
        catch (ClassNotFoundException e) {
            System.err.println("[ssTablistAPI] Can't find the Class '" + fullName + "'!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clazz;
    }

    private static Class<?> getProtocolInjectorClass(String className) {
        String fullName = "org.spigotmc.ProtocolInjector$" + className;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(fullName);
        }
        catch (ClassNotFoundException e) {
            System.err.println("[sTablist] Can't find the Class '" + fullName + "'!");
        }
        return clazz;
    }

    private static Object getNMSPlayer(Player p) {
        try {
            return p.getClass().getMethod("getHandle", new Class[0]).invoke((Object)p, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Field getField(Field f) {
        f.setAccessible(true);
        return f;
    }

    public static int getPing(Player p) {
        int pingInt = 0;
        Object nmsPlayer = sTablistAPI.getNMSPlayer(p);
        try {
            Field ping = nmsPlayer.getClass().getField("ping");
            pingInt = ping.getInt(nmsPlayer);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return pingInt;
    }

    public static boolean compareMinecraftVersionServerIsHigherOrEqual(String version) {
        String serverVersion = Bukkit.getVersion();
        serverVersion = serverVersion.substring(serverVersion.indexOf("(MC: ") + 5, serverVersion.length());
        serverVersion = serverVersion.substring(0, serverVersion.lastIndexOf(")"));
        String[] serverVersionArray = serverVersion.split("\\.");
        String[] toCompareVersionArray = version.split("\\.");
        if (serverVersionArray.length == 2) {
            int serverFirst = Integer.valueOf(serverVersionArray[0]);
            int toCompareFirst = Integer.valueOf(toCompareVersionArray[0]);
            if (toCompareFirst != serverFirst) {
                return toCompareFirst < serverFirst;
            }
            int serverSecond = Integer.valueOf(serverVersionArray[1]);
            int toCompareSecond = Integer.valueOf(toCompareVersionArray[1]);
            if (toCompareSecond != serverSecond) {
                return toCompareSecond < serverSecond;
            }
            return toCompareVersionArray.length != 3;
        }
        if (serverVersionArray.length == 3) {
            int serverFirst = Integer.valueOf(serverVersionArray[0]);
            int toCompareFirst = Integer.valueOf(toCompareVersionArray[0]);
            if (toCompareFirst != serverFirst) {
                return toCompareFirst < serverFirst;
            }
            int serverSecond = Integer.valueOf(serverVersionArray[1]);
            int toCompareSecond = Integer.valueOf(toCompareVersionArray[1]);
            if (toCompareSecond != serverSecond) {
                return toCompareSecond < serverSecond;
            }
            if (toCompareVersionArray.length != 3) {
                return true;
            }
            int serverThird = Integer.valueOf(serverVersionArray[2]);
            int toCompareThird = Integer.valueOf(toCompareVersionArray[2]);
            if (toCompareThird != serverThird) {
                return toCompareThird < serverThird;
            }
            return true;
        }
        return false;
    }
}

