/*
 * Decompiled with CFR 0.152.
 */
package me.jul1an_k.tablist.bukkit;

import java.util.ArrayList;
import me.jul1an_k.tablist.bukkit.commands.InfoCommand;
import me.jul1an_k.tablist.bukkit.commands.TabReloadCommand;
import me.jul1an_k.tablist.bukkit.commands.TabSetCommand;
import me.jul1an_k.tablist.bukkit.commands.TablistCommand;
import me.jul1an_k.tablist.bukkit.listener.Join_Listener;
import me.jul1an_k.tablist.bukkit.metrics.Metrics;
import me.jul1an_k.tablist.bukkit.sTablistAPI;
import me.jul1an_k.tablist.bukkit.scoreboard.STLScoreboard;
import me.jul1an_k.tablist.bukkit.scoreboard.ScoreboardConfig;
import me.jul1an_k.tablist.bukkit.tabprefix.TabPrefix;
import me.jul1an_k.tablist.bukkit.update.FileUpdate;
import me.jul1an_k.tablist.bukkit.variables.VariableManager;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Tablist
extends JavaPlugin {
    public static ScoreboardConfig sbcfg;
    private static int UpdateTask;
    private static int TagUpdateTask;

    static {
        UpdateTask = 0;
        TagUpdateTask = 0;
    }

    public void onEnable() {
        long start = System.currentTimeMillis();
        if (sTablistAPI.compareMinecraftVersionServerIsHigherOrEqual("1.8")) {
            System.out.println("[sTablist] Found Compatible Packets " + sTablistAPI.getVersion());
        } else if (sTablistAPI.compareMinecraftVersionServerIsHigherOrEqual("1.7.10")) {
            try {
                Class.forName("org.spigotmc.ProtocolInjector$PacketTabHeader");
            }
            catch (ClassNotFoundException e) {
                System.out.println("[sTablist] Found Compatible Packets " + sTablistAPI.getVersion());
                System.err.println("[sTablist] Can't find the 'org.spigotmc.ProtocolInjector$PacketTabHeader' Class!");
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            System.out.println("[sTablist] Found Compatible Packets " + sTablistAPI.getVersion());
        } else {
            System.err.println("[sTablist] Found Incompatible Packets " + sTablistAPI.getVersion());
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
        this.saveDefaultConfig();
        this.saveResource("Prefixes-And-Suffixes/groups.yml", false);
        this.loadConfig();
        if (this.getConfig().getBoolean("EnableAutoUpdater")) {
            FileUpdate updater = new FileUpdate();
            if (updater.check()) {
                return;
            }
            Tablist.startPluginUpdate();
        }
        if (!this.getConfig().getString("ConfigVersion").equals(this.getDescription().getVersion())) {
            System.err.println("[sTablist] Found outdated Configuration! (Your Version: " + this.getConfig().getString("ConfigVersion") + " | Newest Version: " + this.getDescription().getVersion() + ")");
            System.err.println("[sTablist] Use /stablist regenConfig to regenerate the Configuration.");
        }
        for (String group : TabPrefix.getGroupsFile().getYaml().getConfigurationSection("").getKeys(false)) {
            if (group.equalsIgnoreCase("GroupSort")) continue;
            TabPrefix.setupGroup(group, TabPrefix.getGroupsFile().getYaml().getString(String.valueOf(group) + ".Prefix"), TabPrefix.getGroupsFile().getYaml().getString(String.valueOf(group) + ".Suffix"));
        }
        Bukkit.getPluginManager().registerEvents((Listener)new Join_Listener(), (Plugin)this);
        if (((Tablist)Tablist.getPlugin(Tablist.class)).getConfig().getBoolean("EnablePvPStats")) {
            Bukkit.getPluginManager().registerEvents((Listener)new VariableManager.PvPVariables(), (Plugin)this);
        }
        Bukkit.getPluginManager().registerEvents((Listener)new TabPrefix(), (Plugin)this);
        this.getCommand("sTabReload").setExecutor((CommandExecutor)new TabReloadCommand());
        this.getCommand("setTab").setExecutor((CommandExecutor)new TabSetCommand());
        this.getCommand("Update").setExecutor((CommandExecutor)new FileUpdate());
        this.getCommand("sTabInfo").setExecutor((CommandExecutor)new InfoCommand());
        this.getCommand("sTablist").setExecutor((CommandExecutor)new TablistCommand());
        Tablist.startUpdate();
        Tablist.startTagUpdate();
        new Metrics(this);
        long stop = System.currentTimeMillis();
        System.out.println("[sTablist] Started in " + (stop - start) + " Millis!");
    }

    private void loadConfig() {
        this.saveDefaultConfig();
        FileConfiguration fc = this.getConfig();
        if (!fc.contains("RandomColors")) {
            ArrayList<String> randomColors = new ArrayList<String>();
            randomColors.add("&0");
            randomColors.add("&1");
            randomColors.add("&2");
            randomColors.add("&3");
            randomColors.add("&4");
            randomColors.add("&5");
            randomColors.add("&6");
            randomColors.add("&7");
            randomColors.add("&8");
            randomColors.add("&9");
            randomColors.add("&a");
            randomColors.add("&b");
            randomColors.add("&c");
            randomColors.add("&d");
            randomColors.add("&e");
            randomColors.add("&f");
            fc.set("RandomColors", randomColors);
        }
        if (!fc.contains("UseExternalScoreboard")) {
            fc.set("UseExternalScoreboard", (Object)false);
        }
        this.saveConfig();
    }

    public void onDisable() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
    }

    public static void startUpdate() {
        long start = System.currentTimeMillis();
        UpdateTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Tablist.getPlugin(Tablist.class), new Runnable(){

            @Override
            public void run() {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    Tablist instance = (Tablist)Tablist.getPlugin(Tablist.class);
                    if (instance.getConfig().getBoolean("HideGM3")) {
                        Tablist.hidePlayer(p);
                    }
                    boolean header = instance.getConfig().getBoolean("Header.use");
                    boolean footer = instance.getConfig().getBoolean("Footer.use");
                    if (header && footer) {
                        sTablistAPI.sendTabList(p, instance.getConfig().getString("Header.text"), instance.getConfig().getString("Footer.text"));
                        continue;
                    }
                    if (header) {
                        sTablistAPI.sendTabList(p, instance.getConfig().getString("Header.text"), null);
                        continue;
                    }
                    if (!footer) continue;
                    sTablistAPI.sendTabList(p, null, instance.getConfig().getString("Footer.text"));
                }
            }
        }, (long)(((Tablist)Tablist.getPlugin(Tablist.class)).getConfig().getInt("TabAutoUpdate") * 20), (long)(((Tablist)Tablist.getPlugin(Tablist.class)).getConfig().getInt("TabAutoUpdate") * 20));
        long stop = System.currentTimeMillis();
        System.out.println("[sTablist] Tab Update Task was started in " + (stop - start) + " Millis!");
    }

    private static void hidePlayer(Player p) {
        if (p.getGameMode() == GameMode.SPECTATOR) {
            for (Player all : Bukkit.getOnlinePlayers()) {
                if (!all.canSee(p)) continue;
                all.hidePlayer(p);
            }
        } else {
            for (Player all : Bukkit.getOnlinePlayers()) {
                if (all.canSee(p)) continue;
                all.showPlayer(p);
            }
        }
    }

    public static void stopUpdate() {
        long start = System.currentTimeMillis();
        Bukkit.getScheduler().cancelTask(UpdateTask);
        long stop = System.currentTimeMillis();
        System.out.println("[sTablist] Tab Update Task was stopped in " + (stop - start) + " Millis!");
    }

    public static void startTagUpdate() {
        long start = System.currentTimeMillis();
        TagUpdateTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Tablist.getPlugin(Tablist.class), new Runnable(){

            @Override
            public void run() {
                for (Player all : Bukkit.getOnlinePlayers()) {
                    TabPrefix.loadNametag(all);
                }
            }
        }, (long)(((Tablist)Tablist.getPlugin(Tablist.class)).getConfig().getInt("TagAutoUpdate") * 20), (long)(((Tablist)Tablist.getPlugin(Tablist.class)).getConfig().getInt("TagAutoUpdate") * 20));
        long stop = System.currentTimeMillis();
        System.out.println("[sTablist] Tag Update Task was started in " + (stop - start) + " Millis!");
    }

    public static void stopTagUpdate() {
        long start = System.currentTimeMillis();
        Bukkit.getScheduler().cancelTask(TagUpdateTask);
        long stop = System.currentTimeMillis();
        System.out.println("[sTablist] Tag Update Task was stopped in " + (stop - start) + " Millis!");
    }

    private static void startPluginUpdate() {
        long start = System.currentTimeMillis();
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Tablist.getPlugin(Tablist.class), new Runnable(){

            @Override
            public void run() {
                FileUpdate updater = new FileUpdate();
                updater.check();
            }
        }, (long)(((Tablist)Tablist.getPlugin(Tablist.class)).getConfig().getInt("PluginAutoUpdate") * 20), (long)(((Tablist)Tablist.getPlugin(Tablist.class)).getConfig().getInt("PluginAutoUpdate") * 20));
        long stop = System.currentTimeMillis();
        System.out.println("[sTablist] Plugin Update Task was started in " + (stop - start) + " Millis!");
    }

    private static void startScoreboardUpdate() {
        long start = System.currentTimeMillis();
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Tablist.getPlugin(Tablist.class), new Runnable(){

            @Override
            public void run() {
                for (Player all : Bukkit.getOnlinePlayers()) {
                    STLScoreboard.show(all);
                }
            }
        }, (long)Tablist.sbcfg.YAML.getInt("UpdateTime"), (long)Tablist.sbcfg.YAML.getInt("UpdateTime"));
        long stop = System.currentTimeMillis();
        System.out.println("[sTablist] Scoreboard Update Task was started in " + (stop - start) + " Millis!");
    }
}

