/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.pluginannotations.description.processor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.bukkit.plugin.java.JavaPlugin;
import org.inventivetalent.pluginannotations.description.Author;
import org.inventivetalent.pluginannotations.description.Database;
import org.inventivetalent.pluginannotations.description.Depend;
import org.inventivetalent.pluginannotations.description.Description;
import org.inventivetalent.pluginannotations.description.LoadBefore;
import org.inventivetalent.pluginannotations.description.Plugin;
import org.inventivetalent.pluginannotations.description.Prefix;
import org.inventivetalent.pluginannotations.description.SoftDepend;
import org.inventivetalent.pluginannotations.description.Website;
import org.yaml.snakeyaml.Yaml;

@SupportedAnnotationTypes(value={"org.inventivetalent.pluginannotations.description.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class DescriptionProcessor
extends AbstractProcessor {
    final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyy HH:mm:ss");
    final Map<String, Object> yamlMap = new HashMap<String, Object>();

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        String[] stringArray;
        String[] stringArray2;
        void var7_9;
        long generateStart = System.currentTimeMillis();
        Element mainElement = null;
        for (Element element : roundEnv.getElementsAnnotatedWith(Plugin.class)) {
            if (mainElement != null) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Multiple @Plugin classes found!");
                return false;
            }
            mainElement = element;
        }
        if (mainElement == null) {
            return false;
        }
        if (!(mainElement instanceof TypeElement)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@Plugin is not a TypeElement");
            return false;
        }
        TypeElement mainTypeElement = (TypeElement)mainElement;
        if (!this.processingEnv.getTypeUtils().isSubtype(mainTypeElement.asType(), this.processingEnv.getElementUtils().getTypeElement(JavaPlugin.class.getName()).asType())) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@Plugin does not extend JavaPlugin");
            return false;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generating plugin.yml for " + mainTypeElement.getQualifiedName().toString() + "...");
        String string = this.getAnnotationValue(mainTypeElement, "main", Plugin.class, String.class);
        if (string == null || string.isEmpty()) {
            String string2 = mainTypeElement.getQualifiedName().toString();
        }
        this.yamlMap.put("main", var7_9);
        this.appendAnnotation("name", mainTypeElement, "name", Plugin.class, String.class);
        this.appendAnnotation("version", mainTypeElement, "version", "0.0.0", Plugin.class, String.class);
        this.appendAnnotation("description", mainTypeElement, "value", Description.class, String.class);
        this.appendAnnotation("load", mainTypeElement, "value", Description.class, String.class);
        String[] stringArray3 = this.getAnnotationValue(mainTypeElement, "value", Author.class, String[].class);
        if (stringArray3 != null && stringArray3.length > 0) {
            if (stringArray3.length == 1) {
                this.yamlMap.put("author", stringArray3[0]);
            } else {
                this.yamlMap.put("authors", stringArray3);
            }
        }
        this.appendAnnotation("website", mainTypeElement, "value", Website.class, String.class);
        this.appendAnnotation("database", mainTypeElement, "value", Database.class, Boolean.TYPE);
        String[] stringArray4 = this.getAnnotationValue(mainTypeElement, "value", Depend.class, String[].class);
        if (stringArray4 != null && stringArray4.length > 0) {
            this.yamlMap.put("depend", stringArray4);
        }
        if ((stringArray2 = this.getAnnotationValue(mainTypeElement, "value", SoftDepend.class, String[].class)) != null && stringArray2.length > 0) {
            this.yamlMap.put("softdepend", stringArray2);
        }
        if ((stringArray = this.getAnnotationValue(mainTypeElement, "value", LoadBefore.class, String[].class)) != null && stringArray.length > 0) {
            this.yamlMap.put("loadbefore", stringArray);
        }
        this.appendAnnotation("prefix", mainTypeElement, "value", Prefix.class, String.class);
        try {
            Yaml yaml = new Yaml();
            try {
                Yaml templateYaml = new Yaml();
                FileObject sourceDescriptionFile = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", "plugin.yml");
                if (sourceDescriptionFile != null) {
                    InputStream inputStream = sourceDescriptionFile.openInputStream();
                    this.yamlMap.putAll((Map)templateYaml.load(inputStream));
                    inputStream.close();
                }
            }
            catch (FileNotFoundException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "No plugin.yml template found");
            }
            FileObject descriptionFile = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "plugin.yml", new Element[0]);
            try (Writer writer = descriptionFile.openWriter();){
                writer.append("# plugin.yml generated on ").append(this.simpleDateFormat.format(new Date())).append(" by PluginAnnotations (https://r.spiget.org/20446) \r\n");
                yaml.dump(this.yamlMap, writer);
                writer.append("## Generated in ").append(String.valueOf(System.currentTimeMillis() - generateStart)).append("ms");
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return true;
    }

    <A extends Annotation, V> V appendAnnotation(String key, Element element, String valueName, Class<A> annotationClass, Class<V> valueClass) {
        return this.appendAnnotation(key, element, valueName, null, annotationClass, valueClass);
    }

    <A extends Annotation, V> V appendAnnotation(String key, Element element, String valueName, V defaultValue, Class<A> annotationClass, Class<V> valueClass) {
        V value = this.getAnnotationValue(element, valueName, annotationClass, valueClass);
        if (value != null) {
            this.yamlMap.put(key, value);
        } else if (defaultValue != null) {
            this.yamlMap.put(key, defaultValue);
        }
        return value;
    }

    <A extends Annotation, V> V getAnnotationValue(Element element, String valueName, Class<A> annotationClass, Class<V> valueClass) {
        A annotation = element.getAnnotation(annotationClass);
        if (annotation != null) {
            try {
                Object value = annotationClass.getDeclaredMethod(valueName, new Class[0]).invoke(annotation, new Object[0]);
                return (V)(valueClass == String.class ? value.toString() : valueClass.cast(value));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

