/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.nicknamer.command;

import java.util.Collection;
import java.util.HashSet;
import java.util.IllegalFormatException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.inventivetalent.nicknamer.NickNamerPlugin;
import org.inventivetalent.nicknamer.api.NickNamerAPI;
import org.inventivetalent.nicknamer.command.CommandUtil;
import org.inventivetalent.nicknamer.command.NickNamerErrorHandler;
import org.inventivetalent.pluginannotations.command.Command;
import org.inventivetalent.pluginannotations.command.OptionalArg;
import org.inventivetalent.pluginannotations.command.Permission;
import org.inventivetalent.pluginannotations.command.exception.PermissionException;
import org.inventivetalent.pluginannotations.message.MessageFormatter;

public class NickCommands {
    private NickNamerPlugin plugin;

    public NickCommands(NickNamerPlugin plugin) {
        this.plugin = plugin;
    }

    @Command(name="nickname", aliases={"nick"}, usage="<Name> [Player]", description="Set your own, or another player's nick name", min=1, max=2, errorHandler=NickNamerErrorHandler.class)
    @Permission(value="nick.command.name")
    public void nick(CommandSender sender, String nick, @OptionalArg String targetName) {
        boolean otherTarget = targetName != null && !targetName.isEmpty();
        final Player target = CommandUtil.findTarget(sender, targetName, otherTarget);
        if (target == null) {
            return;
        }
        if (otherTarget && !sender.hasPermission("nick.other")) {
            throw new PermissionException("nick.other");
        }
        if (nick.length() > 16) {
            sender.sendMessage(CommandUtil.MESSAGE_LOADER.getMessage("name.error.length", "name.error.length"));
            return;
        }
        if (!sender.hasPermission("nick.name." + nick) && !sender.hasPermission("nick.name.*")) {
            throw new PermissionException("nick.name." + nick);
        }
        try {
            nick = String.format(this.plugin.namesFormat, nick);
        }
        catch (IllegalFormatException e) {
            this.plugin.getLogger().warning("Cannot format name, invalid name format: " + this.plugin.namesFormat);
        }
        if (sender.hasPermission("nick.colored")) {
            nick = ChatColor.translateAlternateColorCodes((char)'&', (String)nick);
        }
        if (nick.length() > 16) {
            nick = nick.substring(0, 16);
        }
        final String finalNick = nick;
        sender.sendMessage(CommandUtil.MESSAGE_LOADER.getMessage("name.changed", "name.changed", new MessageFormatter(){

            @Override
            public String format(String key, String message) {
                return message.replace("%player%", target.getName()).replace("%name%", finalNick);
            }
        }));
        NickNamerAPI.getNickManager().setNick(target.getUniqueId(), nick);
    }

    @Command(name="clearNick", aliases={"nickclear", "resetnick"}, usage="[Player]", description="Reset your own, or another player's nick name", min=0, max=1)
    @Permission(value="nick.command.name.clear")
    public void clearNick(final CommandSender sender, @OptionalArg String targetName) {
        boolean otherTarget = targetName != null && !targetName.isEmpty();
        final Player target = CommandUtil.findTarget(sender, targetName, otherTarget);
        if (target == null) {
            return;
        }
        if (otherTarget && !sender.hasPermission("nick.other")) {
            throw new PermissionException("nick.other");
        }
        NickNamerAPI.getNickManager().removeNick(target.getUniqueId());
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                sender.sendMessage(CommandUtil.MESSAGE_LOADER.getMessage("name.cleared", "name.cleared", new MessageFormatter(){

                    @Override
                    public String format(String key, String message) {
                        return message.replace("%player%", target.getName());
                    }
                }));
            }
        }, 10L);
    }

    @Command(name="randomNick", aliases={"nickrandom"}, usage="[Player] [Category]", description="Get a random nick name", min=0, max=2)
    @Permission(value="nick.command.name.random")
    public void randomNick(CommandSender sender, @OptionalArg String targetName, final @OptionalArg(def="__default__") String category) {
        if (!this.plugin.randomNicks.containsKey(category)) {
            sender.sendMessage(CommandUtil.MESSAGE_LOADER.getMessage("name.error.category.unknown", "name.error.category.unknown", new MessageFormatter(){

                @Override
                public String format(String key, String message) {
                    return String.format(message, category);
                }
            }));
        } else if (sender instanceof Player) {
            ((Player)sender).chat("/nickname " + NickNamerAPI.getRandomNick(this.plugin.randomNicks.get(category)) + (targetName != null ? " " + targetName : ""));
        } else {
            Bukkit.getServer().dispatchCommand(sender, "/nickname " + NickNamerAPI.getRandomNick(this.plugin.randomNicks.get(category)) + (targetName != null ? " " + targetName : ""));
        }
    }

    @Command(name="refreshNick", aliases={"nickrefresh", "refreshskin", "reloadskin", "reloadnick"}, usage="[Player]", description="Refresh the displayed skin", min=0, max=1)
    @Permission(value="nick.command.refresh")
    public void refreshNick(CommandSender sender, @OptionalArg String targetName) {
        boolean otherTarget = targetName != null && !targetName.isEmpty();
        Player target = CommandUtil.findTarget(sender, targetName, otherTarget);
        if (target == null) {
            return;
        }
        if (otherTarget && !sender.hasPermission("nick.other")) {
            throw new PermissionException("nick.other");
        }
        NickNamerAPI.getNickManager().refreshPlayer(target.getUniqueId());
    }

    @Command(name="listNames", aliases={"nicklist", "listnick"}, description="Get a list of used names", max=0)
    @Permission(value="nick.command.name.list")
    public void listNick(CommandSender sender) {
        Collection<String> usedNicks = NickNamerAPI.getNickManager().getUsedNicks();
        if (usedNicks.isEmpty()) {
            sender.sendMessage(CommandUtil.MESSAGE_LOADER.getMessage("name.error.list.empty", "name.error.list.empty"));
            return;
        }
        sender.sendMessage(CommandUtil.MESSAGE_LOADER.getMessage("name.list.used", "name.list.used"));
        for (final String used : usedNicks) {
            Collection<UUID> usedByIds = NickNamerAPI.getNickManager().getPlayersWithNick(used);
            final HashSet<String> usedByNames = new HashSet<String>();
            for (UUID uuid : usedByIds) {
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
                if (player != null) {
                    usedByNames.add(player.getName());
                    continue;
                }
                usedByNames.add(uuid.toString());
            }
            sender.sendMessage(CommandUtil.MESSAGE_LOADER.getMessage("name.list.format", "name.list.format", new MessageFormatter(){

                @Override
                public String format(String key, String message) {
                    return String.format(message, used, usedByNames.toString());
                }
            }));
        }
    }
}

