/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.nicknamer.api;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.inventivetalent.data.DataProvider;
import org.inventivetalent.data.async.DataCallback;
import org.inventivetalent.data.mapper.AsyncCacheMapper;
import org.inventivetalent.data.mapper.MapMapper;
import org.inventivetalent.mcwrapper.auth.GameProfileWrapper;
import org.inventivetalent.nicknamer.api.event.skin.SkinLoadedEvent;
import org.inventivetalent.nicknamer.reflection.resolver.ClassResolver;
import org.inventivetalent.nicknamer.reflection.resolver.FieldResolver;
import org.inventivetalent.nicknamer.reflection.resolver.MethodResolver;
import org.inventivetalent.nicknamer.reflection.resolver.minecraft.NMSClassResolver;

public class SkinLoader {
    static ClassResolver classResolver = new ClassResolver();
    static NMSClassResolver nmsClassResolver = new NMSClassResolver();
    static Class<?> TileEntitySkull = nmsClassResolver.resolveSilent("TileEntitySkull");
    static Class<?> Cache = classResolver.resolveSilent("net.minecraft.util.com.google.common.cache.Cache", "com.google.common.cache.Cache");
    static Class<?> LoadingCache = classResolver.resolveSilent("net.minecraft.util.com.google.common.cache.LoadingCache", "com.google.common.cache.LoadingCache");
    static Class<?> GameProfile = classResolver.resolveSilent("net.minecraft.util.com.mojang.authlib.GameProfile", "com.mojang.authlib.GameProfile");
    static Class<?> PropertyMap = classResolver.resolveSilent("net.minecraft.util.com.mojang.authlib.properties.PropertyMap", "com.mojang.authlib.properties.PropertyMap");
    static FieldResolver TileEntitySkullFieldResolver = new FieldResolver(TileEntitySkull);
    static FieldResolver GameProfileFieldResolver = new FieldResolver(GameProfile);
    static MethodResolver CacheMethodResolver = new MethodResolver(Cache);
    static MethodResolver LoadingCacheMethodResolver = new MethodResolver(LoadingCache);
    protected static DataProvider<JsonObject> skinDataProvider;

    public static void setSkinDataProvider(DataProvider<JsonObject> skinDataProvider) {
        SkinLoader.skinDataProvider = skinDataProvider;
    }

    static Object jsonToProfile(JsonObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        return new GameProfileWrapper(jsonObject).getHandle();
    }

    static JsonObject profileToJson(Object profile) {
        if (profile == null) {
            return null;
        }
        JsonObject jsonObject = new GameProfileWrapper(profile).toJson();
        return jsonObject;
    }

    @Nullable
    public static GameProfileWrapper loadSkin(@Nonnull String owner) {
        Object handle = SkinLoader.loadSkinHandle(owner);
        if (handle == null) {
            return null;
        }
        return new GameProfileWrapper(handle);
    }

    @Nullable
    public static GameProfileWrapper getSkinProfile(@Nonnull String owner) {
        Object handle = SkinLoader.getSkinProfileHandle(owner);
        if (handle == null) {
            return null;
        }
        return new GameProfileWrapper(handle);
    }

    @Nullable
    public static Object loadSkinHandle(@Nonnull String owner) {
        Object profile = SkinLoader.getSkinProfileHandle(owner);
        if (profile == null && skinDataProvider instanceof AsyncCacheMapper.CachedDataProvider) {
            final CountDownLatch latch = new CountDownLatch(1);
            final Object[] profile1 = new Object[1];
            ((AsyncCacheMapper.CachedDataProvider)skinDataProvider).get(owner, new DataCallback<JsonObject>(){

                @Override
                public void provide(@Nullable JsonObject jsonObject) {
                    profile1[0] = SkinLoader.jsonToProfile(jsonObject);
                    latch.countDown();
                }
            });
            try {
                latch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (profile1[0] != null) {
                return profile1[0];
            }
        }
        if (profile == null) {
            try {
                Object cache = TileEntitySkullFieldResolver.resolve("skinCache").get(null);
                profile = LoadingCacheMethodResolver.resolve("getUnchecked").invoke(cache, owner.toLowerCase());
                if (profile != null) {
                    skinDataProvider.put(owner, SkinLoader.profileToJson(profile));
                    Bukkit.getPluginManager().callEvent((Event)new SkinLoadedEvent(owner, new GameProfileWrapper(profile)));
                }
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        return profile;
    }

    @Nullable
    public static Object getSkinProfileHandle(@Nonnull String owner) {
        Object profile = SkinLoader.jsonToProfile(skinDataProvider.get(owner));
        if (profile == null) {
            try {
                Object cache = TileEntitySkullFieldResolver.resolve("skinCache").get(null);
                profile = CacheMethodResolver.resolve("getIfPresent").invoke(cache, owner);
                if (profile != null) {
                    skinDataProvider.put(owner, SkinLoader.profileToJson(profile));
                    Bukkit.getPluginManager().callEvent((Event)new SkinLoadedEvent(owner, new GameProfileWrapper(profile)));
                }
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        return profile;
    }

    static {
        SkinLoader.setSkinDataProvider(MapMapper.sync(new HashMap()));
    }
}

