/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.nicknamer.api;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.inventivetalent.mcwrapper.auth.GameProfileWrapper;
import org.inventivetalent.nicknamer.api.ClassBuilder;
import org.inventivetalent.nicknamer.api.NickManager;
import org.inventivetalent.nicknamer.api.NickNamerAPI;
import org.inventivetalent.nicknamer.api.SkinLoader;
import org.inventivetalent.nicknamer.api.event.NickNamerSelfUpdateEvent;
import org.inventivetalent.nicknamer.api.event.refresh.PlayerRefreshEvent;
import org.json.simple.JSONObject;

public class SimpleNickManager
implements NickManager {
    Class EnumDifficulty = SkinLoader.nmsClassResolver.resolveSilent("EnumDifficulty");
    Class WorldType = SkinLoader.nmsClassResolver.resolveSilent("WorldType");
    Class EnumGamemode = SkinLoader.nmsClassResolver.resolveSilent("WorldSettings$EnumGamemode", "EnumGamemode");
    protected Plugin plugin;

    public SimpleNickManager(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void refreshPlayer(@Nonnull UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return;
        }
        this.refreshPlayer(player);
    }

    @Override
    public void refreshPlayer(final @Nonnull Player player) {
        if (!player.isOnline()) {
            return;
        }
        PlayerRefreshEvent refreshEvent = new PlayerRefreshEvent(player, true);
        Bukkit.getPluginManager().callEvent((Event)refreshEvent);
        if (refreshEvent.isCancelled()) {
            return;
        }
        if (refreshEvent.isSelf()) {
            this.updateSelf(player);
        }
        Bukkit.getScheduler().runTask(this.plugin, new Runnable(){

            @Override
            public void run() {
                ArrayList<Player> canSee = new ArrayList<Player>();
                for (Player player1 : Bukkit.getOnlinePlayers()) {
                    if (!player1.canSee(player)) continue;
                    canSee.add(player1);
                    player1.hidePlayer(player);
                }
                for (Player player1 : canSee) {
                    player1.showPlayer(player);
                }
            }
        });
    }

    protected void updateSelf(final Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        Object profile = ClassBuilder.getGameProfile(player);
        NickNamerSelfUpdateEvent event = new NickNamerSelfUpdateEvent(player, this.isNicked(player.getUniqueId()) ? this.getNick(player.getUniqueId()) : player.getPlayerListName(), profile, player.getWorld().getDifficulty(), player.getGameMode());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        try {
            Object removePlayer = ClassBuilder.buildPlayerInfoPacket(4, event.getGameProfile(), 0, event.getGameMode().ordinal(), event.getName());
            final Object addPlayer = ClassBuilder.buildPlayerInfoPacket(0, event.getGameProfile(), 0, event.getGameMode().ordinal(), event.getName());
            Object difficulty = this.EnumDifficulty.getDeclaredMethod("getById", Integer.TYPE).invoke(null, event.getDifficulty().getValue());
            Object type = ((Object[])this.WorldType.getDeclaredField("types").get(null))[0];
            Object gamemode = this.EnumGamemode.getDeclaredMethod("getById", Integer.TYPE).invoke(null, event.getGameMode().getValue());
            final Object respawnPlayer = SkinLoader.nmsClassResolver.resolve("PacketPlayOutRespawn").getConstructor(Integer.TYPE, this.EnumDifficulty, this.WorldType, this.EnumGamemode).newInstance(0, difficulty, type, gamemode);
            NickNamerAPI.packetListener.sendPacket(player, removePlayer);
            Bukkit.getScheduler().runTaskLater(this.plugin, new Runnable(){

                @Override
                public void run() {
                    boolean flying = player.isFlying();
                    Location location = player.getLocation();
                    int level = player.getLevel();
                    float xp = player.getExp();
                    double maxHealth = player.getMaxHealth();
                    double health = player.getHealth();
                    NickNamerAPI.packetListener.sendPacket(player, respawnPlayer);
                    player.setFlying(flying);
                    player.teleport(location);
                    player.updateInventory();
                    player.setLevel(level);
                    player.setExp(xp);
                    player.setMaxHealth(maxHealth);
                    player.setHealth(health);
                    NickNamerAPI.packetListener.sendPacket(player, addPlayer);
                }
            }, 1L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @Deprecated
    public void updatePlayer(Player player, boolean updateName, boolean updateSkin, boolean updateSelf) {
        this.refreshPlayer(player.getUniqueId());
    }

    @Override
    @Deprecated
    public void updatePlayer(UUID uuid, boolean updateName, boolean updateSkin, boolean updateSelf) {
        this.refreshPlayer(uuid);
    }

    @Override
    public boolean isNicked(@Nonnull UUID uuid) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNickUsed(@Nonnull String nick) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNick(@Nonnull UUID id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNick(@Nonnull UUID uuid, @Nonnull String nick) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeNick(@Nonnull UUID uuid) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public List<UUID> getPlayersWithNick(@Nonnull String nick) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public List<String> getUsedNicks() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSkin(@Nonnull UUID uuid, @Nonnull String skinOwner) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadCustomSkin(@Nonnull String key, @Nonnull Object gameProfile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadCustomSkin(@Nonnull String key, @Nonnull GameProfileWrapper profileWrapper) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadCustomSkin(@Nonnull String key, @Nonnull JsonObject data) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void loadCustomSkin(String key, JSONObject data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCustomSkin(@Nonnull UUID uuid, @Nonnull String skin) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeSkin(@Nonnull UUID uuid) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSkin(@Nonnull UUID uuid) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasSkin(@Nonnull UUID uuid) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public List<UUID> getPlayersWithSkin(@Nonnull String skin) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<String> getUsedSkins() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSimple() {
        return true;
    }
}

