/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.nicknamer.api;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.inventivetalent.data.DataProvider;
import org.inventivetalent.data.async.DataCallable;
import org.inventivetalent.data.async.DataCallback;
import org.inventivetalent.data.mapper.AsyncCacheMapper;
import org.inventivetalent.data.mapper.MapMapper;
import org.inventivetalent.mcwrapper.auth.GameProfileWrapper;
import org.inventivetalent.nicknamer.NickNamerPlugin;
import org.inventivetalent.nicknamer.api.NickNamerAPI;
import org.inventivetalent.nicknamer.api.SimpleNickManager;
import org.inventivetalent.nicknamer.api.SkinLoader;
import org.json.simple.JSONObject;

public class PluginNickManager
extends SimpleNickManager {
    DataProvider<String> nickDataProvider = MapMapper.sync(new HashMap());
    DataProvider<String> skinDataProvider = MapMapper.sync(new HashMap());

    public void setNickDataProvider(DataProvider<String> provider) {
        this.nickDataProvider = provider;
    }

    public void setSkinDataProvider(DataProvider<String> provider) {
        this.skinDataProvider = provider;
    }

    public PluginNickManager(NickNamerPlugin plugin) {
        super((Plugin)plugin);
        NickNamerAPI.nickManager = this;
    }

    @Override
    public boolean isNicked(@Nonnull UUID uuid) {
        return this.nickDataProvider.contains(uuid.toString());
    }

    public void isNicked(@Nonnull UUID uuid, @Nonnull DataCallback<Boolean> callback) {
        if (this.nickDataProvider instanceof AsyncCacheMapper.CachedDataProvider) {
            ((AsyncCacheMapper.CachedDataProvider)this.nickDataProvider).contains(uuid.toString(), callback);
        } else {
            callback.provide(false);
        }
    }

    @Override
    public boolean isNickUsed(@Nonnull String nick) {
        for (String uuid : this.nickDataProvider.keys()) {
            if (!nick.equals(this.nickDataProvider.get(uuid))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getNick(@Nonnull UUID id) {
        return this.nickDataProvider.get(id.toString());
    }

    public void getNick(@Nonnull UUID uuid, DataCallback<String> callback) {
        if (this.nickDataProvider instanceof AsyncCacheMapper.CachedDataProvider) {
            ((AsyncCacheMapper.CachedDataProvider)this.nickDataProvider).get(uuid.toString(), callback);
        } else {
            callback.provide(null);
        }
    }

    @Override
    public void setNick(final @Nonnull UUID uuid, final @Nonnull String nick) {
        if (nick.length() > 16) {
            throw new IllegalArgumentException("Name is too long (" + nick.length() + " > 16)");
        }
        if (this.nickDataProvider instanceof AsyncCacheMapper.CachedDataProvider) {
            ((AsyncCacheMapper.CachedDataProvider)this.nickDataProvider).put(uuid.toString(), new DataCallable<String>(){

                @Override
                @Nonnull
                public String provide() {
                    Bukkit.getScheduler().runTaskLater(PluginNickManager.this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            PluginNickManager.this.refreshPlayer(uuid);
                        }
                    }, 20L);
                    return nick;
                }
            });
        } else {
            this.nickDataProvider.put(uuid.toString(), nick);
        }
    }

    @Override
    public void removeNick(final @Nonnull UUID uuid) {
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, new Runnable(){

            @Override
            public void run() {
                PluginNickManager.this.nickDataProvider.remove(uuid.toString());
                Bukkit.getScheduler().runTaskLater(PluginNickManager.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        PluginNickManager.this.refreshPlayer(uuid);
                    }
                }, 10L);
            }
        });
        if (((NickNamerPlugin)this.plugin).bungeecord) {
            ((NickNamerPlugin)this.plugin).sendPluginMessage(Bukkit.getPlayer((UUID)uuid), "name", "reset");
        }
    }

    @Override
    @Nonnull
    public List<UUID> getPlayersWithNick(@Nonnull String nick) {
        ArrayList<UUID> list = new ArrayList<UUID>();
        for (String uuid : this.nickDataProvider.keys()) {
            if (!nick.equals(this.nickDataProvider.get(uuid))) continue;
            list.add(UUID.fromString(uuid));
        }
        return list;
    }

    @Override
    @Nonnull
    public List<String> getUsedNicks() {
        ArrayList<String> nicks = new ArrayList<String>();
        for (String uuid : this.nickDataProvider.keys()) {
            String nick = this.nickDataProvider.get(uuid);
            if (nick == null) continue;
            nicks.add(nick);
        }
        return nicks;
    }

    @Override
    public void setSkin(final @Nonnull UUID uuid, final @Nonnull String skinOwner) {
        if (this.skinDataProvider instanceof AsyncCacheMapper.CachedDataProvider) {
            ((AsyncCacheMapper.CachedDataProvider)this.skinDataProvider).put(uuid.toString(), new DataCallable<String>(){

                @Override
                @Nonnull
                public String provide() {
                    SkinLoader.loadSkin(skinOwner);
                    Bukkit.getScheduler().runTaskLater(PluginNickManager.this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            PluginNickManager.this.refreshPlayer(uuid);
                        }
                    }, 20L);
                    return skinOwner;
                }
            });
        } else {
            this.skinDataProvider.put(uuid.toString(), skinOwner);
        }
        if (((NickNamerPlugin)this.plugin).bungeecord) {
            ((NickNamerPlugin)this.plugin).sendPluginMessage(Bukkit.getPlayer((UUID)uuid), "skin", skinOwner);
        }
    }

    @Override
    public void loadCustomSkin(@Nonnull String key, @Nonnull Object gameProfile) {
        this.loadCustomSkin(key, new GameProfileWrapper(gameProfile));
    }

    @Override
    public void loadCustomSkin(@Nonnull String key, @Nonnull GameProfileWrapper profileWrapper) {
        SkinLoader.skinDataProvider.put(key, profileWrapper.toJson());
    }

    @Override
    public void loadCustomSkin(@Nonnull String key, @Nonnull JsonObject data) {
        if (!data.has("properties")) {
            throw new IllegalArgumentException("JsonObject must contain 'properties' entry");
        }
        this.loadCustomSkin(key, new GameProfileWrapper(data));
    }

    @Override
    @Deprecated
    public void loadCustomSkin(String key, JSONObject data) {
        if (key == null || data == null) {
            throw new IllegalArgumentException("key and data cannot be null");
        }
        if (!data.containsKey((Object)"properties")) {
            throw new IllegalArgumentException("JSONObject must contain 'properties' entry");
        }
        this.loadCustomSkin(key, new GameProfileWrapper(data));
    }

    @Override
    public void setCustomSkin(@Nonnull UUID uuid, @Nonnull String skin) {
        if (!SkinLoader.skinDataProvider.contains(skin)) {
            throw new IllegalStateException("Specified skin has not been loaded yet");
        }
        this.skinDataProvider.put(uuid.toString(), skin);
        this.refreshPlayer(uuid);
    }

    @Override
    public void removeSkin(final @Nonnull UUID uuid) {
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, new Runnable(){

            @Override
            public void run() {
                PluginNickManager.this.skinDataProvider.remove(uuid.toString());
                Bukkit.getScheduler().runTaskLater(PluginNickManager.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        PluginNickManager.this.refreshPlayer(uuid);
                    }
                }, 10L);
            }
        });
        if (((NickNamerPlugin)this.plugin).bungeecord) {
            ((NickNamerPlugin)this.plugin).sendPluginMessage(Bukkit.getPlayer((UUID)uuid), "skin", "reset");
        }
    }

    @Override
    public String getSkin(@Nonnull UUID uuid) {
        return this.skinDataProvider.get(uuid.toString());
    }

    public void getSkin(@Nonnull UUID uuid, DataCallback<String> callback) {
        if (this.skinDataProvider instanceof AsyncCacheMapper.CachedDataProvider) {
            ((AsyncCacheMapper.CachedDataProvider)this.skinDataProvider).get(uuid.toString(), callback);
        } else {
            callback.provide(null);
        }
    }

    @Override
    public boolean hasSkin(@Nonnull UUID uuid) {
        return this.skinDataProvider.contains(uuid.toString());
    }

    public void hasSkin(@Nonnull UUID uuid, DataCallback<Boolean> callback) {
        if (this.skinDataProvider instanceof AsyncCacheMapper.CachedDataProvider) {
            ((AsyncCacheMapper.CachedDataProvider)this.skinDataProvider).contains(uuid.toString(), callback);
        } else {
            callback.provide(false);
        }
    }

    @Override
    @Nonnull
    public List<UUID> getPlayersWithSkin(@Nonnull String skin) {
        ArrayList<UUID> list = new ArrayList<UUID>();
        for (String uuid : this.skinDataProvider.keys()) {
            if (!skin.equals(this.skinDataProvider.get(uuid))) continue;
            list.add(UUID.fromString(uuid));
        }
        return list;
    }

    @NonNull
    public List<String> getUsedSkins() {
        ArrayList<String> skins = new ArrayList<String>();
        for (String uuid : this.skinDataProvider.keys()) {
            String nick = this.skinDataProvider.get(uuid);
            if (nick == null) continue;
            skins.add(nick);
        }
        return skins;
    }

    @Override
    @Deprecated
    public void updatePlayer(Player player, boolean updateName, boolean updateSkin, boolean updateSelf) {
        this.refreshPlayer(player.getUniqueId());
    }

    @Override
    @Deprecated
    public void updatePlayer(UUID uuid, boolean updateName, boolean updateSkin, boolean updateSelf) {
        this.refreshPlayer(uuid);
    }

    @Override
    public boolean isSimple() {
        return false;
    }
}

