/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.nicknamer.api;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.inventivetalent.mcwrapper.auth.GameProfileWrapper;
import org.inventivetalent.mcwrapper.auth.properties.PropertyMapWrapper;
import org.inventivetalent.nicknamer.api.NickNamerAPI;
import org.inventivetalent.nicknamer.api.SkinLoader;
import org.inventivetalent.nicknamer.api.event.NickNamerUpdateEvent;
import org.inventivetalent.nicknamer.api.event.disguise.NickDisguiseEvent;
import org.inventivetalent.nicknamer.api.event.disguise.SkinDisguiseEvent;
import org.inventivetalent.nicknamer.api.event.replace.ChatInReplacementEvent;
import org.inventivetalent.nicknamer.api.event.replace.ChatOutReplacementEvent;
import org.inventivetalent.nicknamer.api.event.replace.NameReplacer;
import org.inventivetalent.nicknamer.api.event.replace.ScoreboardReplacementEvent;
import org.inventivetalent.nicknamer.api.event.replace.ScoreboardScoreReplacementEvent;
import org.inventivetalent.nicknamer.api.event.replace.ScoreboardTeamReplacementEvent;
import org.inventivetalent.nicknamer.reflection.minecraft.Minecraft;
import org.inventivetalent.nicknamer.reflection.resolver.FieldResolver;
import org.inventivetalent.nicknamer.reflection.resolver.MethodResolver;
import org.inventivetalent.nicknamer.reflection.resolver.ResolverQuery;
import org.inventivetalent.nicknamer.reflection.resolver.minecraft.NMSClassResolver;
import org.inventivetalent.nicknamer.reflection.resolver.minecraft.OBCClassResolver;
import org.inventivetalent.packetlistener.handler.PacketHandler;
import org.inventivetalent.packetlistener.handler.PacketOptions;
import org.inventivetalent.packetlistener.handler.ReceivedPacket;
import org.inventivetalent.packetlistener.handler.SentPacket;

public class PacketListener
extends PacketHandler {
    static NMSClassResolver nmsClassResolver = new NMSClassResolver();
    static OBCClassResolver obcClassResolver = new OBCClassResolver();
    static Class<?> PlayerInfoData = nmsClassResolver.resolveSilent("PlayerInfoData", "PacketPlayOutPlayerInfo$PlayerInfoData");
    static Class<?> IChatBaseComponent = nmsClassResolver.resolveSilent("IChatBaseComponent");
    static Class<?> PacketPlayInChat = nmsClassResolver.resolveSilent("PacketPlayInChat");
    static Class<?> ChatSerializer = nmsClassResolver.resolveSilent("ChatSerializer", "IChatBaseComponent$ChatSerializer");
    static FieldResolver PlayerInfoDataFieldResolver = PlayerInfoData != null ? new FieldResolver(PlayerInfoData) : null;
    static FieldResolver PacketPlayInChatFieldResolver = new FieldResolver(PacketPlayInChat);
    static MethodResolver ChatSerializerMethodResolver = new MethodResolver(ChatSerializer);

    public PacketListener(Plugin plugin) {
        super(plugin);
    }

    @PacketOptions(forcePlayer=true)
    public void onSend(final SentPacket packet) {
        if (packet.hasPlayer()) {
            Object profileHandle;
            if ("PacketPlayOutNamedEntitySpawn".equals(packet.getPacketName()) && Minecraft.VERSION.olderThan(Minecraft.Version.v1_8_R1)) {
                try {
                    profileHandle = packet.getPacketValue("b");
                    if (profileHandle != null) {
                        packet.setPacketValue("b", this.disguiseProfile(packet.getPlayer(), new GameProfileWrapper(profileHandle)).getHandle());
                    }
                }
                catch (Exception e) {
                    this.getPlugin().getLogger().log(Level.SEVERE, "Failed to disguise profile", e);
                }
            }
            if ("PacketPlayOutPlayerInfo".equals(packet.getPacketName())) {
                if (Minecraft.VERSION.olderThan(Minecraft.Version.v1_8_R1) && (Integer)packet.getPacketValue("action") == 4) {
                    return;
                }
                try {
                    profileHandle = packet.getPacketValue(Minecraft.VERSION.olderThan(Minecraft.Version.v1_8_R1) ? "player" : "b");
                    if (Minecraft.VERSION.olderThan(Minecraft.Version.v1_8_R1)) {
                        if (profileHandle != null) {
                            GameProfileWrapper disguisedWrapper = this.disguiseProfile(packet.getPlayer(), new GameProfileWrapper(profileHandle));
                            profileHandle = disguisedWrapper.getHandle();
                            packet.setPacketValue("player", profileHandle);
                            packet.setPacketValue("username", (Object)disguisedWrapper.getName());
                        }
                    } else {
                        ArrayList list = new ArrayList((List)profileHandle);
                        for (Object object : list) {
                            Field field = PlayerInfoDataFieldResolver.resolve("d");
                            field.set(object, this.disguiseProfile(packet.getPlayer(), new GameProfileWrapper(field.get(object))).getHandle());
                        }
                    }
                }
                catch (Exception e) {
                    this.getPlugin().getLogger().log(Level.SEVERE, "Failed to disguise profile", e);
                }
            }
            if (!NickNamerAPI.getNickManager().isSimple()) {
                Object a;
                if ("PacketPlayOutChat".equalsIgnoreCase(packet.getPacketName()) && ChatOutReplacementEvent.getHandlerList().getRegisteredListeners().length > 0) {
                    a = packet.getPacketValue("a");
                    try {
                        final String message = this.serializeChat(a);
                        String replacedMessage = NickNamerAPI.replaceNames(message, NickNamerAPI.getNickedPlayerNames(), new NameReplacer(){

                            @Override
                            public String replace(String original) {
                                Player player = Bukkit.getPlayer((String)original);
                                if (player != null) {
                                    ChatOutReplacementEvent replacementEvent = new ChatOutReplacementEvent(player, packet.getPlayer(), message, original, original);
                                    Bukkit.getPluginManager().callEvent((Event)replacementEvent);
                                    if (replacementEvent.isCancelled()) {
                                        return original;
                                    }
                                    return replacementEvent.getReplacement();
                                }
                                return original;
                            }
                        }, true);
                        packet.setPacketValue("a", this.deserializeChat(replacedMessage));
                    }
                    catch (Exception e) {
                        this.getPlugin().getLogger().log(Level.SEVERE, "", e);
                    }
                }
                if ("PacketPlayOutScoreboardObjective".equals(packet.getPacketName()) && ScoreboardReplacementEvent.getHandlerList().getRegisteredListeners().length > 0) {
                    final String b = (String)packet.getPacketValue("b");
                    String replacedB = NickNamerAPI.replaceNames(b, NickNamerAPI.getNickedPlayerNames(), new NameReplacer(){

                        @Override
                        public String replace(String original) {
                            Player player = Bukkit.getPlayer((String)original);
                            if (player != null) {
                                ScoreboardReplacementEvent replacementEvent = new ScoreboardReplacementEvent(player, packet.getPlayer(), b, original, original);
                                Bukkit.getPluginManager().callEvent((Event)replacementEvent);
                                if (replacementEvent.isCancelled()) {
                                    return original;
                                }
                                return replacementEvent.getReplacement();
                            }
                            return original;
                        }
                    }, true);
                    packet.setPacketValue("b", (Object)replacedB);
                }
                if ("PacketPlayOutScoreboardScore".equals(packet.getPacketName()) && ScoreboardScoreReplacementEvent.getHandlerList().getRegisteredListeners().length > 0) {
                    a = (String)packet.getPacketValue("a");
                    String replacedA = NickNamerAPI.replaceNames((String)a, NickNamerAPI.getNickedPlayerNames(), new NameReplacer((String)a){
                        final /* synthetic */ String val$a;
                        {
                            this.val$a = string;
                        }

                        @Override
                        public String replace(String original) {
                            Player player = Bukkit.getPlayer((String)original);
                            if (player != null) {
                                ScoreboardScoreReplacementEvent replacementEvent = new ScoreboardScoreReplacementEvent(player, packet.getPlayer(), this.val$a, original, original);
                                Bukkit.getPluginManager().callEvent((Event)replacementEvent);
                                if (replacementEvent.isCancelled()) {
                                    return original;
                                }
                                return replacementEvent.getReplacement();
                            }
                            return original;
                        }
                    }, true);
                    packet.setPacketValue("a", (Object)replacedA);
                }
                if ("PacketPlayOutScoreboardTeam".equals(packet.getPacketName()) && ScoreboardTeamReplacementEvent.getHandlerList().getRegisteredListeners().length > 0) {
                    List h = (List)(Minecraft.VERSION.olderThan(Minecraft.Version.v1_8_R1) ? packet.getPacketValue("e") : (Minecraft.VERSION.olderThan(Minecraft.Version.v1_9_R1) ? packet.getPacketValue("g") : packet.getPacketValue("h")));
                    ListIterator<String> iterator = h.listIterator();
                    while (iterator.hasNext()) {
                        final String entry = (String)iterator.next();
                        String replacedEntry = NickNamerAPI.replaceNames(entry, NickNamerAPI.getNickedPlayerNames(), new NameReplacer(){

                            @Override
                            public String replace(String original) {
                                Player player = Bukkit.getPlayer((String)original);
                                if (player != null) {
                                    ScoreboardTeamReplacementEvent replacementEvent = new ScoreboardTeamReplacementEvent(player, packet.getPlayer(), entry, original, original);
                                    Bukkit.getPluginManager().callEvent((Event)replacementEvent);
                                    if (replacementEvent.isCancelled()) {
                                        return original;
                                    }
                                    return replacementEvent.getReplacement();
                                }
                                return original;
                            }
                        }, true);
                        iterator.set(replacedEntry);
                    }
                }
            }
        }
    }

    @PacketOptions(forcePlayer=true)
    public void onReceive(final ReceivedPacket packet) {
        if (!NickNamerAPI.getNickManager().isSimple() && packet.hasPlayer() && "PacketPlayInChat".equals(packet.getPacketName()) && ChatInReplacementEvent.getHandlerList().getRegisteredListeners().length > 0) {
            try {
                final String message = (String)PacketPlayInChatFieldResolver.resolve("message", "a").get(packet.getPacket());
                String replacedMessage = NickNamerAPI.replaceNames(message, NickNamerAPI.getNickedPlayerNames(), new NameReplacer(){

                    @Override
                    public String replace(String original) {
                        Player player = Bukkit.getPlayer((String)original);
                        if (player != null) {
                            ChatInReplacementEvent replacementEvent = new ChatInReplacementEvent(player, packet.getPlayer(), message, original, original);
                            Bukkit.getPluginManager().callEvent((Event)replacementEvent);
                            if (replacementEvent.isCancelled()) {
                                return original;
                            }
                            return replacementEvent.getReplacement();
                        }
                        return original;
                    }
                }, true);
                PacketPlayInChatFieldResolver.resolve("message", "a").set(packet.getPacket(), replacedMessage);
            }
            catch (Exception e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "", e);
            }
        }
    }

    private GameProfileWrapper disguiseProfile(Player observer, GameProfileWrapper profileWrapper) throws Exception {
        GameProfileWrapper skinProfile;
        String skin;
        UUID id = profileWrapper.getId();
        String name = profileWrapper.getName();
        OfflinePlayer toDisguise = Bukkit.getOfflinePlayer((UUID)id);
        if (toDisguise == null) {
            return profileWrapper;
        }
        NickDisguiseEvent nickDisguiseEvent = new NickDisguiseEvent(toDisguise, observer, profileWrapper, name);
        SkinDisguiseEvent skinDisguiseEvent = new SkinDisguiseEvent(toDisguise, observer, profileWrapper, name);
        Bukkit.getPluginManager().callEvent((Event)nickDisguiseEvent);
        Bukkit.getPluginManager().callEvent((Event)skinDisguiseEvent);
        if (!nickDisguiseEvent.isDisguised() && !skinDisguiseEvent.isDisguised()) {
            return profileWrapper;
        }
        String nick = nickDisguiseEvent.isDisguised() ? nickDisguiseEvent.getNick() : name;
        String string = skin = skinDisguiseEvent.isDisguised() ? skinDisguiseEvent.getSkin() : name;
        if (nick == null) {
            nick = name;
        }
        NickNamerUpdateEvent event = new NickNamerUpdateEvent(toDisguise, observer, nick, skin);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return profileWrapper;
        }
        if (event.getNick() != null) {
            nick = event.getNick();
        }
        if (event.getSkin() != null) {
            skin = event.getSkin();
        }
        GameProfileWrapper profileClone = new GameProfileWrapper(id, name);
        GameProfileWrapper gameProfileWrapper = skinProfile = skin != null ? SkinLoader.getSkinProfile(skin) : null;
        if (skinProfile != null) {
            PropertyMapWrapper clonedSkinProperties = profileClone.getProperties();
            clonedSkinProperties.clear();
            clonedSkinProperties.putAll(skinProfile.getProperties());
        }
        profileClone.setName(nick);
        return profileClone;
    }

    String serializeChat(Object chatComponent) {
        if (chatComponent == null) {
            return null;
        }
        try {
            return (String)ChatSerializerMethodResolver.resolve(new ResolverQuery("a", IChatBaseComponent)).invoke(null, chatComponent);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    Object deserializeChat(String serialized) {
        if (serialized == null) {
            return null;
        }
        try {
            return ChatSerializerMethodResolver.resolve(new ResolverQuery("a", String.class)).invoke(null, serialized);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

