/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.nicknamer.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.inventivetalent.apihelper.API;
import org.inventivetalent.apihelper.APIManager;
import org.inventivetalent.nicknamer.api.NickManager;
import org.inventivetalent.nicknamer.api.PacketListener;
import org.inventivetalent.nicknamer.api.SimpleNickManager;
import org.inventivetalent.nicknamer.api.event.random.RandomNickRequestEvent;
import org.inventivetalent.nicknamer.api.event.random.RandomSkinRequestEvent;
import org.inventivetalent.nicknamer.api.event.replace.NameReplacer;
import org.inventivetalent.packetlistener.PacketListenerAPI;
import org.inventivetalent.packetlistener.handler.PacketHandler;

public class NickNamerAPI
implements API,
Listener {
    static final Random random = new Random();
    protected static NickManager nickManager;
    protected static PacketListener packetListener;

    public static NickManager getNickManager() {
        return nickManager;
    }

    public static String replaceNames(@Nonnull String original, @Nonnull Iterable<String> namesToReplace, @Nonnull NameReplacer replacer, boolean ignoreCase) {
        if (original == null) {
            return null;
        }
        if (namesToReplace == null) {
            return original;
        }
        if (replacer == null) {
            return original;
        }
        String replaced = original;
        for (String name : namesToReplace) {
            Pattern pattern = Pattern.compile((ignoreCase ? "(?i)" : "") + name);
            Matcher matcher = pattern.matcher(replaced);
            StringBuffer replacementBuffer = new StringBuffer();
            while (matcher.find()) {
                String replace = replacer.replace(name);
                matcher.appendReplacement(replacementBuffer, replace);
            }
            matcher.appendTail(replacementBuffer);
            replaced = replacementBuffer.toString();
        }
        return replaced;
    }

    public static Set<String> getNickedPlayerNames() {
        HashSet<String> nickedPlayerNames = new HashSet<String>();
        if (NickNamerAPI.getNickManager().isSimple()) {
            return nickedPlayerNames;
        }
        for (String nick : NickNamerAPI.getNickManager().getUsedNicks()) {
            for (UUID uuid : NickNamerAPI.getNickManager().getPlayersWithNick(nick)) {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                if (offlinePlayer == null) continue;
                nickedPlayerNames.add(offlinePlayer.getName());
            }
        }
        return nickedPlayerNames;
    }

    public static String getRandomNick(Collection<String> nicks) {
        RandomNickRequestEvent event = new RandomNickRequestEvent(new ArrayList<String>(nicks));
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.getPossibilities().isEmpty()) {
            return "";
        }
        return (String)((List)event.getPossibilities()).get(random.nextInt(event.getPossibilities().size()));
    }

    public static String getRandomSkin(Collection<String> skins) {
        RandomSkinRequestEvent event = new RandomSkinRequestEvent(new ArrayList<String>(skins));
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.getPossibilities().isEmpty()) {
            return "";
        }
        return (String)((List)event.getPossibilities()).get(random.nextInt(event.getPossibilities().size()));
    }

    @Override
    public void load() {
        APIManager.require(PacketListenerAPI.class, null);
    }

    @Override
    public void init(Plugin plugin) {
        APIManager.initAPI(PacketListenerAPI.class);
        APIManager.registerEvents(this, this);
        nickManager = new SimpleNickManager(plugin);
        packetListener = new PacketListener(plugin);
        PacketHandler.addHandler((PacketHandler)packetListener);
    }

    @Override
    public void disable(Plugin plugin) {
        PacketHandler.removeHandler((PacketHandler)packetListener);
        APIManager.disableAPI(PacketListenerAPI.class);
    }
}

