/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.nicknamer.api;

import java.util.List;
import org.bukkit.entity.Player;
import org.inventivetalent.nicknamer.reflection.minecraft.Minecraft;
import org.inventivetalent.nicknamer.reflection.resolver.FieldResolver;
import org.inventivetalent.nicknamer.reflection.resolver.MethodResolver;
import org.inventivetalent.nicknamer.reflection.resolver.ResolverQuery;
import org.inventivetalent.nicknamer.reflection.resolver.minecraft.NMSClassResolver;
import org.inventivetalent.nicknamer.reflection.resolver.minecraft.OBCClassResolver;

public class ClassBuilder {
    static NMSClassResolver nmsClassResolver = new NMSClassResolver();
    static OBCClassResolver obcClassResolver = new OBCClassResolver();
    static Class<?> PacketPlayOutPlayerInfo = nmsClassResolver.resolveSilent("PacketPlayOutPlayerInfo");
    static Class<?> PlayerInfoData = nmsClassResolver.resolveSilent("PlayerInfoData", "PacketPlayOutPlayerInfo$PlayerInfoData");
    static Class<?> EnumPlayerInfoAction = nmsClassResolver.resolveSilent("EnumPlayerInfoAction", "PacketPlayOutPlayerInfo$EnumPlayerInfoAction");
    static Class<?> EnumGamemode = nmsClassResolver.resolveSilent("EnumGamemode", "WorldSettings$EnumGamemode");
    static Class<?> EntityHuman = nmsClassResolver.resolveSilent("EntityHuman");
    static Class<?> IChatBaseComponent = nmsClassResolver.resolveSilent("IChatBaseComponent");
    static Class<?> CraftChatMessage = obcClassResolver.resolveSilent("util.CraftChatMessage");
    static MethodResolver EntityHumanMethodResolver = new MethodResolver(EntityHuman);
    static MethodResolver CraftChatMessageMethodResolver = new MethodResolver(CraftChatMessage);
    static FieldResolver PacketPlayOutPlayerInfoFieldResolver = new FieldResolver(PacketPlayOutPlayerInfo);

    public static Object buildPlayerInfoPacket(int action, Object profile, int ping, int gamemodeOrdinal, String name) {
        try {
            Object packet = PacketPlayOutPlayerInfo.newInstance();
            if (Minecraft.VERSION.olderThan(Minecraft.Version.v1_8_R1)) {
                PacketPlayOutPlayerInfoFieldResolver.resolve("action").set(packet, action);
                PacketPlayOutPlayerInfoFieldResolver.resolve("player").set(packet, profile);
                PacketPlayOutPlayerInfoFieldResolver.resolve("gamemode").set(packet, gamemodeOrdinal);
                PacketPlayOutPlayerInfoFieldResolver.resolve("ping").set(packet, ping);
                PacketPlayOutPlayerInfoFieldResolver.resolve("username").set(packet, name);
            } else {
                PacketPlayOutPlayerInfoFieldResolver.resolve("a").set(packet, EnumPlayerInfoAction.getEnumConstants()[action]);
                List list = (List)PacketPlayOutPlayerInfoFieldResolver.resolve("b").get(packet);
                Object data = PlayerInfoData.getConstructor(PacketPlayOutPlayerInfo, ClassBuilder.getNMUtilClass("com.mojang.authlib.GameProfile"), Integer.TYPE, EnumGamemode, IChatBaseComponent).newInstance(packet, profile, ping, EnumGamemode.getEnumConstants()[gamemodeOrdinal], ClassBuilder.buildChatComponent(name));
                list.add(data);
            }
            return packet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object buildChatComponent(String string) {
        try {
            Object[] components = (Object[])CraftChatMessageMethodResolver.resolve(new ResolverQuery("fromString", String.class)).invoke(null, string);
            if (components.length > 0) {
                return components[0];
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static Object getGameProfile(Player player) {
        try {
            return EntityHumanMethodResolver.resolve("getProfile").invoke(Minecraft.getHandle(player), new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> getNMUtilClass(String name) throws ClassNotFoundException {
        if (Minecraft.VERSION.olderThan(Minecraft.Version.v1_8_R1)) {
            return Class.forName("net.minecraft.util." + name);
        }
        return Class.forName(name);
    }
}

