/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.data.redis;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.inventivetalent.data.async.AbstractAsyncDataProvider;
import org.inventivetalent.data.async.DataCallable;
import org.inventivetalent.data.async.DataCallback;
import redis.clients.jedis.Jedis;

public class RedisDataProvider
extends AbstractAsyncDataProvider<String> {
    private final Jedis jedis;
    private final String keyFormat;
    private final String keyPattern;

    public RedisDataProvider(Jedis jedis) {
        this.jedis = jedis;
        this.keyFormat = "data-api:%s";
        this.keyPattern = "data-api:(.)";
    }

    public RedisDataProvider(Executor executor, Jedis jedis) {
        super(executor);
        this.jedis = jedis;
        this.keyFormat = "data-api:%s";
        this.keyPattern = "data-api:(.)";
    }

    public RedisDataProvider(Jedis jedis, String keyFormat, String keyPattern) {
        this.jedis = jedis;
        this.keyFormat = keyFormat;
        this.keyPattern = keyPattern;
    }

    public RedisDataProvider(Executor executor, Jedis jedis, String keyFormat, String keyPattern) {
        super(executor);
        this.jedis = jedis;
        this.keyFormat = keyFormat;
        this.keyPattern = keyPattern;
    }

    protected String formatKey(String key) {
        return String.format(this.keyFormat, key);
    }

    protected String extractKey(String key) {
        return key.replaceAll(this.keyPattern, "$1");
    }

    @Override
    public void put(@Nonnull String key, @Nonnull String value) {
        this.execute(() -> this.jedis.set(this.formatKey(key), value));
    }

    @Override
    public void put(@Nonnull String key, @Nonnull DataCallable<String> valueCallable) {
        this.execute(() -> this.jedis.set(this.formatKey(key), (String)valueCallable.provide()));
    }

    @Override
    public void putAll(@Nonnull Map<String, String> map) {
        String[] keysValues = this.createKeysValues(map);
        this.execute(() -> this.jedis.mset(keysValues));
    }

    @Override
    public void putAll(@Nonnull DataCallable<Map<String, String>> mapCallable) {
        this.execute(() -> {
            Map map = (Map)mapCallable.provide();
            String[] keysValues = this.createKeysValues(map);
            this.jedis.mset(keysValues);
        });
    }

    String[] createKeysValues(Map<String, String> map) {
        String[] keysValues = new String[map.size() * 2];
        int i = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            keysValues[i++] = this.formatKey(entry.getKey());
            keysValues[i++] = entry.getValue();
        }
        return keysValues;
    }

    @Override
    public void get(@Nonnull String key, @Nonnull DataCallback<String> callback) {
        this.execute(() -> callback.provide(this.jedis.get(this.formatKey(key))));
    }

    @Override
    public void contains(@Nonnull String key, @Nonnull DataCallback<Boolean> callback) {
        this.execute(() -> callback.provide(this.jedis.exists(this.formatKey(key))));
    }

    @Override
    public void remove(@Nonnull String key, @Nonnull DataCallback<String> callback) {
        this.execute(() -> {
            String formattedKey = this.formatKey(key);
            String value = this.jedis.get(formattedKey);
            this.jedis.del(formattedKey);
            callback.provide(value);
        });
    }

    @Override
    public void remove(@Nonnull String key) {
        this.execute(() -> this.jedis.del(this.formatKey(key)));
    }

    @Override
    public void keys(@Nonnull DataCallback<Collection<String>> callback) {
        this.execute(() -> {
            Set rawKeys = this.jedis.keys(this.formatKey("*"));
            Set keys = rawKeys.stream().map(this::extractKey).collect(Collectors.toSet());
            callback.provide(keys);
        });
    }

    @Override
    public void entries(@Nonnull DataCallback<Map<String, String>> callback) {
        this.execute(() -> {
            Set rawKeys = this.jedis.keys(this.formatKey("*"));
            List<String> keys = rawKeys.stream().map(this::extractKey).collect(Collectors.toList());
            List values = this.jedis.mget(keys.toArray(new String[keys.size()]));
            HashMap map = new HashMap();
            for (int i = 0; i < keys.size(); ++i) {
                map.put(keys.get(i), values.get(i));
            }
            callback.provide(map);
        });
    }

    @Override
    public void size(@Nonnull DataCallback<Integer> callback) {
        this.execute(() -> {
            Set rawKeys = this.jedis.keys(this.formatKey("*"));
            callback.provide(rawKeys.size());
        });
    }
}

