/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.data.mongodb;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.UpdateOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.inventivetalent.data.async.AbstractAsyncDataProvider;
import org.inventivetalent.data.async.DataCallable;
import org.inventivetalent.data.async.DataCallback;
import org.inventivetalent.data.mongodb.DocumentParser;

public class MongoDbDataProvider
extends AbstractAsyncDataProvider<JsonObject> {
    private static final UpdateOptions UPSERT_OPTIONS = new UpdateOptions().upsert(true);
    private final MongoClient client;
    private final MongoCollection<Document> collection;
    private String keyField = "_id";

    public MongoDbDataProvider(MongoClient client, String database, String collection) {
        this.client = client;
        this.collection = this.client.getDatabase(database).getCollection(collection);
    }

    public MongoDbDataProvider(Executor executor, MongoClient client, String database, String collection) {
        super(executor);
        this.client = client;
        this.collection = this.client.getDatabase(database).getCollection(collection);
    }

    public MongoDbDataProvider(String host, int port, String user, char[] pass, String authDatabase, String database, String collection) {
        MongoCredential credential = user != null && pass != null && authDatabase != null ? MongoCredential.createScramSha1Credential((String)user, (String)authDatabase, (char[])pass) : null;
        this.client = credential != null ? new MongoClient(new ServerAddress(host, port), Collections.singletonList(credential)) : new MongoClient(new ServerAddress(host, port));
        this.collection = this.client.getDatabase(database).getCollection(collection);
    }

    public MongoDbDataProvider(Executor executor, String host, int port, String user, char[] pass, String authDatabase, String database, String collection) {
        super(executor);
        MongoCredential credential = user != null && pass != null && authDatabase != null ? MongoCredential.createScramSha1Credential((String)user, (String)authDatabase, (char[])pass) : null;
        this.client = credential != null ? new MongoClient(new ServerAddress(host, port), Collections.singletonList(credential)) : new MongoClient(new ServerAddress(host, port));
        this.collection = this.client.getDatabase(database).getCollection(collection);
    }

    public MongoDbDataProvider setKeyField(String keyField) {
        this.keyField = keyField;
        return this;
    }

    public MongoCollection<Document> getCollection() {
        return this.collection;
    }

    @Override
    public void put(@Nonnull String key, @Nonnull JsonObject value) {
        this.execute(() -> this.collection.updateOne((Bson)new Document(this.keyField, (Object)key).append(this.keyField, (Object)key), (Bson)new Document("$set", (Object)DocumentParser.toDocument(value)), UPSERT_OPTIONS));
    }

    @Override
    public void put(@Nonnull String key, @Nonnull DataCallable<JsonObject> valueCallable) {
        this.execute(() -> this.collection.updateOne((Bson)new Document(this.keyField, (Object)key).append(this.keyField, (Object)key), (Bson)new Document("$set", (Object)DocumentParser.toDocument((JsonElement)valueCallable.provide())), UPSERT_OPTIONS));
    }

    @Override
    public void putAll(@Nonnull Map<String, JsonObject> map) {
        List documents = map.entrySet().stream().map(entry -> DocumentParser.toDocument((JsonElement)entry.getValue()).append(this.keyField, entry.getKey())).collect(Collectors.toList());
        this.execute(() -> this.collection.insertMany(documents));
    }

    @Override
    public void putAll(@Nonnull DataCallable<Map<String, JsonObject>> mapCallable) {
        List documents = mapCallable.provide().entrySet().stream().map(entry -> DocumentParser.toDocument((JsonElement)entry.getValue()).append(this.keyField, entry.getKey())).collect(Collectors.toList());
        this.execute(() -> this.collection.insertMany(documents));
    }

    @Override
    public void get(@Nonnull String key, @Nonnull DataCallback<JsonObject> callback) {
        this.execute(() -> callback.provide(DocumentParser.toJson((Document)this.collection.find((Bson)new Document(this.keyField, (Object)key)).limit(1).first())));
    }

    @Override
    public void contains(@Nonnull String key, @Nonnull DataCallback<Boolean> callback) {
        this.execute(() -> callback.provide(this.collection.count((Bson)new Document(this.keyField, (Object)key)) > 0L));
    }

    @Override
    public void remove(@Nonnull String key, @Nonnull DataCallback<JsonObject> callback) {
        this.execute(() -> callback.provide(DocumentParser.toJson((Document)this.collection.findOneAndDelete((Bson)new Document(this.keyField, (Object)key)))));
    }

    @Override
    public void remove(@Nonnull String key) {
        this.execute(() -> this.collection.deleteOne((Bson)new Document(this.keyField, (Object)key)));
    }

    @Override
    public void keys(@Nonnull DataCallback<Collection<String>> callback) {
        this.entries((Map<String, JsonObject> stringJsonObjectMap) -> {
            assert (stringJsonObjectMap != null);
            callback.provide(stringJsonObjectMap.keySet());
        });
    }

    @Override
    public void entries(@Nonnull DataCallback<Map<String, JsonObject>> callback) {
        this.execute(() -> {
            HashMap<String, JsonObject> map = new HashMap<String, JsonObject>();
            for (Document doc : this.collection.find()) {
                map.put(doc.getString((Object)this.keyField), DocumentParser.toJson(doc));
            }
            callback.provide(map);
        });
    }

    @Override
    public void size(@Nonnull DataCallback<Integer> callback) {
        this.execute(() -> callback.provide((int)this.collection.count()));
    }
}

