/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.data.mapper;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.inventivetalent.data.async.AsyncDataProvider;
import org.inventivetalent.data.async.DataCallable;
import org.inventivetalent.data.async.DataCallback;
import org.inventivetalent.data.ebean.BeanProvider;
import org.inventivetalent.data.ebean.EbeanDataProvider;
import org.inventivetalent.data.ebean.KeyValueBean;
import org.inventivetalent.data.mongodb.MongoDbDataProvider;
import org.inventivetalent.data.redis.RedisDataProvider;
import org.inventivetalent.data.sql.SQLDataProvider;

public abstract class AsyncStringValueMapper {
    public static AsyncDataProvider<String> redis(RedisDataProvider provider) {
        return provider;
    }

    public static AsyncDataProvider<String> sql(SQLDataProvider provider) {
        return provider;
    }

    public static AsyncDataProvider<String> mongoDb(final MongoDbDataProvider provider) {
        return new AsyncDataProvider<String>(){

            @Override
            public void execute(Runnable runnable) {
                provider.execute(runnable);
            }

            @Override
            public Executor getExecutor() {
                return provider.getExecutor();
            }

            public JsonObject makeValue(String value) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("value", value);
                return jsonObject;
            }

            public String getValue(JsonObject jsonObject) {
                return jsonObject.get("value").getAsString();
            }

            @Override
            public void put(@Nonnull String key, @Nonnull String value) {
                provider.put(key, this.makeValue(value));
            }

            @Override
            public void put(@Nonnull String key, final @Nonnull DataCallable<String> valueCallable) {
                provider.put(key, new DataCallable<JsonObject>(){

                    @Override
                    @Nonnull
                    public JsonObject provide() {
                        return this.makeValue((String)valueCallable.provide());
                    }
                });
            }

            @Override
            public void putAll(@Nonnull Map<String, String> map) {
                HashMap<String, JsonObject> jsonMap = new HashMap<String, JsonObject>();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    jsonMap.put(entry.getKey(), this.makeValue(entry.getValue()));
                }
                provider.putAll((Map<String, JsonObject>)jsonMap);
            }

            @Override
            public void putAll(final @Nonnull DataCallable<Map<String, String>> mapCallable) {
                provider.putAll(new DataCallable<Map<String, JsonObject>>(){

                    @Override
                    @Nonnull
                    public Map<String, JsonObject> provide() {
                        Map map = (Map)mapCallable.provide();
                        HashMap<String, JsonObject> jsonMap = new HashMap<String, JsonObject>();
                        for (Map.Entry entry : map.entrySet()) {
                            jsonMap.put((String)entry.getKey(), this.makeValue((String)entry.getValue()));
                        }
                        return jsonMap;
                    }
                });
            }

            @Override
            public void get(@Nonnull String key, @Nonnull DataCallback<String> callback) {
                provider.get(key, (JsonObject jsonObject) -> callback.provide(this.getValue((JsonObject)jsonObject)));
            }

            @Override
            public void contains(@Nonnull String key, @Nonnull DataCallback<Boolean> callback) {
                provider.contains(key, callback);
            }

            @Override
            public void remove(@Nonnull String key, @Nonnull DataCallback<String> callback) {
                provider.remove(key, (JsonObject jsonObject) -> callback.provide(this.getValue((JsonObject)jsonObject)));
            }

            @Override
            public void remove(@Nonnull String key) {
                provider.remove(key);
            }

            @Override
            public void keys(@Nonnull DataCallback<Collection<String>> callback) {
                provider.keys(callback);
            }

            @Override
            public void entries(@Nonnull DataCallback<Map<String, String>> callback) {
                provider.entries((Map<String, JsonObject> stringJsonObjectMap) -> {
                    HashMap stringMap = new HashMap();
                    if (stringJsonObjectMap == null) {
                        callback.provide(stringMap);
                        return;
                    }
                    for (Map.Entry entry : stringJsonObjectMap.entrySet()) {
                        stringMap.put(entry.getKey(), this.getValue((JsonObject)entry.getValue()));
                    }
                    callback.provide(stringMap);
                });
            }

            @Override
            public void size(@Nonnull DataCallback<Integer> callback) {
                provider.size(callback);
            }
        };
    }

    public static <B extends KeyValueBean> AsyncDataProvider<String> ebean(final EbeanDataProvider<B> provider, final BeanProvider<B> beanProvider) {
        return new AsyncDataProvider<String>(){

            @Override
            public void execute(Runnable runnable) {
                provider.execute(runnable);
            }

            @Override
            public Executor getExecutor() {
                return provider.getExecutor();
            }

            B createBean(String key, String value) {
                return beanProvider.provide(key, value);
            }

            @Override
            public void put(@Nonnull String key, @Nonnull String value) {
                provider.put(key, this.createBean(key, value));
            }

            @Override
            public void put(final @Nonnull String key, final @Nonnull DataCallable<String> valueCallable) {
                provider.put(key, new DataCallable<B>(){

                    @Override
                    @Nonnull
                    public B provide() {
                        return this.createBean(key, (String)valueCallable.provide());
                    }
                });
            }

            @Override
            public void putAll(@Nonnull Map<String, String> map) {
                HashMap beanMap = new HashMap();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    beanMap.put(entry.getKey(), this.createBean(entry.getKey(), entry.getValue()));
                }
                provider.putAll(beanMap);
            }

            @Override
            public void putAll(final @Nonnull DataCallable<Map<String, String>> mapCallable) {
                provider.putAll(new DataCallable<Map<String, B>>(){

                    @Override
                    @Nonnull
                    public Map<String, B> provide() {
                        Map map = (Map)mapCallable.provide();
                        HashMap beanMap = new HashMap();
                        for (Map.Entry entry : map.entrySet()) {
                            beanMap.put(entry.getKey(), this.createBean((String)entry.getKey(), (String)entry.getValue()));
                        }
                        return beanMap;
                    }
                });
            }

            @Override
            public void get(@Nonnull String key, @Nonnull DataCallback<String> callback) {
                provider.get(key, (V keyValueBean) -> callback.provide(keyValueBean != null ? keyValueBean.getValue() : null));
            }

            @Override
            public void contains(@Nonnull String key, @Nonnull DataCallback<Boolean> callback) {
                provider.contains(key, callback);
            }

            @Override
            public void remove(@Nonnull String key, @Nonnull DataCallback<String> callback) {
                provider.remove(key, (V keyValueBean) -> callback.provide(keyValueBean != null ? keyValueBean.getValue() : null));
            }

            @Override
            public void remove(@Nonnull String key) {
                provider.remove(key);
            }

            @Override
            public void keys(@Nonnull DataCallback<Collection<String>> callback) {
                provider.keys(callback);
            }

            @Override
            public void entries(@Nonnull DataCallback<Map<String, String>> callback) {
                provider.entries((Map<String, V> stringBMap) -> {
                    HashMap stringMap = new HashMap();
                    if (stringBMap == null) {
                        callback.provide(null);
                        return;
                    }
                    for (Map.Entry entry : stringBMap.entrySet()) {
                        stringMap.put(entry.getKey(), ((KeyValueBean)entry.getValue()).getValue());
                    }
                    callback.provide(stringMap);
                });
            }

            @Override
            public void size(@Nonnull DataCallback<Integer> callback) {
                provider.size(callback);
            }
        };
    }
}

