/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.data.ebean;

import com.avaje.ebean.EbeanServer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.inventivetalent.data.async.AbstractAsyncDataProvider;
import org.inventivetalent.data.async.DataCallable;
import org.inventivetalent.data.async.DataCallback;
import org.inventivetalent.data.ebean.KeyBean;

public class EbeanDataProvider<V extends KeyBean>
extends AbstractAsyncDataProvider<V> {
    private final EbeanServer database;
    private final Class<V> beanClass;

    public EbeanDataProvider(EbeanServer database, Class<V> beanClass) {
        this.database = database;
        this.beanClass = beanClass;
    }

    public EbeanDataProvider(Executor executor, EbeanServer database, Class<V> beanClass) {
        super(executor);
        this.database = database;
        this.beanClass = beanClass;
    }

    public EbeanServer getDatabase() {
        return this.database;
    }

    public V newBean() {
        return (V)((KeyBean)this.beanClass.newInstance());
    }

    @Override
    public void put(@Nonnull String key, @Nonnull V value) {
        this.execute(() -> {
            KeyBean entry = (KeyBean)this.getDatabase().find(this.beanClass).where().eq("key", (Object)key).findUnique();
            boolean exists = entry != null;
            int id = -1;
            long version = 0L;
            if (entry != null) {
                id = entry.getId();
                version = entry.getVersion();
            }
            entry = value;
            entry.setKey(key);
            if (!exists) {
                this.getDatabase().save((Object)entry);
            } else {
                entry.setId(id);
                entry.setVersion(version);
                this.getDatabase().update((Object)entry);
            }
        });
    }

    @Override
    public void put(@Nonnull String key, @Nonnull DataCallable<V> valueCallable) {
        this.execute(() -> {
            KeyBean entry = (KeyBean)this.getDatabase().find(this.beanClass).where().eq("key", (Object)key).findUnique();
            boolean exists = entry != null;
            entry = (KeyBean)valueCallable.provide();
            entry.setKey(key);
            if (!exists) {
                this.getDatabase().save((Object)entry);
            } else {
                this.getDatabase().update((Object)entry);
            }
        });
    }

    @Override
    public void putAll(@Nonnull Map<String, V> map) {
        this.execute(() -> {
            for (Map.Entry mEntry : map.entrySet()) {
                KeyBean entry = (KeyBean)this.getDatabase().find(this.beanClass).where().eq("key", mEntry.getKey()).findUnique();
                boolean exists = entry != null;
                entry = (KeyBean)mEntry.getValue();
                entry.setKey((String)mEntry.getKey());
                if (!exists) {
                    this.getDatabase().save((Object)entry);
                    continue;
                }
                this.getDatabase().update((Object)entry);
            }
        });
    }

    @Override
    public void putAll(@Nonnull DataCallable<Map<String, V>> mapCallable) {
        this.execute(() -> {
            for (Map.Entry mEntry : ((Map)mapCallable.provide()).entrySet()) {
                KeyBean entry = (KeyBean)this.getDatabase().find(this.beanClass).where().eq("key", mEntry.getKey()).findUnique();
                boolean exists = entry != null;
                entry = (KeyBean)mEntry.getValue();
                entry.setKey((String)mEntry.getKey());
                if (!exists) {
                    this.getDatabase().save((Object)entry);
                    continue;
                }
                this.getDatabase().update((Object)entry);
            }
        });
    }

    @Override
    public void get(@Nonnull String key, @Nonnull DataCallback<V> callback) {
        this.execute(() -> callback.provide(this.getDatabase().find(this.beanClass).where().eq("key", (Object)key).findUnique()));
    }

    @Override
    public void contains(@Nonnull String key, @Nonnull DataCallback<Boolean> callback) {
        this.execute(() -> callback.provide(this.getDatabase().find(this.beanClass).where().eq("key", (Object)key).findRowCount() > 0));
    }

    @Override
    public void remove(@Nonnull String key, @Nonnull DataCallback<V> callback) {
        this.execute(() -> {
            KeyBean value = (KeyBean)this.getDatabase().find(this.beanClass).where().eq("key", (Object)key).findUnique();
            if (value != null) {
                this.getDatabase().delete((Object)value);
            }
            callback.provide(value);
        });
    }

    @Override
    public void remove(@Nonnull String key) {
        this.execute(() -> {
            KeyBean value = (KeyBean)this.getDatabase().find(this.beanClass).where().eq("key", (Object)key).findUnique();
            if (value != null) {
                this.getDatabase().delete((Object)value);
            }
        });
    }

    @Override
    public void keys(@Nonnull DataCallback<Collection<String>> callback) {
        this.execute(() -> {
            Set entries = this.getDatabase().find(this.beanClass).select("key").findSet();
            Set keys = entries.stream().map(KeyBean::getKey).collect(Collectors.toSet());
            callback.provide(keys);
        });
    }

    @Override
    public void entries(@Nonnull DataCallback<Map<String, V>> callback) {
        this.execute(() -> {
            Set entries = this.getDatabase().find(this.beanClass).findSet();
            HashMap<String, KeyBean> map = new HashMap<String, KeyBean>();
            for (KeyBean entry : entries) {
                map.put(entry.getKey(), entry);
            }
            callback.provide(map);
        });
    }

    @Override
    public void size(@Nonnull DataCallback<Integer> callback) {
        this.execute(() -> callback.provide(this.getDatabase().find(this.beanClass).findRowCount()));
    }
}

