/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.data.async;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.inventivetalent.data.async.AsyncDataProvider;

public abstract class AbstractAsyncDataProvider<V>
implements AsyncDataProvider<V> {
    private Executor executor;

    public AbstractAsyncDataProvider() {
        this.executor = Executors.newSingleThreadExecutor();
    }

    public AbstractAsyncDataProvider(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void execute(Runnable runnable) {
        if (this.executor == null) {
            throw new IllegalStateException("Missing executor");
        }
        this.executor.execute(runnable);
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }
}

