/*
 * Decompiled with CFR 0.152.
 */
package us.myles.viaversion.libs.opennbt.tag.builtin;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import us.myles.viaversion.libs.opennbt.tag.builtin.Tag;

public class FloatTag
extends Tag {
    private float value;

    public FloatTag(String name) {
        this(name, 0.0f);
    }

    public FloatTag(String name, float value) {
        super(name);
        this.value = value;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    public void setValue(float value) {
        this.value = value;
    }

    @Override
    public void read(DataInputStream in) throws IOException {
        this.value = in.readFloat();
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeFloat(this.value);
    }

    @Override
    public FloatTag clone() {
        return new FloatTag(this.getName(), this.getValue().floatValue());
    }
}

