/*
 * Decompiled with CFR 0.152.
 */
package us.myles.viaversion.libs.opennbt.tag.builtin;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import us.myles.viaversion.libs.opennbt.NBTIO;
import us.myles.viaversion.libs.opennbt.tag.builtin.Tag;

public class CompoundTag
extends Tag
implements Iterable<Tag> {
    private Map<String, Tag> value;

    public CompoundTag(String name) {
        this(name, new LinkedHashMap<String, Tag>());
    }

    public CompoundTag(String name, Map<String, Tag> value) {
        super(name);
        this.value = new LinkedHashMap<String, Tag>(value);
    }

    @Override
    public Map<String, Tag> getValue() {
        return new LinkedHashMap<String, Tag>(this.value);
    }

    public void setValue(Map<String, Tag> value) {
        this.value = new LinkedHashMap<String, Tag>(value);
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public boolean contains(String tagName) {
        return this.value.containsKey(tagName);
    }

    public <T extends Tag> T get(String tagName) {
        return (T)this.value.get(tagName);
    }

    public <T extends Tag> T put(T tag) {
        return (T)this.value.put(tag.getName(), tag);
    }

    public <T extends Tag> T remove(String tagName) {
        return (T)this.value.remove(tagName);
    }

    public Set<String> keySet() {
        return this.value.keySet();
    }

    public Collection<Tag> values() {
        return this.value.values();
    }

    public int size() {
        return this.value.size();
    }

    public void clear() {
        this.value.clear();
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.values().iterator();
    }

    @Override
    public void read(DataInputStream in) throws IOException {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        try {
            Tag tag;
            while ((tag = NBTIO.readTag(in)) != null) {
                tags.add(tag);
            }
        }
        catch (EOFException e) {
            throw new IOException("Closing EndTag was not found!");
        }
        for (Tag tag : tags) {
            this.put(tag);
        }
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        for (Tag tag : this.value.values()) {
            NBTIO.writeTag(out, tag);
        }
        out.writeByte(0);
    }

    @Override
    public CompoundTag clone() {
        LinkedHashMap<String, Tag> newMap = new LinkedHashMap<String, Tag>();
        for (Map.Entry<String, Tag> entry : this.value.entrySet()) {
            newMap.put(entry.getKey(), entry.getValue().clone());
        }
        return new CompoundTag(this.getName(), newMap);
    }
}

