/*
 * Decompiled with CFR 0.152.
 */
package us.myles.viaversion.libs.opennbt;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import us.myles.viaversion.libs.opennbt.tag.TagCreateException;
import us.myles.viaversion.libs.opennbt.tag.TagRegistry;
import us.myles.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import us.myles.viaversion.libs.opennbt.tag.builtin.Tag;

public class NBTIO {
    public static CompoundTag readFile(String path) throws IOException {
        return NBTIO.readFile(new File(path));
    }

    public static CompoundTag readFile(File file) throws IOException {
        return NBTIO.readFile(file, true);
    }

    public static CompoundTag readFile(String path, boolean compressed) throws IOException {
        return NBTIO.readFile(new File(path), compressed);
    }

    public static CompoundTag readFile(File file, boolean compressed) throws IOException {
        Tag tag;
        InputStream in = new FileInputStream(file);
        if (compressed) {
            in = new GZIPInputStream(in);
        }
        if (!((tag = NBTIO.readTag(new DataInputStream(in))) instanceof CompoundTag)) {
            throw new IOException("Root tag is not a CompoundTag!");
        }
        return (CompoundTag)tag;
    }

    public static void writeFile(CompoundTag tag, String path) throws IOException {
        NBTIO.writeFile(tag, new File(path));
    }

    public static void writeFile(CompoundTag tag, File file) throws IOException {
        NBTIO.writeFile(tag, file, true);
    }

    public static void writeFile(CompoundTag tag, String path, boolean compressed) throws IOException {
        NBTIO.writeFile(tag, new File(path), compressed);
    }

    public static void writeFile(CompoundTag tag, File file, boolean compressed) throws IOException {
        if (!file.exists()) {
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
        }
        OutputStream out = new FileOutputStream(file);
        if (compressed) {
            out = new GZIPOutputStream(out);
        }
        NBTIO.writeTag(new DataOutputStream(out), tag);
        out.close();
    }

    public static Tag readTag(DataInputStream in) throws IOException {
        Tag tag;
        int id = in.readUnsignedByte();
        if (id == 0) {
            return null;
        }
        String name = in.readUTF();
        try {
            tag = TagRegistry.createInstance(id, name);
        }
        catch (TagCreateException e) {
            throw new IOException("Failed to create tag.", e);
        }
        tag.read(in);
        return tag;
    }

    public static void writeTag(DataOutputStream out, Tag tag) throws IOException {
        out.writeByte(TagRegistry.getIdFor(tag.getClass()));
        out.writeUTF(tag.getName());
        tag.write(out);
    }
}

