/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_9to1_8.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.BitSet;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import us.myles.ViaVersion.api.ViaVersion;
import us.myles.ViaVersion.api.minecraft.chunks.Chunk;
import us.myles.ViaVersion.api.type.PartialType;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.api.type.types.minecraft.BaseChunkType;
import us.myles.ViaVersion.protocols.base.ProtocolInfo;
import us.myles.ViaVersion.protocols.protocol1_10to1_9_3.Protocol1_10To1_9_3_4;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.chunks.Chunk1_9to1_8;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.chunks.ChunkSection1_9to1_8;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.storage.ClientChunks;

public class ChunkType
extends PartialType<Chunk, ClientChunks> {
    public static final int SECTION_COUNT = 16;
    private static final int SECTION_SIZE = 16;
    private static final int BIOME_DATA_LENGTH = 256;

    public ChunkType(ClientChunks chunks) {
        super(chunks, Chunk.class);
    }

    private static long toLong(int msw, int lsw) {
        return ((long)msw << 32) + (long)lsw - Integer.MIN_VALUE;
    }

    @Override
    public Class<? extends Type> getBaseClass() {
        return BaseChunkType.class;
    }

    @Override
    public Chunk read(ByteBuf input, ClientChunks param) throws Exception {
        int i;
        boolean replacePistons = param.getUser().get(ProtocolInfo.class).getPipeline().contains(Protocol1_10To1_9_3_4.class) && ViaVersion.getConfig().isReplacePistons();
        int replacementId = ViaVersion.getConfig().getPistonReplacementId();
        int chunkX = input.readInt();
        int chunkZ = input.readInt();
        long chunkHash = ChunkType.toLong(chunkX, chunkZ);
        boolean groundUp = input.readByte() != 0;
        int bitmask = input.readUnsignedShort();
        int dataLength = (Integer)Type.VAR_INT.read(input);
        BitSet usedSections = new BitSet(16);
        ChunkSection1_9to1_8[] sections = new ChunkSection1_9to1_8[16];
        byte[] biomeData = null;
        for (int i2 = 0; i2 < 16; ++i2) {
            if ((bitmask & 1 << i2) == 0) continue;
            usedSections.set(i2);
        }
        int sectionCount = usedSections.cardinality();
        boolean isBulkPacket = param.getBulkChunks().remove(chunkHash);
        if (sectionCount == 0 && groundUp && !isBulkPacket && param.getLoadedChunks().contains(chunkHash)) {
            param.getLoadedChunks().remove(chunkHash);
            return new Chunk1_9to1_8(chunkX, chunkZ);
        }
        int startIndex = input.readerIndex();
        param.getLoadedChunks().add(chunkHash);
        for (i = 0; i < 16; ++i) {
            ChunkSection1_9to1_8 section;
            if (!usedSections.get(i)) continue;
            sections[i] = section = new ChunkSection1_9to1_8();
            byte[] blockData = new byte[8192];
            input.readBytes(blockData);
            ShortBuffer blockBuf = ByteBuffer.wrap(blockData).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
            for (int j = 0; j < 4096; ++j) {
                short mask = blockBuf.get();
                int type = mask >> 4;
                int data = mask & 0xF;
                if (replacePistons && type == 36) {
                    type = replacementId;
                }
                section.setBlock(j, type, data);
            }
        }
        for (i = 0; i < 16; ++i) {
            if (!usedSections.get(i)) continue;
            byte[] blockLightArray = new byte[2048];
            input.readBytes(blockLightArray);
            sections[i].setBlockLight(blockLightArray);
        }
        int bytesLeft = dataLength - (input.readerIndex() - startIndex);
        if (bytesLeft >= 2048) {
            for (int i3 = 0; i3 < 16; ++i3) {
                if (!usedSections.get(i3)) continue;
                byte[] skyLightArray = new byte[2048];
                input.readBytes(skyLightArray);
                sections[i3].setSkyLight(skyLightArray);
                bytesLeft -= 2048;
            }
        }
        if (bytesLeft >= 256) {
            biomeData = new byte[256];
            input.readBytes(biomeData);
            bytesLeft -= 256;
        }
        if (bytesLeft > 0) {
            Bukkit.getLogger().log(Level.WARNING, bytesLeft + " Bytes left after reading chunks! (" + groundUp + ")");
        }
        return new Chunk1_9to1_8(chunkX, chunkZ, groundUp, bitmask, sections, biomeData);
    }

    @Override
    public void write(ByteBuf output, ClientChunks param, Chunk input) throws Exception {
        if (!(input instanceof Chunk1_9to1_8)) {
            throw new Exception("Incompatible chunk, " + input.getClass());
        }
        Chunk1_9to1_8 chunk = (Chunk1_9to1_8)input;
        output.writeInt(chunk.getX());
        output.writeInt(chunk.getZ());
        if (chunk.isUnloadPacket()) {
            return;
        }
        output.writeByte(chunk.isGroundUp() ? 1 : 0);
        Type.VAR_INT.write(output, chunk.getPrimaryBitmask());
        ByteBuf buf = Unpooled.buffer();
        for (int i = 0; i < 16; ++i) {
            ChunkSection1_9to1_8 section = chunk.getSections()[i];
            if (section == null) continue;
            section.writeBlocks(buf);
            section.writeBlockLight(buf);
            if (!section.hasSkyLight()) continue;
            section.writeSkyLight(buf);
        }
        buf.readerIndex(0);
        Type.VAR_INT.write(output, buf.readableBytes() + (chunk.hasBiomeData() ? 256 : 0));
        output.writeBytes(buf);
        buf.release();
        if (chunk.hasBiomeData()) {
            output.writeBytes(chunk.getBiomeData());
        }
    }
}

