/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_9to1_8.storage;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.ViaVersion;
import us.myles.ViaVersion.api.boss.BossBar;
import us.myles.ViaVersion.api.boss.BossColor;
import us.myles.ViaVersion.api.boss.BossStyle;
import us.myles.ViaVersion.api.data.StoredObject;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.minecraft.Position;
import us.myles.ViaVersion.api.minecraft.item.Item;
import us.myles.ViaVersion.api.minecraft.metadata.Metadata;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.api.type.types.version.Types1_9;
import us.myles.ViaVersion.protocols.base.ProtocolInfo;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.Protocol1_9TO1_8;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.chat.GameMode;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.metadata.MetadataRewriter;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.metadata.NewType;

public class EntityTracker
extends StoredObject {
    private final Map<Integer, UUID> uuidMap = new ConcurrentHashMap<Integer, UUID>();
    private final Map<Integer, EntityType> clientEntityTypes = new ConcurrentHashMap<Integer, EntityType>();
    private final Map<Integer, List<Metadata>> metadataBuffer = new ConcurrentHashMap<Integer, List<Metadata>>();
    private final Map<Integer, Integer> vehicleMap = new ConcurrentHashMap<Integer, Integer>();
    private final Map<Integer, BossBar> bossBarMap = new ConcurrentHashMap<Integer, BossBar>();
    private final Set<Integer> validBlocking = Sets.newConcurrentHashSet();
    private final Set<Integer> knownHolograms = Sets.newConcurrentHashSet();
    private final Cache<Position, Material> blockInteractions = CacheBuilder.newBuilder().maximumSize(10L).expireAfterAccess(250L, TimeUnit.MILLISECONDS).build();
    private boolean blocking = false;
    private boolean autoTeam = false;
    private int entityID;
    private Position currentlyDigging = null;
    private boolean teamExists = false;
    private GameMode gameMode;

    public EntityTracker(UserConnection user) {
        super(user);
    }

    public UUID getEntityUUID(int id) {
        if (this.uuidMap.containsKey(id)) {
            return this.uuidMap.get(id);
        }
        UUID uuid = UUID.randomUUID();
        this.uuidMap.put(id, uuid);
        return uuid;
    }

    public void setSecondHand(Item item) {
        this.setSecondHand(this.entityID, item);
    }

    public void setSecondHand(int entityID, Item item) {
        PacketWrapper wrapper = new PacketWrapper(60, null, this.getUser());
        wrapper.write(Type.VAR_INT, entityID);
        wrapper.write(Type.VAR_INT, 1);
        wrapper.write(Type.ITEM, item);
        try {
            wrapper.send(Protocol1_9TO1_8.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeEntity(Integer entityID) {
        this.clientEntityTypes.remove(entityID);
        this.vehicleMap.remove(entityID);
        this.uuidMap.remove(entityID);
        this.validBlocking.remove(entityID);
        this.knownHolograms.remove(entityID);
        this.metadataBuffer.remove(entityID);
        BossBar bar = this.bossBarMap.remove(entityID);
        if (bar != null) {
            bar.hide();
        }
    }

    public boolean interactedBlockRecently(int x, int y, int z) {
        if (this.blockInteractions.size() == 0L) {
            return false;
        }
        for (Position p : this.blockInteractions.asMap().keySet()) {
            if (p.getX() != (long)x || p.getY() != (long)y || p.getZ() != (long)z) continue;
            return true;
        }
        return false;
    }

    public void addBlockInteraction(Position p) {
        this.blockInteractions.put((Object)p, (Object)Material.AIR);
    }

    public void handleMetadata(int entityID, List<Metadata> metadataList) {
        if (!this.clientEntityTypes.containsKey(entityID)) {
            return;
        }
        EntityType type = this.clientEntityTypes.get(entityID);
        for (Metadata metadata : new ArrayList<Metadata>(metadataList)) {
            BossBar bar;
            if (type == EntityType.WITHER && metadata.getId() == 10) {
                metadataList.remove(metadata);
            }
            if (type == EntityType.ENDER_DRAGON && metadata.getId() == 11) {
                metadataList.remove(metadata);
            }
            if (type == EntityType.SKELETON && this.getMetaByIndex(metadataList, 12) == null) {
                metadataList.add(new Metadata(12, NewType.Boolean.getTypeID(), Type.BOOLEAN, true));
            }
            if (type == EntityType.HORSE && metadata.getId() == 16 && (Integer)metadata.getValue() == Integer.MIN_VALUE) {
                metadata.setValue(0);
            }
            if (type == EntityType.PLAYER && metadata.getId() == 0) {
                byte data = (Byte)metadata.getValue();
                if (entityID != this.getEntityID() && ViaVersion.getConfig().isShieldBlocking()) {
                    if ((data & 0x10) == 16) {
                        if (this.validBlocking.contains(entityID)) {
                            Item shield = new Item(442, 1, 0, null);
                            this.setSecondHand(entityID, shield);
                        }
                    } else {
                        this.setSecondHand(entityID, null);
                    }
                }
            }
            if (type == EntityType.ARMOR_STAND && ViaVersion.getConfig().isHologramPatch() && metadata.getId() == 0 && this.getMetaByIndex(metadataList, 10) != null) {
                Metadata meta = this.getMetaByIndex(metadataList, 10);
                byte data = (Byte)metadata.getValue();
                if ((data & 0x20) == 32 && ((Byte)meta.getValue() & 1) == 1 && ((String)this.getMetaByIndex(metadataList, 2).getValue()).length() != 0 && ((Boolean)this.getMetaByIndex(metadataList, 3).getValue()).booleanValue() && !this.knownHolograms.contains(entityID)) {
                    this.knownHolograms.add(entityID);
                    try {
                        ByteBuf buf = this.getUser().getChannel().alloc().buffer();
                        Type.VAR_INT.write(buf, 37);
                        Type.VAR_INT.write(buf, entityID);
                        buf.writeShort(0);
                        buf.writeShort((int)((short)(128.0 * (ViaVersion.getConfig().getHologramYOffset() * 32.0))));
                        buf.writeShort(0);
                        buf.writeBoolean(true);
                        this.getUser().sendRawPacket(buf, false);
                    }
                    catch (Exception buf) {
                        // empty catch block
                    }
                }
            }
            UUID uuid = this.getUser().get(ProtocolInfo.class).getUuid();
            if (!ViaVersion.getConfig().isBossbarPatch() || type != EntityType.ENDER_DRAGON && type != EntityType.WITHER) continue;
            if (metadata.getId() == 2) {
                bar = this.bossBarMap.get(entityID);
                String title = (String)metadata.getValue();
                String string = title.isEmpty() ? (type == EntityType.ENDER_DRAGON ? "Ender Dragon" : "Wither") : (title = title);
                if (bar == null) {
                    bar = ViaVersion.getInstance().createBossBar(title, BossColor.PINK, BossStyle.SOLID);
                    this.bossBarMap.put(entityID, bar);
                    bar.addPlayer(uuid);
                    bar.show();
                    continue;
                }
                bar.setTitle(title);
                continue;
            }
            if (metadata.getId() != 6 || ViaVersion.getConfig().isBossbarAntiflicker()) continue;
            bar = this.bossBarMap.get(entityID);
            float maxHealth = type == EntityType.ENDER_DRAGON ? 200.0f : 300.0f;
            float health = Math.max(0.0f, Math.min(((Float)metadata.getValue()).floatValue() / maxHealth, 1.0f));
            if (bar == null) {
                String title = type == EntityType.ENDER_DRAGON ? "Ender Dragon" : "Wither";
                bar = ViaVersion.getInstance().createBossBar(title, health, BossColor.PINK, BossStyle.SOLID);
                this.bossBarMap.put(entityID, bar);
                bar.addPlayer(uuid);
                bar.show();
                continue;
            }
            bar.setHealth(health);
        }
    }

    public Metadata getMetaByIndex(List<Metadata> list, int index) {
        for (Metadata meta : list) {
            if (index != meta.getId()) continue;
            return meta;
        }
        return null;
    }

    public void sendTeamPacket(boolean b) {
        PacketWrapper wrapper = new PacketWrapper(65, null, this.getUser());
        wrapper.write(Type.STRING, "viaversion");
        if (b) {
            if (!this.teamExists) {
                wrapper.write(Type.BYTE, (byte)0);
                wrapper.write(Type.STRING, "viaversion");
                wrapper.write(Type.STRING, "");
                wrapper.write(Type.STRING, "");
                wrapper.write(Type.BYTE, (byte)0);
                wrapper.write(Type.STRING, "");
                wrapper.write(Type.STRING, "never");
                wrapper.write(Type.BYTE, (byte)0);
            } else {
                wrapper.write(Type.BYTE, (byte)3);
            }
            wrapper.write(Type.VAR_INT, 1);
            wrapper.write(Type.STRING, this.getUser().get(ProtocolInfo.class).getUsername());
        } else {
            wrapper.write(Type.BYTE, (byte)1);
        }
        this.teamExists = b;
        try {
            wrapper.send(Protocol1_9TO1_8.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addMetadataToBuffer(int entityID, List<Metadata> metadataList) {
        if (this.metadataBuffer.containsKey(entityID)) {
            this.metadataBuffer.get(entityID).addAll(metadataList);
        } else {
            this.metadataBuffer.put(entityID, metadataList);
        }
    }

    public void sendMetadataBuffer(int entityID) {
        if (this.metadataBuffer.containsKey(entityID)) {
            PacketWrapper wrapper = new PacketWrapper(57, null, this.getUser());
            wrapper.write(Type.VAR_INT, entityID);
            wrapper.write(Types1_9.METADATA_LIST, this.metadataBuffer.get(entityID));
            MetadataRewriter.transform(this.getClientEntityTypes().get(entityID), this.metadataBuffer.get(entityID));
            this.handleMetadata(entityID, this.metadataBuffer.get(entityID));
            if (this.metadataBuffer.get(entityID).size() > 0) {
                try {
                    wrapper.send(Protocol1_9TO1_8.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.metadataBuffer.remove(entityID);
        }
    }

    public Map<Integer, UUID> getUuidMap() {
        return this.uuidMap;
    }

    public Map<Integer, EntityType> getClientEntityTypes() {
        return this.clientEntityTypes;
    }

    public Map<Integer, List<Metadata>> getMetadataBuffer() {
        return this.metadataBuffer;
    }

    public Map<Integer, Integer> getVehicleMap() {
        return this.vehicleMap;
    }

    public Map<Integer, BossBar> getBossBarMap() {
        return this.bossBarMap;
    }

    public Set<Integer> getValidBlocking() {
        return this.validBlocking;
    }

    public Set<Integer> getKnownHolograms() {
        return this.knownHolograms;
    }

    public Cache<Position, Material> getBlockInteractions() {
        return this.blockInteractions;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public boolean isAutoTeam() {
        return this.autoTeam;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public Position getCurrentlyDigging() {
        return this.currentlyDigging;
    }

    public boolean isTeamExists() {
        return this.teamExists;
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public void setAutoTeam(boolean autoTeam) {
        this.autoTeam = autoTeam;
    }

    public void setEntityID(int entityID) {
        this.entityID = entityID;
    }

    public void setCurrentlyDigging(Position currentlyDigging) {
        this.currentlyDigging = currentlyDigging;
    }

    public void setGameMode(GameMode gameMode) {
        this.gameMode = gameMode;
    }
}

