/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_9to1_8;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import us.myles.ViaVersion.ViaVersionPlugin;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.ViaVersion;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.minecraft.item.Item;
import us.myles.ViaVersion.api.minecraft.metadata.Metadata;
import us.myles.ViaVersion.api.protocol.Protocol;
import us.myles.ViaVersion.api.remapper.ValueTransformer;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.api.type.types.version.Metadata1_8Type;
import us.myles.ViaVersion.api.type.types.version.MetadataList1_8Type;
import us.myles.ViaVersion.protocols.base.ProtocolInfo;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.ViaIdleThread;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.listeners.ArmorListener;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.listeners.BlockListener;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.listeners.CommandBlockListener;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.listeners.DeathListener;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.listeners.HandItemCache;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.listeners.PaperPatch;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.packets.EntityPackets;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.packets.InventoryPackets;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.packets.PlayerPackets;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.packets.SpawnPackets;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.packets.WorldPackets;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.storage.ClientChunks;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.storage.EntityTracker;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.storage.InventoryTracker;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.storage.MovementTracker;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.storage.PlaceBlockTracker;
import us.myles.viaversion.libs.gson.Gson;
import us.myles.viaversion.libs.gson.GsonBuilder;
import us.myles.viaversion.libs.gson.JsonObject;

public class Protocol1_9TO1_8
extends Protocol {
    @Deprecated
    public static Type<List<Metadata>> METADATA_LIST = new MetadataList1_8Type();
    @Deprecated
    public static Type<Metadata> METADATA = new Metadata1_8Type();
    private static Gson gson = new GsonBuilder().create();
    public static ValueTransformer<String, String> FIX_JSON = new ValueTransformer<String, String>(Type.STRING){

        @Override
        public String transform(PacketWrapper wrapper, String line) {
            return Protocol1_9TO1_8.fixJson(line);
        }
    };

    public static String fixJson(String line) {
        if (line == null || line.equalsIgnoreCase("null")) {
            line = "{\"text\":\"\"}";
        } else {
            if (!(line.startsWith("\"") && line.endsWith("\"") || line.startsWith("{") && line.endsWith("}"))) {
                return Protocol1_9TO1_8.constructJson(line);
            }
            if (line.startsWith("\"") && line.endsWith("\"")) {
                line = "{\"text\":" + line + "}";
            }
        }
        try {
            gson.fromJson(line, JsonObject.class);
        }
        catch (Exception e) {
            if (ViaVersion.getConfig().isForceJsonTransform()) {
                return Protocol1_9TO1_8.constructJson(line);
            }
            System.out.println("Invalid JSON String: \"" + line + "\" Please report this issue to the ViaVersion Github: " + e.getMessage());
            return "{\"text\":\"\"}";
        }
        return line;
    }

    private static String constructJson(String text) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("text", text);
        return gson.toJson(jsonObject);
    }

    public static Item getHandItem(final UserConnection info) {
        if (HandItemCache.CACHE) {
            return HandItemCache.getHandItem(info.get(ProtocolInfo.class).getUuid());
        }
        try {
            return (Item)Bukkit.getScheduler().callSyncMethod(Bukkit.getPluginManager().getPlugin("ViaVersion"), (Callable)new Callable<Item>(){

                @Override
                public Item call() throws Exception {
                    UUID playerUUID = info.get(ProtocolInfo.class).getUuid();
                    if (Bukkit.getPlayer((UUID)playerUUID) != null) {
                        return Item.getItem(Bukkit.getPlayer((UUID)playerUUID).getItemInHand());
                    }
                    return null;
                }
            }).get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            System.out.println("Error fetching hand item: " + e.getClass().getName());
            if (ViaVersion.getInstance().isDebug()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    @Override
    protected void registerPackets() {
        SpawnPackets.register(this);
        InventoryPackets.register(this);
        EntityPackets.register(this);
        PlayerPackets.register(this);
        WorldPackets.register(this);
    }

    @Override
    protected void registerListeners() {
        ViaVersionPlugin plugin = (ViaVersionPlugin)Bukkit.getPluginManager().getPlugin("ViaVersion");
        new ArmorListener(plugin).register();
        new CommandBlockListener(plugin).register();
        new DeathListener(plugin).register();
        new BlockListener(plugin).register();
        if (Bukkit.getVersion().toLowerCase().contains("paper") || Bukkit.getVersion().toLowerCase().contains("taco")) {
            plugin.getLogger().info("Enabling PaperSpigot/TacoSpigot patch: Fixes block placement.");
            new PaperPatch(plugin).register();
        }
        if (plugin.getConf().isStimulatePlayerTick()) {
            new ViaIdleThread(plugin.getPortedPlayers()).runTaskTimer((Plugin)plugin, 1L, 1L);
        }
        if (plugin.getConf().isItemCache()) {
            new HandItemCache().runTaskTimerAsynchronously((Plugin)plugin, 2L, 2L);
            HandItemCache.CACHE = true;
        }
    }

    @Override
    public boolean isFiltered(Class packetClass) {
        return packetClass.getName().endsWith("PacketPlayOutMapChunkBulk");
    }

    @Override
    protected void filterPacket(UserConnection info, Object packet, List output) throws Exception {
        output.addAll(info.get(ClientChunks.class).transformMapChunkBulk(packet));
    }

    @Override
    public void init(UserConnection userConnection) {
        userConnection.put(new EntityTracker(userConnection));
        userConnection.put(new ClientChunks(userConnection));
        userConnection.put(new MovementTracker(userConnection));
        userConnection.put(new InventoryTracker(userConnection));
        userConnection.put(new PlaceBlockTracker(userConnection));
    }
}

