/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.handlers;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import java.lang.reflect.Method;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.protocol.ProtocolPipeline;
import us.myles.ViaVersion.classgenerator.ClassGenerator;
import us.myles.ViaVersion.classgenerator.HandlerConstructor;
import us.myles.ViaVersion.handlers.ViaPacketHandler;

public class ViaVersionInitializer
extends ChannelInitializer<SocketChannel> {
    private final ChannelInitializer<SocketChannel> original;
    private Method method;

    public ViaVersionInitializer(ChannelInitializer<SocketChannel> oldInit) {
        this.original = oldInit;
        try {
            this.method = ChannelInitializer.class.getDeclaredMethod("initChannel", Channel.class);
            this.method.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public ChannelInitializer<SocketChannel> getOriginal() {
        return this.original;
    }

    protected void initChannel(SocketChannel socketChannel) throws Exception {
        UserConnection info = new UserConnection(socketChannel);
        new ProtocolPipeline(info);
        this.method.invoke(this.original, socketChannel);
        HandlerConstructor constructor = ClassGenerator.getConstructor();
        MessageToByteEncoder encoder = constructor.newEncodeHandler(info, (MessageToByteEncoder)socketChannel.pipeline().get("encoder"));
        ByteToMessageDecoder decoder = constructor.newDecodeHandler(info, (ByteToMessageDecoder)socketChannel.pipeline().get("decoder"));
        ViaPacketHandler chunkHandler = new ViaPacketHandler(info);
        socketChannel.pipeline().replace("encoder", "encoder", (ChannelHandler)encoder);
        socketChannel.pipeline().replace("decoder", "decoder", (ChannelHandler)decoder);
        socketChannel.pipeline().addAfter("packet_handler", "viaversion_packet_handler", (ChannelHandler)chunkHandler);
    }
}

