/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.commands.defaultsubs;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import us.myles.ViaVersion.api.ViaVersion;
import us.myles.ViaVersion.api.command.ViaSubCommand;
import us.myles.ViaVersion.api.protocol.ProtocolVersion;

public class ListSubCmd
extends ViaSubCommand {
    @Override
    public String name() {
        return "list";
    }

    @Override
    public String description() {
        return "Shows lists of the versions from logged in players";
    }

    @Override
    public String usage() {
        return "list";
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        TreeMap playerVersions = new TreeMap(new Comparator<ProtocolVersion>(){

            @Override
            public int compare(ProtocolVersion o1, ProtocolVersion o2) {
                return ProtocolVersion.getIndex(o2) - ProtocolVersion.getIndex(o1);
            }
        });
        for (Player player : Bukkit.getOnlinePlayers()) {
            int playerVersion = ViaVersion.getInstance().getPlayerVersion(player);
            ProtocolVersion key = ProtocolVersion.getProtocol(playerVersion);
            if (!playerVersions.containsKey(key)) {
                playerVersions.put(key, new HashSet());
            }
            ((Set)playerVersions.get(key)).add(player.getName());
        }
        for (Map.Entry entry : playerVersions.entrySet()) {
            this.sendMessage(sender, "&8[&6%s&8]: &b%s", ((ProtocolVersion)entry.getKey()).getName(), entry.getValue());
        }
        playerVersions.clear();
        return true;
    }
}

