/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.api.protocol;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.Pair;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.remapper.PacketRemapper;
import us.myles.ViaVersion.exception.CancelException;
import us.myles.ViaVersion.packets.Direction;
import us.myles.ViaVersion.packets.State;

public abstract class Protocol {
    private Map<Pair<State, Integer>, ProtocolPacket> incoming = new HashMap<Pair<State, Integer>, ProtocolPacket>();
    private Map<Pair<State, Integer>, ProtocolPacket> outgoing = new HashMap<Pair<State, Integer>, ProtocolPacket>();

    public Protocol() {
        this.registerPackets();
    }

    public boolean isFiltered(Class packetClass) {
        return false;
    }

    protected void filterPacket(UserConnection info, Object packet, List output) throws Exception {
        output.add(packet);
    }

    protected void registerListeners() {
    }

    protected abstract void registerPackets();

    public abstract void init(UserConnection var1);

    public void registerIncoming(State state, int oldPacketID, int newPacketID) {
        this.registerIncoming(state, oldPacketID, newPacketID, null);
    }

    public void registerIncoming(State state, int oldPacketID, int newPacketID, PacketRemapper packetRemapper) {
        ProtocolPacket protocolPacket = new ProtocolPacket(state, oldPacketID, newPacketID, packetRemapper);
        this.incoming.put(new Pair<State, Integer>(state, newPacketID), protocolPacket);
    }

    public void registerOutgoing(State state, int oldPacketID, int newPacketID) {
        this.registerOutgoing(state, oldPacketID, newPacketID, null);
    }

    public void registerOutgoing(State state, int oldPacketID, int newPacketID, PacketRemapper packetRemapper) {
        ProtocolPacket protocolPacket = new ProtocolPacket(state, oldPacketID, newPacketID, packetRemapper);
        this.outgoing.put(new Pair<State, Integer>(state, oldPacketID), protocolPacket);
    }

    public void transform(Direction direction, State state, PacketWrapper packetWrapper) throws Exception {
        Map<Pair<State, Integer>, ProtocolPacket> packetMap;
        Pair<State, Integer> statePacket = new Pair<State, Integer>(state, packetWrapper.getId());
        Map<Pair<State, Integer>, ProtocolPacket> map = packetMap = direction == Direction.OUTGOING ? this.outgoing : this.incoming;
        if (!packetMap.containsKey(statePacket)) {
            return;
        }
        ProtocolPacket protocolPacket = packetMap.get(statePacket);
        int newID = direction == Direction.OUTGOING ? protocolPacket.getNewID() : protocolPacket.getOldID();
        packetWrapper.setId(newID);
        if (protocolPacket.getRemapper() != null) {
            protocolPacket.getRemapper().remap(packetWrapper);
            if (packetWrapper.isCancelled()) {
                throw new CancelException();
            }
        }
    }

    public String toString() {
        return "Protocol:" + this.getClass().getSimpleName();
    }

    class ProtocolPacket {
        State state;
        int oldID;
        int newID;
        PacketRemapper remapper;

        @ConstructorProperties(value={"state", "oldID", "newID", "remapper"})
        public ProtocolPacket(State state, int oldID, int newID, PacketRemapper remapper) {
            this.state = state;
            this.oldID = oldID;
            this.newID = newID;
            this.remapper = remapper;
        }

        public State getState() {
            return this.state;
        }

        public int getOldID() {
            return this.oldID;
        }

        public int getNewID() {
            return this.newID;
        }

        public PacketRemapper getRemapper() {
            return this.remapper;
        }
    }
}

