/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.api.data;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.socket.SocketChannel;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import us.myles.ViaVersion.api.data.StoredObject;
import us.myles.ViaVersion.protocols.base.ProtocolInfo;

public class UserConnection {
    private final SocketChannel channel;
    Map<Class, StoredObject> storedObjects = new ConcurrentHashMap<Class, StoredObject>();
    private boolean active = true;
    private boolean pendingDisconnect = false;
    private Object lastPacket;
    private long sentPackets = 0L;
    private long receivedPackets = 0L;
    private long startTime = 0L;
    private long intervalPackets = 0L;
    private long packetsPerSecond = -1L;
    private int secondsObserved = 0;
    private int warnings = 0;

    public UserConnection(SocketChannel socketChannel) {
        this.channel = socketChannel;
    }

    public <T extends StoredObject> T get(Class<T> objectClass) {
        return (T)this.storedObjects.get(objectClass);
    }

    public boolean has(Class<? extends StoredObject> objectClass) {
        return this.storedObjects.containsKey(objectClass);
    }

    public void put(StoredObject object) {
        this.storedObjects.put(object.getClass(), object);
    }

    public void sendRawPacket(final ByteBuf packet, boolean currentThread) {
        final ChannelHandler handler = this.channel.pipeline().get("encoder");
        if (currentThread) {
            this.channel.pipeline().context(handler).writeAndFlush((Object)packet);
        } else {
            this.channel.eventLoop().submit(new Runnable(){

                @Override
                public void run() {
                    UserConnection.this.channel.pipeline().context(handler).writeAndFlush((Object)packet);
                }
            });
        }
    }

    public ChannelFuture sendRawPacketFuture(ByteBuf packet) {
        ChannelHandler handler = this.channel.pipeline().get("encoder");
        return this.channel.pipeline().context(handler).writeAndFlush((Object)packet);
    }

    public void sendRawPacket(ByteBuf packet) {
        this.sendRawPacket(packet, false);
    }

    public void incrementSent() {
        ++this.sentPackets;
    }

    public boolean incrementReceived() {
        Long diff = System.currentTimeMillis() - this.startTime;
        if (diff >= 1000L) {
            this.packetsPerSecond = this.intervalPackets;
            this.startTime = System.currentTimeMillis();
            this.intervalPackets = 1L;
            return true;
        }
        ++this.intervalPackets;
        ++this.receivedPackets;
        return false;
    }

    public void disconnect(final String reason) {
        UUID uuid;
        if (!this.getChannel().isOpen()) {
            return;
        }
        if (this.pendingDisconnect) {
            return;
        }
        this.pendingDisconnect = true;
        if (this.get(ProtocolInfo.class).getUuid() != null && Bukkit.getPlayer((UUID)(uuid = this.get(ProtocolInfo.class).getUuid())) != null) {
            Bukkit.getScheduler().runTask(Bukkit.getPluginManager().getPlugin("ViaVersion"), new Runnable(){

                @Override
                public void run() {
                    Player player = Bukkit.getPlayer((UUID)uuid);
                    if (player != null) {
                        player.kickPlayer(ChatColor.translateAlternateColorCodes((char)'&', (String)reason));
                    }
                }
            });
            return;
        }
        this.getChannel().close();
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public Map<Class, StoredObject> getStoredObjects() {
        return this.storedObjects;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isPendingDisconnect() {
        return this.pendingDisconnect;
    }

    public Object getLastPacket() {
        return this.lastPacket;
    }

    public long getSentPackets() {
        return this.sentPackets;
    }

    public long getReceivedPackets() {
        return this.receivedPackets;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getIntervalPackets() {
        return this.intervalPackets;
    }

    public long getPacketsPerSecond() {
        return this.packetsPerSecond;
    }

    public int getSecondsObserved() {
        return this.secondsObserved;
    }

    public int getWarnings() {
        return this.warnings;
    }

    public void setStoredObjects(Map<Class, StoredObject> storedObjects) {
        this.storedObjects = storedObjects;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setPendingDisconnect(boolean pendingDisconnect) {
        this.pendingDisconnect = pendingDisconnect;
    }

    public void setLastPacket(Object lastPacket) {
        this.lastPacket = lastPacket;
    }

    public void setSentPackets(long sentPackets) {
        this.sentPackets = sentPackets;
    }

    public void setReceivedPackets(long receivedPackets) {
        this.receivedPackets = receivedPackets;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setIntervalPackets(long intervalPackets) {
        this.intervalPackets = intervalPackets;
    }

    public void setPacketsPerSecond(long packetsPerSecond) {
        this.packetsPerSecond = packetsPerSecond;
    }

    public void setSecondsObserved(int secondsObserved) {
        this.secondsObserved = secondsObserved;
    }

    public void setWarnings(int warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserConnection)) {
            return false;
        }
        UserConnection other = (UserConnection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SocketChannel this$channel = this.getChannel();
        SocketChannel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        Map<Class, StoredObject> this$storedObjects = this.getStoredObjects();
        Map<Class, StoredObject> other$storedObjects = other.getStoredObjects();
        if (this$storedObjects == null ? other$storedObjects != null : !((Object)this$storedObjects).equals(other$storedObjects)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (this.isPendingDisconnect() != other.isPendingDisconnect()) {
            return false;
        }
        Object this$lastPacket = this.getLastPacket();
        Object other$lastPacket = other.getLastPacket();
        if (this$lastPacket == null ? other$lastPacket != null : !this$lastPacket.equals(other$lastPacket)) {
            return false;
        }
        if (this.getSentPackets() != other.getSentPackets()) {
            return false;
        }
        if (this.getReceivedPackets() != other.getReceivedPackets()) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.getIntervalPackets() != other.getIntervalPackets()) {
            return false;
        }
        if (this.getPacketsPerSecond() != other.getPacketsPerSecond()) {
            return false;
        }
        if (this.getSecondsObserved() != other.getSecondsObserved()) {
            return false;
        }
        return this.getWarnings() == other.getWarnings();
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserConnection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SocketChannel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        Map<Class, StoredObject> $storedObjects = this.getStoredObjects();
        result = result * 59 + ($storedObjects == null ? 43 : ((Object)$storedObjects).hashCode());
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + (this.isPendingDisconnect() ? 79 : 97);
        Object $lastPacket = this.getLastPacket();
        result = result * 59 + ($lastPacket == null ? 43 : $lastPacket.hashCode());
        long $sentPackets = this.getSentPackets();
        result = result * 59 + (int)($sentPackets >>> 32 ^ $sentPackets);
        long $receivedPackets = this.getReceivedPackets();
        result = result * 59 + (int)($receivedPackets >>> 32 ^ $receivedPackets);
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        long $intervalPackets = this.getIntervalPackets();
        result = result * 59 + (int)($intervalPackets >>> 32 ^ $intervalPackets);
        long $packetsPerSecond = this.getPacketsPerSecond();
        result = result * 59 + (int)($packetsPerSecond >>> 32 ^ $packetsPerSecond);
        result = result * 59 + this.getSecondsObserved();
        result = result * 59 + this.getWarnings();
        return result;
    }

    public String toString() {
        return "UserConnection(channel=" + this.getChannel() + ", storedObjects=" + this.getStoredObjects() + ", active=" + this.isActive() + ", pendingDisconnect=" + this.isPendingDisconnect() + ", lastPacket=" + this.getLastPacket() + ", sentPackets=" + this.getSentPackets() + ", receivedPackets=" + this.getReceivedPackets() + ", startTime=" + this.getStartTime() + ", intervalPackets=" + this.getIntervalPackets() + ", packetsPerSecond=" + this.getPacketsPerSecond() + ", secondsObserved=" + this.getSecondsObserved() + ", warnings=" + this.getWarnings() + ")";
    }
}

