/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import ru.tehkode.permissions.PermissionsGroupData;
import ru.tehkode.permissions.PermissionsUserData;
import ru.tehkode.permissions.backends.file.FileBackend;
import ru.tehkode.permissions.backends.file.FileConfig;
import ru.tehkode.permissions.bukkit.PermissionsEx;

public class FileData
implements PermissionsUserData,
PermissionsGroupData {
    protected final transient FileConfig config;
    private String nodePath;
    private String entityName;
    private final String basePath;
    private ConfigurationSection node;
    protected boolean virtual = true;
    private final String parentPath;

    public FileData(String basePath, String name, FileConfig config, String parentPath) {
        this.config = config;
        this.basePath = basePath;
        this.node = this.findNode(name);
        this.parentPath = parentPath;
    }

    private ConfigurationSection findExistingNode(String entityName, boolean set) {
        ConfigurationSection users;
        String nodePath;
        ConfigurationSection entityNode;
        if (this.config.isLowerCased(this.basePath)) {
            entityName = entityName.toLowerCase();
        }
        if ((entityNode = this.config.getConfigurationSection(nodePath = FileBackend.buildPath(this.basePath, entityName))) != null) {
            this.virtual = false;
            if (set) {
                this.nodePath = nodePath;
                this.entityName = entityName;
            }
            return entityNode;
        }
        if (!this.config.isLowerCased(this.basePath) && (users = this.config.getConfigurationSection(this.basePath)) != null) {
            for (Map.Entry entry : users.getValues(false).entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase(entityName) || !(entry.getValue() instanceof ConfigurationSection)) continue;
                if (set) {
                    this.nodePath = FileBackend.buildPath(this.basePath, (String)entry.getKey());
                    this.entityName = (String)entry.getKey();
                }
                return (ConfigurationSection)entry.getValue();
            }
        }
        return null;
    }

    private ConfigurationSection findNode(String entityName) {
        ConfigurationSection section;
        if (this.config.isLowerCased(this.basePath)) {
            entityName = entityName.toLowerCase();
        }
        if ((section = this.findExistingNode(entityName, true)) != null) {
            return section;
        }
        this.nodePath = FileBackend.buildPath(this.basePath, entityName);
        section = this.config.createSection(this.nodePath);
        this.entityName = entityName;
        this.config.set(this.nodePath, null);
        this.virtual = true;
        return section;
    }

    @Override
    public String getIdentifier() {
        return this.entityName;
    }

    @Override
    public boolean setIdentifier(String identifier) {
        ConfigurationSection section = this.findExistingNode(identifier, false);
        if (section != null) {
            return false;
        }
        String caseCorrectedIdentifier = this.config.isLowerCased(this.basePath) ? identifier.toLowerCase() : identifier;
        String oldNodePath = this.nodePath;
        this.nodePath = FileBackend.buildPath(this.basePath, caseCorrectedIdentifier);
        this.node = this.config.createSection(this.nodePath, this.node.getValues(false));
        this.entityName = identifier;
        this.config.set(oldNodePath, null);
        if (!this.isVirtual()) {
            this.config.set(this.nodePath, this.node);
            this.save();
        } else {
            this.config.set(this.nodePath, null);
        }
        return true;
    }

    @Override
    public List<String> getPermissions(String worldName) {
        List result = this.node.getStringList(FileData.formatPath(worldName, "permissions"));
        return result == null ? Collections.emptyList() : Collections.unmodifiableList(result);
    }

    @Override
    public void setPermissions(List<String> permissions, String worldName) {
        this.node.set(FileData.formatPath(worldName, "permissions"), (Object)(permissions == null ? null : new ArrayList<String>(permissions)));
        this.save();
    }

    @Override
    public Map<String, List<String>> getPermissionsMap() {
        ConfigurationSection worldsSection;
        HashMap allPermissions = new HashMap();
        List commonPermissions = this.node.getStringList("permissions");
        if (commonPermissions != null) {
            allPermissions.put(null, Collections.unmodifiableList(commonPermissions));
        }
        if ((worldsSection = this.node.getConfigurationSection("worlds")) != null) {
            for (String world : worldsSection.getKeys(false)) {
                List worldPermissions = this.node.getStringList(FileBackend.buildPath("worlds", world, "permissions"));
                if (commonPermissions == null) continue;
                allPermissions.put(world, Collections.unmodifiableList(worldPermissions));
            }
        }
        return Collections.unmodifiableMap(allPermissions);
    }

    @Override
    public Set<String> getWorlds() {
        ConfigurationSection worldsSection = this.node.getConfigurationSection("worlds");
        if (worldsSection == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(worldsSection.getKeys(false));
    }

    @Override
    public String getOption(String option, String worldName) {
        return this.node.getString(FileData.formatPath(worldName, "options", option));
    }

    @Override
    public void setOption(String option, String value, String worldName) {
        this.node.set(FileData.formatPath(worldName, "options", option), (Object)value);
        this.save();
    }

    @Override
    public Map<String, String> getOptions(String worldName) {
        ConfigurationSection optionsSection = this.node.getConfigurationSection(FileData.formatPath(worldName, "options"));
        if (optionsSection == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.collectOptions(optionsSection));
    }

    @Override
    public Map<String, Map<String, String>> getOptionsMap() {
        HashMap<String, Map<String, String>> allOptions = new HashMap<String, Map<String, String>>();
        allOptions.put(null, this.getOptions(null));
        for (String worldName : this.getWorlds()) {
            allOptions.put(worldName, this.getOptions(worldName));
        }
        return Collections.unmodifiableMap(allOptions);
    }

    @Override
    public boolean isVirtual() {
        return this.virtual;
    }

    @Override
    public void save() {
        if (this.isVirtual()) {
            this.config.set(this.nodePath, this.node);
            this.virtual = false;
        }
        try {
            this.config.save();
        }
        catch (IOException e) {
            PermissionsEx.getPermissionManager().getLogger().log(Level.SEVERE, "Error saving data for  " + this.nodePath, e);
        }
    }

    @Override
    public void remove() {
        this.config.set(this.nodePath, null);
        this.save();
    }

    @Override
    public Map<String, List<String>> getParentsMap() {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        ret.put(null, this.getParents(null));
        for (String world : this.getWorlds()) {
            ret.put(world, this.getParents(world));
        }
        return Collections.unmodifiableMap(ret);
    }

    @Override
    public List<String> getParents(String worldName) {
        List parents = this.node.getStringList(FileData.formatPath(worldName, this.parentPath));
        Iterator it = parents.iterator();
        while (it.hasNext()) {
            String test = (String)it.next();
            if (test != null && !test.isEmpty()) continue;
            it.remove();
        }
        if (parents == null || parents.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(parents);
    }

    @Override
    public void setParents(List<String> parents, String worldName) {
        this.node.set(FileData.formatPath(worldName, this.parentPath), (Object)(parents == null ? null : new ArrayList<String>(parents)));
        this.save();
    }

    @Override
    public void load() {
    }

    private Map<String, String> collectOptions(ConfigurationSection section) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        for (String key : section.getKeys(true)) {
            if (section.isConfigurationSection(key)) continue;
            options.put(key.replace(section.getRoot().options().pathSeparator(), '.'), section.getString(key));
        }
        return options;
    }

    protected static String formatPath(String worldName, String node, String value) {
        String path = FileBackend.buildPath(node, value);
        if (worldName != null && !worldName.isEmpty()) {
            path = FileBackend.buildPath("worlds", worldName, path);
        }
        return path;
    }

    protected static String formatPath(String worldName, String node) {
        String path = node;
        if (worldName != null && !worldName.isEmpty()) {
            path = FileBackend.buildPath("worlds", worldName, path);
        }
        return path;
    }
}

