/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.xray;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dynamicdev.anticheat.xray.XRayStats;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class XRayTracker {
    private Map<String, Integer> diamond = new HashMap<String, Integer>();
    private Map<String, Integer> gold = new HashMap<String, Integer>();
    private Map<String, Integer> iron = new HashMap<String, Integer>();
    private Map<String, Integer> lapis = new HashMap<String, Integer>();
    private Map<String, Integer> redstone = new HashMap<String, Integer>();
    private Map<String, Integer> block = new HashMap<String, Integer>();
    private Map<String, Integer> totalblock = new HashMap<String, Integer>();
    private List<String> alerted = new ArrayList<String>();
    private static final ChatColor GREEN = ChatColor.GREEN;
    private static final ChatColor WHITE = ChatColor.WHITE;
    private static final ChatColor RED = ChatColor.RED;
    private static final ChatColor GRAY = ChatColor.GRAY;
    private static final int RATIO_DIVISOR = 3;
    private static final int POWER = 10;
    private static final int MIN_BLOCK_COUNT = 100;

    public boolean sufficientData(String player) {
        return this.totalblock.get(player) != null && this.totalblock.get(player) >= 100;
    }

    public void calculate(CommandSender cs, String player, double x, double b, String type) {
        ChatColor color = WHITE;
        if (x >= b / 3.0) {
            color = RED;
        }
        cs.sendMessage(GRAY + "Percent " + type + " ore: " + color + this.round(x) + "%");
    }

    public boolean calculate(String player, double x, double b) {
        return x >= b / 3.0;
    }

    public boolean hasAbnormal(String player) {
        XRayStats stats = new XRayStats(player, this.diamond, this.gold, this.iron, this.lapis, this.redstone, this.block, this.totalblock);
        double total = stats.getOther();
        return this.calculate(player, stats.getDiamond(), total) || this.calculate(player, stats.getGold(), total) || this.calculate(player, stats.getIron(), total) || this.calculate(player, stats.getLapis(), total) || this.calculate(player, stats.getRedstone(), total);
    }

    public boolean hasAlerted(String player) {
        return this.alerted.contains(player);
    }

    public void logAlert(String player) {
        this.alerted.add(player);
    }

    public void sendStats(CommandSender cs, String player) {
        this.getStats(cs, player);
    }

    public void getStats(CommandSender cs, String player) {
        XRayStats stats = new XRayStats(player, this.diamond, this.gold, this.iron, this.lapis, this.redstone, this.block, this.totalblock);
        double total = stats.getOther();
        cs.sendMessage("--------------------[" + GREEN + "X-Ray Stats" + WHITE + "]---------------------");
        cs.sendMessage(GRAY + "Player: " + WHITE + player);
        cs.sendMessage(GRAY + "Total blocks broken: " + WHITE + stats.getTotal());
        this.calculate(cs, player, stats.getDiamond(), total, "diamond");
        this.calculate(cs, player, stats.getGold(), total, "gold");
        this.calculate(cs, player, stats.getIron(), total, "iron");
        this.calculate(cs, player, stats.getLapis(), total, "lapis");
        this.calculate(cs, player, stats.getRedstone(), total, "redstone");
        cs.sendMessage(GRAY + "Percent all other blocks: " + WHITE + this.round(stats.getOther()) + "%");
        cs.sendMessage("-----------------------------------------------------");
    }

    public void addDiamond(String player) {
        this.addOre(player, this.diamond);
    }

    public void addGold(String player) {
        this.addOre(player, this.gold);
    }

    public void addIron(String player) {
        this.addOre(player, this.iron);
    }

    public void addLapis(String player) {
        this.addOre(player, this.lapis);
    }

    public void addRedstone(String player) {
        this.addOre(player, this.redstone);
    }

    public void addBlock(String player) {
        this.addOre(player, this.block);
    }

    public void addTotal(String player) {
        this.addOre(player, this.totalblock);
    }

    private void addOre(String player, Map<String, Integer> map) {
        if (map.get(player) == null || map.get(player) == 0) {
            map.put(player, 1);
        } else {
            int playerLevel = map.get(player);
            map.put(player, playerLevel + 1);
        }
    }

    private float round(double num) {
        double number = num;
        float p = (float)Math.pow(10.0, 1.0);
        float tmp = Math.round(number *= (double)p);
        return tmp / p;
    }

    public void reset(String player) {
        this.totalblock.put(player, 1);
        this.diamond.put(player, 0);
        this.iron.put(player, 0);
        this.gold.put(player, 0);
        this.redstone.put(player, 0);
        this.lapis.put(player, 0);
        this.totalblock.put(player, 0);
    }
}

