/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.util.rule;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.SortedMap;
import java.util.TreeMap;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.check.CheckType;
import net.dynamicdev.anticheat.util.Group;
import net.dynamicdev.anticheat.util.User;
import net.dynamicdev.anticheat.util.Utilities;
import org.bukkit.GameMode;

public class Rule {
    private static String string;
    private static final String VARIABLE_SET_REGEX = ".*(_).*=.*";
    private static final String FUNCTION_REGEX = ".*\\..*";
    private Type type;

    public Rule(String string, Type type) {
        Rule.string = Utilities.removeWhitespace(string).toLowerCase();
        this.type = type;
    }

    public boolean check(User user, CheckType type) {
        return true;
    }

    public static Rule load(String string) {
        for (Type type : Type.values()) {
            if (!type.matches(string)) continue;
            try {
                Class<?> c = Class.forName(type.getInstance());
                Constructor<?> con = c.getConstructor(String.class);
                return (Rule)con.newInstance(string);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public Type getType() {
        return this.type;
    }

    protected String getString() {
        return string;
    }

    protected SortedMap<String, Object> getVariables(User user, CheckType type) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("player_check", type.name().toLowerCase());
        map.put("player_level", user.getLevel());
        map.put("player_group", user.getGroup() != null ? user.getGroup().getName().toLowerCase() : "low");
        map.put("player_name", user.getName().toLowerCase());
        map.put("player_gamemode", user.getPlayer().getGameMode().toString());
        map.put("player_world", user.getPlayer().getWorld().getName());
        map.put("player_health", user.getPlayer().getHealth());
        for (CheckType t : CheckType.values()) {
            map.put("check_" + t.name().toLowerCase(), t.getUses(user.getName()));
        }
        return map;
    }

    protected void setVariable(String variable, String value, User user) {
        if (variable.equals("player_level") && Utilities.isInt(value)) {
            user.setLevel(Integer.parseInt(value));
        } else if (variable.equals("player_group") && Utilities.isInt(value)) {
            for (Group group : AntiCheat.getManager().getConfiguration().getGroups().getGroups()) {
                if (!group.getName().equalsIgnoreCase(value)) continue;
                user.setLevel(group.getLevel());
            }
        } else if (variable.equals("player_gamemode")) {
            try {
                GameMode mode = GameMode.valueOf((String)value);
                user.getPlayer().setGameMode(mode);
            }
            catch (IllegalArgumentException ex) {}
        } else if (variable.equals("player_health") && Utilities.isDouble(value)) {
            user.getPlayer().setHealth(Double.parseDouble(value));
        }
    }

    protected void doFunction(String text, CheckType type, User user) {
        if (text.toLowerCase().startsWith("player")) {
            text = text.split("\\.")[1];
            ArrayList<String> action = new ArrayList<String>();
            action.add(text);
            AntiCheat.getManager().getUserManager().execute(user, action, type);
        }
    }

    protected boolean isFunction(String string) {
        return string.matches(FUNCTION_REGEX);
    }

    protected boolean isVariableSet(String string) {
        return string.matches(VARIABLE_SET_REGEX);
    }

    public String toString() {
        return (Object)((Object)this.type) + "{" + string + "}";
    }

    public static enum Type {
        CONDITIONAL(".*[?]*.*:.*", "net.gravitydevelopment.anticheat.util.rule.ConditionalRule");

        private String regex;
        private String c;

        private Type(String regex, String c) {
            this.regex = regex;
            this.c = c;
        }

        public boolean matches(String s) {
            return s.matches(this.regex);
        }

        public String getInstance() {
            return this.c;
        }
    }
}

