/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.util.BlockHardness;
import net.dynamicdev.anticheat.util.Permission;
import net.dynamicdev.anticheat.util.SimpleLocation;
import net.dynamicdev.anticheat.util.ToolHardness;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public final class Utilities {
    private static final List<Material> INSTANT_BREAK = new ArrayList<Material>();
    private static final List<Material> FOOD = new ArrayList<Material>();
    private static final List<Material> INTERACTABLE = new ArrayList<Material>();
    private static final Map<Material, Material> COMBO = new HashMap<Material, Material>();
    public static final String SPY_METADATA = "ac-spydata";

    public static void alert(List<String> message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!Permission.SYSTEM_ALERT.get((CommandSender)player)) continue;
            for (String msg : message) {
                player.sendMessage(msg);
            }
        }
        for (String msg : message) {
            AntiCheat.getManager().log(msg);
        }
    }

    public static boolean isSafeSetbackLocation(Player player) {
        return (Utilities.isInWeb(player) || Utilities.isInWater(player) || !Utilities.cantStandAtSingle(player.getLocation().getBlock())) && !player.getEyeLocation().getBlock().getType().isSolid();
    }

    public static double getXDelta(Location one, Location two) {
        return Math.abs(one.getX() - two.getX());
    }

    public static double getZDelta(Location one, Location two) {
        return Math.abs(one.getZ() - two.getZ());
    }

    public static double getDistance3D(Location one, Location two) {
        double toReturn = 0.0;
        double xSqr = (two.getX() - one.getX()) * (two.getX() - one.getX());
        double ySqr = (two.getY() - one.getY()) * (two.getY() - one.getY());
        double zSqr = (two.getZ() - one.getZ()) * (two.getZ() - one.getZ());
        double sqrt = Math.sqrt(xSqr + ySqr + zSqr);
        toReturn = Math.abs(sqrt);
        return toReturn;
    }

    public static double getDistance3D(SimpleLocation one, SimpleLocation two) {
        double toReturn = 0.0;
        double xSqr = (two.getX() - one.getX()) * (two.getX() - one.getX());
        double ySqr = (two.getY() - one.getY()) * (two.getY() - one.getY());
        double zSqr = (two.getZ() - one.getZ()) * (two.getZ() - one.getZ());
        double sqrt = Math.sqrt(xSqr + ySqr + zSqr);
        toReturn = Math.abs(sqrt);
        return toReturn;
    }

    public static double getHorizontalDistance(Location one, Location two) {
        double toReturn = 0.0;
        double xSqr = (two.getX() - one.getX()) * (two.getX() - one.getX());
        double zSqr = (two.getZ() - one.getZ()) * (two.getZ() - one.getZ());
        double sqrt = Math.sqrt(xSqr + zSqr);
        toReturn = Math.abs(sqrt);
        return toReturn;
    }

    public static double getHorizontalDistance(SimpleLocation one, SimpleLocation two) {
        double toReturn = 0.0;
        double xSqr = (two.getX() - one.getX()) * (two.getX() - one.getX());
        double zSqr = (two.getZ() - one.getZ()) * (two.getZ() - one.getZ());
        double sqrt = Math.sqrt(xSqr + zSqr);
        toReturn = Math.abs(sqrt);
        return toReturn;
    }

    public static boolean cantStandAtBetter(Block block) {
        Block otherBlock = block.getRelative(BlockFace.DOWN);
        boolean center1 = otherBlock.getType() == Material.AIR;
        boolean north1 = otherBlock.getRelative(BlockFace.NORTH).getType() == Material.AIR;
        boolean east1 = otherBlock.getRelative(BlockFace.EAST).getType() == Material.AIR;
        boolean south1 = otherBlock.getRelative(BlockFace.SOUTH).getType() == Material.AIR;
        boolean west1 = otherBlock.getRelative(BlockFace.WEST).getType() == Material.AIR;
        boolean northeast1 = otherBlock.getRelative(BlockFace.NORTH_EAST).getType() == Material.AIR;
        boolean northwest1 = otherBlock.getRelative(BlockFace.NORTH_WEST).getType() == Material.AIR;
        boolean southeast1 = otherBlock.getRelative(BlockFace.SOUTH_EAST).getType() == Material.AIR;
        boolean southwest1 = otherBlock.getRelative(BlockFace.SOUTH_WEST).getType() == Material.AIR;
        boolean overAir1 = otherBlock.getRelative(BlockFace.DOWN).getType() == Material.AIR || otherBlock.getRelative(BlockFace.DOWN).getType() == Material.WATER || otherBlock.getRelative(BlockFace.DOWN).getType() == Material.LAVA;
        return center1 && north1 && east1 && south1 && west1 && northeast1 && southeast1 && northwest1 && southwest1 && overAir1;
    }

    public static boolean cantStandAtSingle(Block block) {
        Block otherBlock = block.getRelative(BlockFace.DOWN);
        boolean center = otherBlock.getType() == Material.AIR;
        return center;
    }

    public static boolean cantStandAtWater(Block block) {
        Block otherBlock = block.getRelative(BlockFace.DOWN);
        boolean isHover = block.getType() == Material.AIR;
        boolean n = otherBlock.getRelative(BlockFace.NORTH).getType() == Material.WATER;
        boolean s = otherBlock.getRelative(BlockFace.SOUTH).getType() == Material.WATER;
        boolean e = otherBlock.getRelative(BlockFace.EAST).getType() == Material.WATER;
        boolean w = otherBlock.getRelative(BlockFace.WEST).getType() == Material.WATER;
        boolean ne = otherBlock.getRelative(BlockFace.NORTH_EAST).getType() == Material.WATER;
        boolean nw = otherBlock.getRelative(BlockFace.NORTH_WEST).getType() == Material.WATER;
        boolean se = otherBlock.getRelative(BlockFace.SOUTH_EAST).getType() == Material.WATER;
        boolean sw = otherBlock.getRelative(BlockFace.SOUTH_WEST).getType() == Material.WATER;
        return n && s && e && w && ne && nw && se && sw && isHover;
    }

    public static boolean canStandWithin(Block block) {
        boolean isSand = block.getType() == Material.SAND;
        boolean isGravel = block.getType() == Material.GRAVEL;
        boolean solid = block.getType().isSolid() && !block.getType().name().toLowerCase().contains("door") && !block.getType().name().toLowerCase().contains("fence") && !block.getType().name().toLowerCase().contains("bars") && !block.getType().name().toLowerCase().contains("sign");
        return !isSand && !isGravel && !solid;
    }

    public static Vector getRotation(Location one, Location two) {
        double dx = two.getX() - one.getX();
        double dy = two.getY() - one.getY();
        double dz = two.getZ() - one.getZ();
        double distanceXZ = Math.sqrt(dx * dx + dz * dz);
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(dy, distanceXZ) * 180.0 / Math.PI));
        return new Vector(yaw, pitch, 0.0f);
    }

    public static double clamp180(double theta) {
        if ((theta %= 360.0) >= 180.0) {
            theta -= 360.0;
        }
        if (theta < -180.0) {
            theta += 360.0;
        }
        return theta;
    }

    public static int getLevelForEnchantment(Player player, String enchantment) {
        try {
            Enchantment theEnchantment = Enchantment.getByName((String)enchantment);
            for (ItemStack item : player.getInventory().getArmorContents()) {
                if (!item.containsEnchantment(theEnchantment)) continue;
                return item.getEnchantmentLevel(theEnchantment);
            }
        }
        catch (Exception e) {
            return -1;
        }
        return -1;
    }

    public static boolean cantStandAt(Block block) {
        return !Utilities.canStand(block) && Utilities.cantStandClose(block) && Utilities.cantStandFar(block);
    }

    public static boolean cantStandAtExp(Location location) {
        return Utilities.cantStandAt(new Location(location.getWorld(), Utilities.fixXAxis(location.getX()), location.getY() - 0.01, (double)location.getBlockZ()).getBlock());
    }

    public static boolean cantStandClose(Block block) {
        return !Utilities.canStand(block.getRelative(BlockFace.NORTH)) && !Utilities.canStand(block.getRelative(BlockFace.EAST)) && !Utilities.canStand(block.getRelative(BlockFace.SOUTH)) && !Utilities.canStand(block.getRelative(BlockFace.WEST));
    }

    public static boolean cantStandFar(Block block) {
        return !Utilities.canStand(block.getRelative(BlockFace.NORTH_WEST)) && !Utilities.canStand(block.getRelative(BlockFace.NORTH_EAST)) && !Utilities.canStand(block.getRelative(BlockFace.SOUTH_WEST)) && !Utilities.canStand(block.getRelative(BlockFace.SOUTH_EAST));
    }

    public static boolean canStand(Block block) {
        return !block.isLiquid() && block.getType() != Material.AIR;
    }

    public static boolean isFullyInWater(Location player) {
        double touchedX = Utilities.fixXAxis(player.getX());
        if (!new Location(player.getWorld(), touchedX, player.getY(), (double)player.getBlockZ()).getBlock().isLiquid() && !new Location(player.getWorld(), touchedX, (double)Math.round(player.getY()), (double)player.getBlockZ()).getBlock().isLiquid()) {
            return true;
        }
        return new Location(player.getWorld(), touchedX, player.getY(), (double)player.getBlockZ()).getBlock().isLiquid() && new Location(player.getWorld(), touchedX, (double)Math.round(player.getY()), (double)player.getBlockZ()).getBlock().isLiquid();
    }

    public static double fixXAxis(double x) {
        double touchedX = x;
        double rem = touchedX - (double)Math.round(touchedX) + 0.01;
        if (rem < 0.3) {
            touchedX = NumberConversions.floor((double)x) - 1;
        }
        return touchedX;
    }

    public static boolean isHoveringOverWater(Location player, int blocks) {
        for (int i = player.getBlockY(); i > player.getBlockY() - blocks; --i) {
            Block newloc = new Location(player.getWorld(), (double)player.getBlockX(), (double)i, (double)player.getBlockZ()).getBlock();
            if (newloc.getType() == Material.AIR) continue;
            return newloc.isLiquid();
        }
        return false;
    }

    public static boolean isHoveringOverWater(Location player) {
        return Utilities.isHoveringOverWater(player, 25);
    }

    public static boolean isInstantBreak(Material m) {
        return INSTANT_BREAK.contains(m);
    }

    public static boolean isFood(Material m) {
        return FOOD.contains(m);
    }

    public static boolean isSlab(Block block) {
        Material type = block.getType();
        switch (type) {
            case STEP: 
            case DOUBLE_STEP: 
            case WOOD_STEP: 
            case WOOD_DOUBLE_STEP: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStair(Block block) {
        Material type = block.getType();
        switch (type) {
            case WOOD_STAIRS: 
            case SPRUCE_WOOD_STAIRS: 
            case SMOOTH_STAIRS: 
            case SANDSTONE_STAIRS: 
            case QUARTZ_STAIRS: 
            case JUNGLE_WOOD_STAIRS: 
            case NETHER_BRICK_STAIRS: 
            case BIRCH_WOOD_STAIRS: 
            case COBBLESTONE_STAIRS: {
                return true;
            }
        }
        return false;
    }

    public static boolean isInteractable(Material m) {
        return INTERACTABLE.contains(m);
    }

    public static boolean sprintFly(Player player) {
        return player.isSprinting() || player.isFlying();
    }

    public static boolean isOnLilyPad(Player player) {
        Block block = player.getLocation().getBlock();
        Material lily = Material.WATER_LILY;
        return block.getType() == lily || block.getRelative(BlockFace.NORTH).getType() == lily || block.getRelative(BlockFace.SOUTH).getType() == lily || block.getRelative(BlockFace.EAST).getType() == lily || block.getRelative(BlockFace.WEST).getType() == lily;
    }

    public static boolean isSubmersed(Player player) {
        return player.getLocation().getBlock().isLiquid() && player.getLocation().getBlock().getRelative(BlockFace.UP).isLiquid();
    }

    public static boolean isInWater(Player player) {
        return player.getLocation().getBlock().isLiquid() || player.getLocation().getBlock().getRelative(BlockFace.DOWN).isLiquid() || player.getLocation().getBlock().getRelative(BlockFace.UP).isLiquid();
    }

    public static boolean isInWeb(Player player) {
        return player.getLocation().getBlock().getType() == Material.WEB || player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType() == Material.WEB || player.getLocation().getBlock().getRelative(BlockFace.UP).getType() == Material.WEB;
    }

    public static boolean isClimbableBlock(Block block) {
        return block.getType() == Material.VINE || block.getType() == Material.LADDER || block.getType() == Material.WATER || block.getType() == Material.STATIONARY_WATER;
    }

    public static boolean isOnVine(Player player) {
        return player.getLocation().getBlock().getType() == Material.VINE;
    }

    public static boolean isInt(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isDouble(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static long calcSurvivalFastBreak(ItemStack tool, Material block) {
        if (Utilities.isInstantBreak(block) || tool.getType() == Material.SHEARS && block == Material.LEAVES) {
            return 0L;
        }
        double bhardness = BlockHardness.getBlockHardness(block);
        double thardness = ToolHardness.getToolHardness(tool.getType());
        long enchantlvl = tool.getEnchantmentLevel(Enchantment.DIG_SPEED);
        long result = Math.round(bhardness * thardness * 0.1 * 10000.0);
        if (enchantlvl > 0L) {
            result /= enchantlvl * enchantlvl + 1L;
        }
        long l = result > 25000L ? 25000L : (result = result < 0L ? 0L : result);
        if (Utilities.isQuickCombo(tool, block)) {
            result /= 2L;
        }
        return result;
    }

    private static boolean isQuickCombo(ItemStack tool, Material block) {
        for (Material t : COMBO.keySet()) {
            if (tool.getType() != t || COMBO.get(t) != block) continue;
            return true;
        }
        return false;
    }

    public static boolean blockIsnt(Block block, Material[] materials) {
        Material type = block.getType();
        for (Material m : materials) {
            if (m != type) continue;
            return false;
        }
        return false;
    }

    public static String[] getCommands(String command) {
        return command.replaceAll("COMMAND\\[", "").replaceAll("]", "").split(";");
    }

    public static String removeWhitespace(String string) {
        return string.replaceAll(" ", "");
    }

    public static boolean hasArmorEnchantment(Player player, Enchantment e) {
        for (ItemStack is : player.getInventory().getArmorContents()) {
            if (is == null || !is.containsEnchantment(e)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<String> stringToList(final String string) {
        return new ArrayList<String>(){
            {
                this.add(string);
            }
        };
    }

    public static String listToCommaString(List<String> list) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            b.append(list.get(i));
            if (i >= list.size() - 1) continue;
            b.append(",");
        }
        return b.toString();
    }

    public static long lifeToSeconds(String string) {
        if (string.equals("0") || string.equals("")) {
            return 0L;
        }
        String[] lifeMatch = new String[]{"d", "h", "m", "s"};
        int[] lifeInterval = new int[]{86400, 3600, 60, 1};
        long seconds = 0L;
        for (int i = 0; i < lifeMatch.length; ++i) {
            Matcher matcher = Pattern.compile("([0-9]*)" + lifeMatch[i]).matcher(string);
            while (matcher.find()) {
                seconds += (long)(Integer.parseInt(matcher.group(1)) * lifeInterval[i]);
            }
        }
        return seconds;
    }

    static {
        INSTANT_BREAK.add(Material.RED_MUSHROOM);
        INSTANT_BREAK.add(Material.RED_ROSE);
        INSTANT_BREAK.add(Material.BROWN_MUSHROOM);
        INSTANT_BREAK.add(Material.YELLOW_FLOWER);
        INSTANT_BREAK.add(Material.REDSTONE);
        INSTANT_BREAK.add(Material.REDSTONE_TORCH_OFF);
        INSTANT_BREAK.add(Material.REDSTONE_TORCH_ON);
        INSTANT_BREAK.add(Material.REDSTONE_WIRE);
        INSTANT_BREAK.add(Material.LONG_GRASS);
        INSTANT_BREAK.add(Material.PAINTING);
        INSTANT_BREAK.add(Material.WHEAT);
        INSTANT_BREAK.add(Material.SUGAR_CANE);
        INSTANT_BREAK.add(Material.SUGAR_CANE_BLOCK);
        INSTANT_BREAK.add(Material.DIODE);
        INSTANT_BREAK.add(Material.DIODE_BLOCK_OFF);
        INSTANT_BREAK.add(Material.DIODE_BLOCK_ON);
        INSTANT_BREAK.add(Material.SAPLING);
        INSTANT_BREAK.add(Material.TORCH);
        INSTANT_BREAK.add(Material.CROPS);
        INSTANT_BREAK.add(Material.SNOW);
        INSTANT_BREAK.add(Material.TNT);
        INSTANT_BREAK.add(Material.POTATO);
        INSTANT_BREAK.add(Material.CARROT);
        INTERACTABLE.add(Material.STONE_BUTTON);
        INTERACTABLE.add(Material.LEVER);
        INTERACTABLE.add(Material.CHEST);
        FOOD.add(Material.COOKED_BEEF);
        FOOD.add(Material.COOKED_CHICKEN);
        FOOD.add(Material.COOKED_FISH);
        FOOD.add(Material.GRILLED_PORK);
        FOOD.add(Material.PORK);
        FOOD.add(Material.MUSHROOM_SOUP);
        FOOD.add(Material.RAW_BEEF);
        FOOD.add(Material.RAW_CHICKEN);
        FOOD.add(Material.RAW_FISH);
        FOOD.add(Material.APPLE);
        FOOD.add(Material.GOLDEN_APPLE);
        FOOD.add(Material.MELON);
        FOOD.add(Material.COOKIE);
        FOOD.add(Material.BREAD);
        FOOD.add(Material.SPIDER_EYE);
        FOOD.add(Material.ROTTEN_FLESH);
        FOOD.add(Material.POTATO_ITEM);
        COMBO.put(Material.SHEARS, Material.WOOL);
        COMBO.put(Material.IRON_SWORD, Material.WEB);
        COMBO.put(Material.DIAMOND_SWORD, Material.WEB);
        COMBO.put(Material.STONE_SWORD, Material.WEB);
        COMBO.put(Material.WOOD_SWORD, Material.WEB);
    }
}

