/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.check.CheckType;
import net.dynamicdev.anticheat.config.Configuration;
import net.dynamicdev.anticheat.util.Group;
import net.dynamicdev.anticheat.util.Utilities;
import net.dynamicdev.anticheat.util.rule.Rule;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class User {
    private final String name;
    private final int id;
    private int level = 0;
    private Location goodLocation;
    private List<ItemStack> inventorySnapshot = null;
    private Configuration config = AntiCheat.getManager().getConfiguration();
    private int toX;
    private int toY;
    private int toZ;
    private String[] messages = new String[2];
    private Long[] messageTimes = new Long[2];
    private String[] commands = new String[2];
    private Long[] commandTimes = new Long[2];
    private boolean isWaitingOnLevelSync;
    private Timestamp levelSyncTimestamp;

    public User(String name) {
        this.name = name;
        this.id = this.getPlayer() != null && this.getPlayer().isOnline() ? this.getPlayer().getEntityId() : -1;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((String)this.name);
    }

    public int getLevel() {
        return this.level;
    }

    public Group getGroup() {
        List<Group> groups = this.config.getGroups().getGroups();
        for (int i = 0; i < groups.size() && (i != 0 || this.level >= groups.get(i).getLevel()); ++i) {
            if (i == groups.size() - 1) {
                return groups.get(i);
            }
            if (this.level < groups.get(i).getLevel() || this.level >= groups.get(i + 1).getLevel()) continue;
            return groups.get(i);
        }
        return null;
    }

    public boolean increaseLevel(CheckType type) {
        if (this.getPlayer() != null && this.getPlayer().isOnline()) {
            if (this.silentMode() && type.getUses(this.name) % 4 != 0) {
                return false;
            }
            if (this.level < this.config.getGroups().getHighestLevel()) {
                ++this.level;
                for (Group l : this.getLevels()) {
                    if (l.getLevel() != this.level) continue;
                    AntiCheat.getManager().getUserManager().alert(this, l, type);
                    if (l.getLevel() != this.config.getGroups().getHighestLevel()) continue;
                    this.level = l.getLevel() - 10;
                }
                for (Rule rule : this.config.getRules().getRules()) {
                    rule.check(this, type);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void decreaseLevel() {
        this.level = this.level != 0 ? this.level - 1 : 0;
    }

    public boolean setLevel(int level) {
        this.isWaitingOnLevelSync = false;
        if (level >= 0) {
            if (level <= this.config.getGroups().getHighestLevel()) {
                this.level = level;
                return true;
            }
            this.level = this.config.getGroups().getHighestLevel();
            return false;
        }
        return false;
    }

    public void resetLevel() {
        this.level = 0;
        for (CheckType type : CheckType.values()) {
            type.clearUse(this.name);
        }
    }

    public Location getGoodLocation(Location location) {
        if (this.goodLocation == null) {
            return location;
        }
        return this.goodLocation;
    }

    public boolean setGoodLocation(Location location) {
        if (Utilities.cantStandAtExp(location) || location.getBlock().isLiquid() && !Utilities.isFullyInWater(location)) {
            return false;
        }
        this.goodLocation = location;
        return true;
    }

    public void setInventorySnapshot(ItemStack[] is) {
        this.inventorySnapshot = new ArrayList<ItemStack>();
        for (int i = 0; i < is.length; ++i) {
            if (is[i] == null) continue;
            this.inventorySnapshot.add(is[i].clone());
        }
    }

    public void removeInventorySnapshot() {
        this.inventorySnapshot = null;
    }

    public void restoreInventory(Inventory inventory) {
        if (this.inventorySnapshot != null) {
            inventory.clear();
            for (ItemStack is : this.inventorySnapshot) {
                if (is == null) continue;
                inventory.addItem(new ItemStack[]{is});
            }
        }
    }

    public void setTo(double x, double y, double z) {
        this.toX = (int)x;
        this.toY = (int)y;
        this.toZ = (int)z;
    }

    public boolean checkTo(double x, double y, double z) {
        return (int)x == this.toX && (int)y == this.toY && (int)z == this.toZ;
    }

    public void addMessage(String message) {
        this.addToSpamLog(message, this.messages, this.messageTimes);
    }

    public void addCommand(String command) {
        this.addToSpamLog(command, this.commands, this.commandTimes);
    }

    private void addToSpamLog(String string, String[] messages, Long[] times) {
        messages[1] = messages[0];
        messages[0] = string;
        times[1] = times[0];
        times[0] = System.currentTimeMillis();
    }

    public String getMessage(int index) {
        return this.messages[index];
    }

    public String getCommand(int index) {
        return this.commands[index];
    }

    public Long getMessageTime(int index) {
        return this.messageTimes[index];
    }

    public Long getCommandTime(int index) {
        return this.commandTimes[index];
    }

    public void clearMessages() {
        this.messages = new String[2];
        this.messageTimes = new Long[2];
    }

    public void clearCommands() {
        this.commands = new String[2];
        this.commandTimes = new Long[2];
    }

    public Long getLastMessageTime() {
        return this.getMessageTime(0) == null ? -1L : this.getMessageTime(0);
    }

    public Long getLastCommandTime() {
        return this.getCommandTime(0) == null ? -1L : this.getCommandTime(0);
    }

    private List<Group> getLevels() {
        return this.config.getGroups().getGroups();
    }

    private boolean silentMode() {
        return this.config.getConfig().silentMode.getValue();
    }

    public void setIsWaitingOnLevelSync(boolean b) {
        this.isWaitingOnLevelSync = b;
    }

    public boolean isWaitingOnLevelSync() {
        return this.isWaitingOnLevelSync;
    }

    public void setLevelSyncTimestamp(Timestamp timestamp) {
        this.levelSyncTimestamp = timestamp;
    }

    public Timestamp getLevelSyncTimestamp() {
        return this.levelSyncTimestamp;
    }

    public String toString() {
        return "User {name = " + this.name + ", level = " + this.level + "}";
    }
}

