/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.config.Configuration;
import net.dynamicdev.anticheat.config.providers.Magic;
import net.dynamicdev.anticheat.util.Permission;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PastebinReport {
    private static final String DATE = new SimpleDateFormat("yyyy-MM-dd kk:mm Z").format(new Date());
    private static final String API_KEY = "e86d2991b6119f0e16ebb870ceed1d4b";
    private StringBuilder report = new StringBuilder();
    private String url = "";

    public PastebinReport(CommandSender cs) {
        Player player = null;
        if (cs instanceof Player) {
            player = (Player)cs;
        }
        this.createReport(player);
        try {
            this.writeReport();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.postReport();
    }

    public PastebinReport(CommandSender cs, Player tp) {
        this.createReport(tp);
        try {
            this.writeReport();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.postReport();
    }

    public String getURL() {
        return this.url;
    }

    private void appendPermissionsTester(Player player) {
        if (player == null) {
            this.append("No player defined.");
            return;
        }
        for (Permission node : Permission.values()) {
            this.report.append(player.getName() + ": " + node.toString() + " " + node.get((CommandSender)player));
            if (node.get((CommandSender)player) && !node.whichPermission((CommandSender)player).equals(node.toString())) {
                this.report.append(" (Applied by " + node.whichPermission((CommandSender)player) + ")");
            }
            this.report.append('\n');
        }
    }

    private void createReport(Player player) {
        if (Bukkit.getPluginManager().getPlugin("NoCheatPlus") != null) {
            this.append("------------ WARNING! ------------");
            this.append("This report was run with NoCheatPlus enabled. Results may be inaccurate.\n");
        }
        this.append("------------ AntiCheatPlus Report - " + DATE + " ------------");
        this.appendSystemInfo();
        this.append("------------Last 30 logs------------");
        this.appendLogs();
        this.append("------------Permission Tester------------");
        this.appendPermissionsTester(player);
        this.append("------------Event Chains------------");
        this.appendEventHandlers();
        this.append("------------Magic Diff------------");
        this.appendMagicDiff();
        this.append("-----------End Of Report------------");
    }

    private void appendLogs() {
        List<String> logs = AntiCheat.getManager().getLoggingManager().getLastLogs();
        if (logs.size() == 0) {
            this.append("No recent logs.");
            return;
        }
        for (String log : logs) {
            this.append(log);
        }
    }

    private void appendSystemInfo() {
        Runtime runtime = Runtime.getRuntime();
        Configuration config = AntiCheat.getManager().getConfiguration();
        this.append("AntiCheat Version: " + AntiCheat.getVersion() + (AntiCheat.isUpdated() ? "" : " (OUTDATED)"));
        this.append("Server Version: " + Bukkit.getVersion());
        this.append("Server Implementation: " + Bukkit.getName());
        this.append("Server ID: " + Bukkit.getServerId());
        this.append("Java Version: " + System.getProperty("java.vendor") + " " + System.getProperty("java.version"));
        this.append("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
        this.append("Free Memory: " + runtime.freeMemory() / 1024L / 1024L + "MB");
        this.append("Max Memory: " + runtime.maxMemory() / 1024L / 1024L + "MB");
        this.append("Total Memory: " + runtime.totalMemory() / 1024L / 1024L + "MB");
        this.append("Online Mode: " + Bukkit.getOnlineMode());
        this.append("Players: " + Bukkit.getOnlinePlayers().length + "/" + Bukkit.getMaxPlayers());
        this.append("Plugin Count: " + Bukkit.getPluginManager().getPlugins().length);
        this.append("Plugin Uptime: " + (System.currentTimeMillis() - AntiCheat.getPlugin().getLoadTime()) / 1000L / 60L + " minutes");
        this.append("Enterprise: " + config.getConfig().enterprise.getValue());
        if (config.getConfig().enterprise.getValue().booleanValue()) {
            this.append("- Server name: " + config.getEnterprise().serverName.getValue());
            this.append("- Database type: " + (Object)((Object)config.getEnterprise().database.getType()));
            this.append("- Groups source: " + (config.getEnterprise().configGroups.getValue() != false ? "Database" : "Flatfile"));
            this.append("- Rules source: " + (config.getEnterprise().configRules.getValue() != false ? "Database" : "Flatfile"));
            this.append("- Levels source: " + (config.getEnterprise().syncLevels.getValue() != false ? "Database" : "Flatfile"));
        }
    }

    private void appendMagicDiff() {
        Magic magic = AntiCheat.getManager().getConfiguration().getMagic();
        YamlConfiguration file = YamlConfiguration.loadConfiguration((InputStream)AntiCheat.getPlugin().getResource("magic.yml"));
        boolean changed = false;
        for (Field field : Magic.class.getFields()) {
            Object defaultValue = file.get(field.getName());
            try {
                Field value = magic.getClass().getDeclaredField(field.getName());
                boolean x = false;
                String s1 = value.get(magic).toString();
                String s2 = defaultValue.toString();
                if (s1.equals(s2) || s1.equals(s2 + ".0")) continue;
                changed = true;
                this.append(field.getName() + ": " + s1 + " (Default: " + s2 + ")");
            }
            catch (NoSuchFieldException ex) {
            }
            catch (IllegalAccessException ex) {
                // empty catch block
            }
        }
        if (!changed) {
            this.append("No changes from default.");
        }
    }

    private void appendEventHandlers() {
        this.report.append(AntiCheat.getManager().getEventChainReport());
    }

    private void writeReport() throws IOException {
        File f = new File(AntiCheat.getPlugin().getDataFolder() + "/report.txt");
        FileWriter r = new FileWriter(f);
        BufferedWriter writer = new BufferedWriter(r);
        writer.write(this.report.toString());
        writer.close();
    }

    private void postReport() {
        try {
            URL urls = new URL("http://pastebin.com/api/api_post.php");
            HttpURLConnection conn = (HttpURLConnection)urls.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.setRequestMethod("POST");
            conn.addRequestProperty("Content-type", "application/x-www-form-urlencoded");
            conn.setInstanceFollowRedirects(false);
            conn.setDoOutput(true);
            OutputStream out = conn.getOutputStream();
            out.write(("api_option=paste&api_dev_key=" + URLEncoder.encode(API_KEY, "utf-8") + "&api_paste_code=" + URLEncoder.encode(this.report.toString(), "utf-8") + "&api_paste_private=" + URLEncoder.encode("1", "utf-8") + "&api_paste_name=" + URLEncoder.encode("", "utf-8") + "&api_paste_expire_date=" + URLEncoder.encode("1M", "utf-8") + "&api_paste_format=" + URLEncoder.encode("text", "utf-8") + "&api_user_key=" + URLEncoder.encode("", "utf-8")).getBytes());
            out.flush();
            out.close();
            if (conn.getResponseCode() == 200) {
                String line;
                InputStream receive = conn.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(receive));
                StringBuffer response = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                    response.append("\r\n");
                }
                reader.close();
                String result = response.toString().trim();
                this.url = !result.contains("http://") ? "Failed to post.  Check report.txt" : result.trim();
            } else {
                this.url = "Failed to post.  Check report.txt";
            }
        }
        catch (Exception e) {
            this.url = "Failed to post.  Check report.txt";
        }
    }

    private void append(String s) {
        this.report.append(s + '\n');
    }
}

