/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.util.Utilities;
import org.bukkit.ChatColor;

public class Group {
    private String name;
    private int level;
    private ChatColor color = ChatColor.RED;
    private List<String> actions = new ArrayList<String>();

    public Group(String name, int level, String color, List<String> actions) {
        this.name = name;
        this.level = level;
        this.actions = actions;
        ChatColor c = ChatColor.valueOf((String)color);
        if (c == null) {
            AntiCheat.getPlugin().getLogger().warning("Event '" + name + "' was initialized with the color '" + color + "' which is invalid.");
            AntiCheat.getPlugin().getLogger().warning("This event will not run properly. See http://jd.bukkit.org/apidocs/org/bukkit/ChatColor.html#enum_constant_summary for a list of valid colors");
        } else {
            this.color = c;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }

    public ChatColor getColor() {
        return this.color;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public static Group load(String string) {
        try {
            if (string.split(" : ").length == 4) {
                String name = string.split(" : ")[0];
                int level = Integer.parseInt(string.split(" : ")[1]);
                String color = string.split(" : ")[2];
                List<String> actions = Arrays.asList(string.split(" : ")[3].split(","));
                return new Group(name, level, color, actions);
            }
            throw new Exception();
        }
        catch (Exception ex) {
            AntiCheat.getPlugin().getLogger().warning("An event was initialized with an invalid string: '" + string + "'");
            AntiCheat.getPlugin().getLogger().warning("The proper format is: 'name : threshold : color : action' such as 'High : 50 : RED : KICK'");
            AntiCheat.getPlugin().getLogger().warning("This event will NOT run. (" + ex.getMessage() + ")");
            return null;
        }
    }

    public String toString() {
        return this.name + " : " + this.level + " : " + this.color.name() + " : " + Utilities.listToCommaString(this.actions);
    }
}

