/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.util;

import java.util.HashMap;
import net.dynamicdev.anticheat.AntiCheat;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class Calibrator {
    private final AntiCheat plugin;
    private final Server server;
    private final Player player;
    private HashMap<String, Integer> ints = new HashMap();
    private HashMap<String, Double> doubles = new HashMap();

    public Calibrator(AntiCheat plugin, Player player) {
        this.plugin = plugin;
        this.server = plugin.getServer();
        this.player = player;
        player.sendMessage("You have entered calibration mode.");
    }

    public Player getPlayer() {
        return this.player;
    }

    private void registerEvents(CalibrationStep step) {
        this.server.getPluginManager().registerEvents((Listener)step, (Plugin)this.plugin);
    }

    private void unregisterEvents(CalibrationStep step) {
        HandlerList.unregisterAll((Listener)step);
    }

    public class MinimumCalibrationStep
    extends CalibrationStep {
        public MinimumCalibrationStep(String key, String instruction) {
            super(key, instruction);
        }

        public void value() {
        }
    }

    public class CalibrationStep
    implements Listener {
        private final String key;
        private int trials = 0;
        public static final int MAX_TRIALS = 10;

        public CalibrationStep(String key, String instruction) {
            this.key = key;
            Calibrator.this.registerEvents(this);
            Calibrator.this.getPlayer().sendMessage(instruction);
        }

        public void end() {
            Calibrator.this.unregisterEvents(this);
        }

        public long getTime() {
            return System.currentTimeMillis();
        }

        public String getKey() {
            return this.key;
        }

        public int addTrial() {
            return this.trials++;
        }
    }
}

