/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.manage;

import java.util.ArrayList;
import java.util.List;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.check.CheckType;
import net.dynamicdev.anticheat.config.Configuration;
import net.dynamicdev.anticheat.manage.AntiCheatManager;
import net.dynamicdev.anticheat.util.Group;
import net.dynamicdev.anticheat.util.User;
import net.dynamicdev.anticheat.util.Utilities;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class UserManager {
    private List<User> users = new ArrayList<User>();
    private static AntiCheatManager manager;
    private static Configuration config;
    private static final ChatColor GRAY;
    private static final ChatColor GOLD;
    private static final ChatColor RED;

    public UserManager(AntiCheatManager manager) {
        UserManager.manager = manager;
        config = manager.getConfiguration();
    }

    public User getUser(String name) {
        for (User user : this.users) {
            if (!user.getName().equalsIgnoreCase(name)) continue;
            return user;
        }
        User user = new User(name);
        user.setIsWaitingOnLevelSync(true);
        config.getLevels().loadLevelToUser(user);
        return user;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void addUser(User user) {
        this.users.add(user);
    }

    public void remove(User user) {
        this.users.remove(user);
    }

    public void saveLevel(User user) {
        config.getLevels().saveLevelFromUser(user);
    }

    public List<User> getUsersInGroup(Group group) {
        ArrayList<User> list = new ArrayList<User>();
        for (User u : this.users) {
            if (u.getGroup() != group) continue;
            list.add(u);
        }
        return list;
    }

    public int safeGetLevel(String name) {
        User user = this.getUser(name);
        if (user == null) {
            return 0;
        }
        return user.getLevel();
    }

    public void safeSetLevel(String name, int level) {
        User user = this.getUser(name);
        if (user != null) {
            user.setLevel(level);
        }
    }

    public void safeReset(String name) {
        User user = this.getUser(name);
        if (user != null) {
            user.resetLevel();
        }
    }

    public List<String> getAlert() {
        return config.getLang().ALERT();
    }

    public void alert(User user, Group group, CheckType type) {
        ArrayList<String> messageArray = new ArrayList<String>();
        List<String> alert = this.getAlert();
        for (int i = 0; i < alert.size(); ++i) {
            String message = alert.get(i);
            if (message.equals("")) continue;
            message = message.replaceAll("&player", GOLD + user.getName() + GRAY);
            message = message.replaceAll("&check", GOLD + CheckType.getName(type) + GRAY);
            message = message.replaceAll("&group", group.getColor() + group.getName() + GRAY);
            message = message.replaceAll("&level", "" + user.getLevel() + GRAY);
            messageArray.add(message);
        }
        Utilities.alert(messageArray);
        this.execute(user, group.getActions(), type);
    }

    public void execute(User user, List<String> actions, CheckType type) {
        this.execute(user, actions, type, config.getLang().KICK_REASON(), config.getLang().WARNING(), config.getLang().BAN_REASON());
    }

    public void execute(final User user, final List<String> actions, final CheckType type, final String kickReason, final List<String> warning, final String banReason) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)AntiCheat.getPlugin(), new Runnable(){

            @Override
            public void run() {
                String name = user.getName();
                for (String event : actions) {
                    String msg;
                    if ((event = event.replaceAll("&player", name).replaceAll("&world", user.getPlayer().getWorld().getName()).replaceAll("&check", type.name())).startsWith("COMMAND[")) {
                        for (String cmd : Utilities.getCommands(event)) {
                            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), cmd);
                        }
                        continue;
                    }
                    if (event.equalsIgnoreCase("KICK")) {
                        if (AntiCheat.developerMode()) continue;
                        user.getPlayer().kickPlayer(RED + kickReason);
                        msg = RED + config.getLang().KICK_BROADCAST().replaceAll("&player", name) + " (" + CheckType.getName(type) + ")";
                        if (msg.equals("")) continue;
                        manager.log(msg);
                        manager.playerLog(msg);
                        continue;
                    }
                    if (event.equalsIgnoreCase("WARN")) {
                        List message = warning;
                        for (String string : message) {
                            if (string.equals("")) continue;
                            user.getPlayer().sendMessage(RED + string);
                        }
                        continue;
                    }
                    if (event.equalsIgnoreCase("BAN")) {
                        if (AntiCheat.developerMode()) continue;
                        user.getPlayer().setBanned(true);
                        user.getPlayer().kickPlayer(RED + banReason);
                        msg = RED + config.getLang().BAN_BROADCAST().replaceAll("&player", name) + " (" + CheckType.getName(type) + ")";
                        if (msg.equals("")) continue;
                        manager.log(msg);
                        manager.playerLog(msg);
                        continue;
                    }
                    if (!event.equalsIgnoreCase("RESET")) continue;
                    user.resetLevel();
                }
            }
        });
    }

    static {
        GRAY = ChatColor.GRAY;
        GOLD = ChatColor.GOLD;
        RED = ChatColor.RED;
    }
}

