/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.manage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.check.CheckType;
import net.dynamicdev.anticheat.config.Configuration;
import net.dynamicdev.anticheat.manage.AntiCheatManager;
import net.dynamicdev.anticheat.util.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class CheckManager {
    private AntiCheatManager manager = null;
    private Configuration config;
    private static List<CheckType> checkIgnoreList = new ArrayList<CheckType>();
    private static Map<String, List<CheckType>> exemptList = new HashMap<String, List<CheckType>>();

    public CheckManager(AntiCheatManager manager) {
        this.manager = manager;
        this.config = manager.getConfiguration();
        block0: for (String string : this.config.getConfig().disabledChecks.getValue()) {
            for (CheckType type : CheckType.values()) {
                if (!type.toString().equalsIgnoreCase(string)) continue;
                checkIgnoreList.add(type);
                continue block0;
            }
        }
    }

    public void activateCheck(CheckType type, String className) {
        if (!this.isActive(type)) {
            this.manager.getLoggingManager().logFineInfo("The " + type.toString() + " check was activated by " + className + ".");
            checkIgnoreList.remove((Object)type);
        }
    }

    public void deactivateCheck(CheckType type, String className) {
        if (this.isActive(type)) {
            this.manager.getLoggingManager().logFineInfo("The " + type.toString() + " check was deactivated by " + className + ".");
            checkIgnoreList.add(type);
        }
    }

    public boolean isActive(CheckType type) {
        return !checkIgnoreList.contains((Object)type);
    }

    public void exemptPlayer(Player player, CheckType type, String className) {
        if (!this.isExempt(player, type)) {
            if (!exemptList.containsKey(player.getName())) {
                exemptList.put(player.getName(), new ArrayList());
            }
            this.manager.getLoggingManager().logFineInfo(player.getName() + " was exempted from the " + type.toString() + " check by " + className + ".");
            exemptList.get(player.getName()).add(type);
        }
    }

    public void unexemptPlayer(Player player, CheckType type, String className) {
        if (this.isExempt(player, type)) {
            this.manager.getLoggingManager().logFineInfo(player.getName() + " was unexempted from the " + type.toString() + " check by " + className + ".");
            exemptList.get(player.getName()).remove((Object)type);
        }
    }

    public boolean isExempt(Player player, CheckType type) {
        return exemptList.containsKey(player.getName()) ? exemptList.get(player.getName()).contains((Object)type) : false;
    }

    public boolean isOpExempt(Player player) {
        return this.manager.getConfiguration().getConfig().exemptOp.getValue() != false && player.isOp();
    }

    public boolean checkInWorld(Player player) {
        return !this.config.getConfig().disabledWorlds.getValue().contains(player.getWorld().getName());
    }

    public boolean willCheckQuick(Player player, CheckType type) {
        return this.isActive(type) && !this.isExempt(player, type) && !type.checkPermission(player) && !player.hasPermission(Permission.CHECK_EXEMPT.toString());
    }

    public boolean willCheck(Player player, CheckType type) {
        boolean check = this.isActive(type) && this.checkInWorld(player) && !this.isExempt(player, type) && !type.checkPermission(player) && !this.isOpExempt(player) && !player.hasPermission(Permission.CHECK_EXEMPT.toString());
        AntiCheat.debugLog("Check " + (Object)((Object)type) + (check ? " run " : " not run ") + "on " + player.getName());
        return check;
    }

    public boolean isOnline(Player player) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!p.getName().equals(player.getName())) continue;
            return true;
        }
        return false;
    }
}

