/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.manage;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.check.Backend;
import net.dynamicdev.anticheat.config.Configuration;
import net.dynamicdev.anticheat.manage.CheckManager;
import net.dynamicdev.anticheat.manage.LoggingManager;
import net.dynamicdev.anticheat.manage.UserManager;
import net.dynamicdev.anticheat.xray.XRayTracker;
import org.bukkit.plugin.RegisteredListener;

public class AntiCheatManager {
    private static AntiCheat plugin = null;
    private static Configuration configuration;
    private static XRayTracker xrayTracker;
    private static UserManager userManager;
    private static CheckManager checkManager;
    private static LoggingManager loggingManager;
    private static Backend backend;
    private static Map<String, RegisteredListener[]> eventchains;
    private static Map<String, Long> eventcache;

    public AntiCheatManager(AntiCheat instance, Logger logger) {
        plugin = instance;
        configuration = new Configuration(plugin, this);
        loggingManager = new LoggingManager(plugin, logger, configuration);
        xrayTracker = new XRayTracker();
        userManager = new UserManager(this);
        checkManager = new CheckManager(this);
        backend = new Backend(this);
    }

    public void log(String message) {
        loggingManager.log(message);
    }

    public void debugLog(String message) {
        loggingManager.debugLog(message);
    }

    public void playerLog(String message) {
        loggingManager.logToPlayers(message);
    }

    public void addEvent(String e, RegisteredListener[] arr) {
        if (!AntiCheatManager.configuration.getConfig().eventChains.getValue().booleanValue()) {
            return;
        }
        if (!eventcache.containsKey(e) || eventcache.get(e) > 30000L) {
            eventchains.put(e, arr);
            eventcache.put(e, System.currentTimeMillis());
        }
    }

    public String getEventChainReport() {
        String gen = "";
        if (!AntiCheatManager.configuration.getConfig().eventChains.getValue().booleanValue()) {
            return "Event Chains is disabled by the configuration.\n";
        }
        if (eventchains.entrySet().size() == 0) {
            return "No event chains found.\n";
        }
        for (Map.Entry<String, RegisteredListener[]> e : eventchains.entrySet()) {
            RegisteredListener[] reg;
            String toadd = "";
            String ename = e.getKey();
            toadd = toadd + ename + ":" + '\n';
            for (RegisteredListener plug : reg = e.getValue()) {
                String pluginname = plug.getPlugin().getName();
                if (pluginname.equals("AntiCheat")) {
                    pluginname = "self";
                }
                toadd = toadd + "- " + pluginname + '\n';
            }
            gen = gen + toadd + '\n';
        }
        return gen;
    }

    public AntiCheat getPlugin() {
        return plugin;
    }

    public Configuration getConfiguration() {
        return configuration;
    }

    public XRayTracker getXRayTracker() {
        return xrayTracker;
    }

    public UserManager getUserManager() {
        return userManager;
    }

    public CheckManager getCheckManager() {
        return checkManager;
    }

    public Backend getBackend() {
        return backend;
    }

    public LoggingManager getLoggingManager() {
        return loggingManager;
    }

    public static void close() {
        loggingManager.closeHandler();
        if (AntiCheatManager.configuration.getConfig().enterprise.getValue().booleanValue()) {
            AntiCheatManager.configuration.getEnterprise().database.shutdown();
        }
    }

    static {
        xrayTracker = null;
        userManager = null;
        checkManager = null;
        loggingManager = null;
        backend = null;
        eventchains = new ConcurrentHashMap<String, RegisteredListener[]>();
        eventcache = new ConcurrentHashMap<String, Long>();
    }
}

